/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.client.gui.machine;

import com.valkyrieofnight.environmentaltech.client.container.ContainerEmpty;
import com.valkyrieofnight.environmentaltech.network.PacketDispatcher;
import com.valkyrieofnight.environmentaltech.network.packets.terraformer.TFSettingsServerPacket;
import com.valkyrieofnight.environmentaltech.registry.terraformer.TerraformerSoftwareRegistry;
import com.valkyrieofnight.environmentaltech.tileentity.machines.TileTerraformer;
import com.valkyrieofnight.valkyrielib.client.SizableBox;
import com.valkyrieofnight.valkyrielib.client.TexUtils;
import com.valkyrieofnight.valkyrielib.gui.VLGuiResources;
import com.valkyrieofnight.valkyrielib.util.helpers.LanguageHelper;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTerraformer
extends GuiContainer {
    protected TileTerraformer tf;
    protected List<String> programIds;
    protected int currentSoftwareIndex;
    private int left;
    private int top;
    private GuiButton nextProgram;
    private GuiButton prevProgram;
    protected GuiButton redstoneRequired;
    private boolean updateServer = false;

    public GuiTerraformer(InventoryPlayer inv, TileTerraformer tile) {
        super((Container)new ContainerEmpty(inv, tile));
        this.tf = tile;
        this.field_146999_f = 192;
        this.field_147000_g = 128;
        this.programIds = TerraformerSoftwareRegistry.getInstance().getSoftwareNameList();
        this.currentSoftwareIndex = 0;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.left = (this.field_146294_l - this.field_146999_f) / 2;
        this.top = (this.field_146295_m - this.field_147000_g) / 2;
        this.prevProgram = new GuiButton(0, this.left + 10, this.top + 24, 10, 20, "<");
        this.field_146292_n.add(this.prevProgram);
        this.nextProgram = new GuiButton(1, this.left + 172, this.top + 24, 10, 20, ">");
        this.field_146292_n.add(this.nextProgram);
        this.redstoneRequired = new GuiButton(2, this.left + 10, this.top + 64, 56, 20, LanguageHelper.toLoc((String)"item.redstone.name"));
        this.field_146292_n.add(this.redstoneRequired);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                this.tf.setSoftware(this.programIds.get(this.getNextIndex(-1)));
                break;
            }
            case 1: {
                this.tf.setSoftware(this.programIds.get(this.getNextIndex(1)));
            }
        }
        this.updateServer = true;
    }

    public int getNextIndex(int dir) {
        if (this.currentSoftwareIndex + dir < 0) {
            return this.programIds.size() - 1;
        }
        if (this.currentSoftwareIndex + dir >= this.programIds.size()) {
            return 0;
        }
        return this.currentSoftwareIndex + dir;
    }

    public void func_73876_c() {
        super.func_73876_c();
        String csw = this.tf.getCurrentSoftware();
        this.currentSoftwareIndex = this.programIds.indexOf(csw);
        if (this.updateServer) {
            this.updateServer = false;
            PacketDispatcher.DISPATCHER.sendToServer((IMessage)new TFSettingsServerPacket(this.tf));
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_175065_a(LanguageHelper.toLoc((String)"gui.environmentaltech.terraformer.title"), 10.0f, 8.0f, 0x333333, false);
        String swt = this.tf.getCurrentSoftwareLocalized();
        int sww = this.field_146289_q.func_78256_a(swt);
        this.field_146289_q.func_175065_a(swt, (float)(96 - sww / 2), 30.0f, 0, false);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TexUtils.renderSizableBox((SizableBox)VLGuiResources.GUI_STYLE_1, (GuiContainer)this, (int)this.field_147003_i, (int)this.field_147009_r, (int)this.field_146999_f, (int)this.field_147000_g);
        TexUtils.renderSizableBox((SizableBox)VLGuiResources.SEARCH_STYLE_2, (GuiContainer)this, (int)(this.left + 20), (int)(this.top + 24), (int)152, (int)20);
    }
}

