/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.client.gui;

import com.valkyrieofnight.environmentaltech.container.ContainerEmpty;
import com.valkyrieofnight.environmentaltech.network.PacketDispatcher;
import com.valkyrieofnight.environmentaltech.network.packets.launcher.LauncherSettingsServerPacket;
import com.valkyrieofnight.environmentaltech.tileentity.machines.launcher.TileLauncher;
import com.valkyrieofnight.valkyrielib.gui.VLGuiResources;
import com.valkyrieofnight.valkyrielib.gui.client.VLGuiContainer;
import com.valkyrieofnight.valkyrielib.gui.client.elements.VLElement;
import com.valkyrieofnight.valkyrielib.gui.client.elements.VLElementButton;
import com.valkyrieofnight.valkyrielib.gui.client.elements.VLElementProgressVert;
import com.valkyrieofnight.valkyrielib.gui.container.VLContainer;
import com.valkyrieofnight.valkyrielib.util.helpers.ColorUtil;
import com.valkyrieofnight.valkyrielib.util.helpers.LanguageHelper;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiLauncher
extends VLGuiContainer {
    private static final float increment = 0.1f;
    private static final float incrementShift = 1.0f;
    protected VLElementButton nsForceP;
    protected VLElementButton nsForceM;
    protected VLElementButton ewForceP;
    protected VLElementButton ewForceM;
    protected VLElementButton upForceP;
    protected VLElementButton upForceM;
    protected VLElementButton redstoneRequired;
    protected VLElementButton overrideVelocity;
    protected VLElementProgressVert energy;
    protected TileLauncher tile;
    private int left;
    private int top;
    private EntityPlayer player;
    private boolean shift = false;
    private boolean updateServer;
    private String vadd;
    private String vset;
    private String rtrue;
    private String rfalse;

    public GuiLauncher(InventoryPlayer inv, TileLauncher tl) {
        super((VLContainer)new ContainerEmpty(inv, tl), 192, 128, VLGuiResources.GUI_STYLE_1);
        this.tile = tl;
        this.player = inv.field_70458_d;
        this.vadd = LanguageHelper.toLoc((String)"gui.environmentaltech.add");
        this.vset = LanguageHelper.toLoc((String)"gui.environmentaltech.set");
        this.rtrue = LanguageHelper.toLoc((String)"gui.environmentaltech.true");
        this.rfalse = LanguageHelper.toLoc((String)"gui.environmentaltech.false");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.left = (this.field_146294_l - this.field_146999_f) / 2;
        this.top = (this.field_146295_m - this.field_147000_g) / 2;
    }

    public void initElements() {
        int buttonWidth = 10;
        int buttonHeight = 10;
        int ajustmentSpacingMiddle = 24;
        int ajustmentButtonY = 108;
        this.ewForceM = new VLElementButton((VLGuiContainer)this, 10, ajustmentButtonY, buttonWidth, buttonHeight, "-");
        this.addElement((VLElement)this.ewForceM);
        this.ewForceP = new VLElementButton((VLGuiContainer)this, 48, ajustmentButtonY, buttonWidth, buttonHeight, "+");
        this.addElement((VLElement)this.ewForceP);
        this.nsForceM = new VLElementButton((VLGuiContainer)this, 72, ajustmentButtonY, buttonWidth, buttonHeight, "-");
        this.addElement((VLElement)this.nsForceM);
        this.nsForceP = new VLElementButton((VLGuiContainer)this, 110, ajustmentButtonY, buttonWidth, buttonHeight, "+");
        this.addElement((VLElement)this.nsForceP);
        this.upForceM = new VLElementButton((VLGuiContainer)this, 134, ajustmentButtonY, buttonWidth, buttonHeight, "-");
        this.addElement((VLElement)this.upForceM);
        this.upForceP = new VLElementButton((VLGuiContainer)this, 172, ajustmentButtonY, buttonWidth, buttonHeight, "+");
        this.addElement((VLElement)this.upForceP);
        this.redstoneRequired = new VLElementButton((VLGuiContainer)this, 38, 28, 56, 20, LanguageHelper.toLoc((String)"item.redstone.name"));
        this.addElement((VLElement)this.redstoneRequired);
        this.overrideVelocity = new VLElementButton((VLGuiContainer)this, 38, 54, 56, 20, LanguageHelper.toLoc((String)"gui.environmentaltech.velocity"));
        this.addElement((VLElement)this.overrideVelocity);
        this.energy = new VLElementProgressVert((VLGuiContainer)this, ColorUtil.calcMCColor((int)196, (int)16, (int)16, (int)255), VLGuiResources.ENERGY_OVERLAY_1, 10, 24);
        this.addElement((VLElement)this.energy);
    }

    public void func_146282_l() throws IOException {
        this.shift = Keyboard.isKeyDown((int)42);
        super.func_146282_l();
    }

    public void mouseClicked(VLElement e) {
        int id;
        if (e == null) {
            return;
        }
        float inc = 0.1f;
        if (this.shift) {
            inc = 1.0f;
        }
        if ((id = e.getID()) == this.ewForceM.getID()) {
            this.tile.setForceEastWest(this.tile.getForceEastWest() - inc);
        } else if (id == this.ewForceP.getID()) {
            this.tile.setForceEastWest(this.tile.getForceEastWest() + inc);
        } else if (id == this.nsForceM.getID()) {
            this.tile.setForceNorthSouth(this.tile.getForceNorthSouth() - inc);
        } else if (id == this.nsForceP.getID()) {
            this.tile.setForceNorthSouth(this.tile.getForceNorthSouth() + inc);
        } else if (id == this.upForceM.getID()) {
            this.tile.setForceUp(this.tile.getForceUp() - inc);
        } else if (id == this.upForceP.getID()) {
            this.tile.setForceUp(this.tile.getForceUp() + inc);
        } else if (id == this.redstoneRequired.getID()) {
            this.tile.setRequiresRestone(!this.tile.getRequiresRedstone());
        } else if (id == this.overrideVelocity.getID()) {
            this.tile.setOverrideVelocity(!this.tile.getOverrideVelocity());
        }
        this.updateServer = true;
    }

    protected void checkAndLock() {
        if (this.tile.isMaxNorthForce()) {
            this.nsForceP.setEnabled(false);
        } else {
            this.nsForceP.setEnabled(true);
        }
        if (this.tile.isMaxSouthForce()) {
            this.nsForceM.setEnabled(false);
        } else {
            this.nsForceM.setEnabled(true);
        }
        if (this.tile.isMaxEastForce()) {
            this.ewForceP.setEnabled(false);
        } else {
            this.ewForceP.setEnabled(true);
        }
        if (this.tile.isMaxWestForce()) {
            this.ewForceM.setEnabled(false);
        } else {
            this.ewForceM.setEnabled(true);
        }
        if (this.tile.isMaxUpForce()) {
            this.upForceP.setEnabled(false);
        } else {
            this.upForceP.setEnabled(true);
        }
        if (this.tile.isMinUpForce()) {
            this.upForceM.setEnabled(false);
        } else {
            this.upForceM.setEnabled(true);
        }
    }

    public void func_73876_c() {
        this.checkAndLock();
        if (this.updateServer) {
            this.updateServer = false;
            PacketDispatcher.DISPATCHER.sendToServer((IMessage)new LauncherSettingsServerPacket(this.tile));
        }
        this.energy.updateProgress(this.tile.getEnergyScale());
        ArrayList<String> energyLevelTT = new ArrayList<String>();
        energyLevelTT.add(ColorUtil.BLUE + LanguageHelper.toLoc((String)"gui.simplegenerators.energy"));
        energyLevelTT.add(ColorUtil.WHITE + LanguageHelper.toLoc((String)"gui.simplegenerators.capacity") + ": " + String.format("%,d", this.tile.getMaxEnergyStored(EnumFacing.UP)));
        energyLevelTT.add(ColorUtil.WHITE + LanguageHelper.toLoc((String)"gui.simplegenerators.stored") + ": " + String.format("%,d", this.tile.getEnergyStored(EnumFacing.UP)));
        this.energy.setToolTipList(energyLevelTT);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.field_146289_q.func_175065_a(LanguageHelper.toLoc((String)"gui.environmentaltech.launcher.title"), (float)(this.field_147003_i + 10), (float)(this.field_147009_r + 8), 0x333333, false);
        String ewt = LanguageHelper.toLoc((String)"gui.environmentaltech.launcher.xforce");
        int ewtw = this.field_146289_q.func_78256_a(ewt);
        this.field_146289_q.func_78276_b(ewt, this.field_147003_i + 35 - ewtw / 2, this.field_147009_r + 89, 0);
        String ews = this.tile.getForceEastWest() + "";
        int eww = this.field_146289_q.func_78256_a(ews);
        this.field_146289_q.func_78276_b(ews, this.field_147003_i + 35 - eww / 2, this.field_147009_r + 109, 0);
        String nwt = LanguageHelper.toLoc((String)"gui.environmentaltech.launcher.zforce");
        int nwtw = this.field_146289_q.func_78256_a(nwt);
        this.field_146289_q.func_78276_b(nwt, this.field_147003_i + 97 - nwtw / 2, this.field_147009_r + 89, 0);
        String nss = this.tile.getForceNorthSouth() + "";
        int nsw = this.field_146289_q.func_78256_a(nss);
        this.field_146289_q.func_78276_b(nss, this.field_147003_i + 97 - nsw / 2, this.field_147009_r + 109, 0);
        String upt = LanguageHelper.toLoc((String)"gui.environmentaltech.launcher.yforce");
        int uptw = this.field_146289_q.func_78256_a(upt);
        this.field_146289_q.func_78276_b(upt, this.field_147003_i + 159 - uptw / 2, this.field_147009_r + 89, 0);
        String ups = this.tile.getForceUp() + "";
        int upw = this.field_146289_q.func_78256_a(ups);
        this.field_146289_q.func_78276_b(ups, this.field_147003_i + 159 - upw / 2, this.field_147009_r + 109, 0);
        String rstr = "";
        rstr = this.tile.getRequiresRedstone() ? this.rtrue : this.rfalse;
        this.field_146289_q.func_78276_b(rstr, this.field_147003_i + 104, this.field_147009_r + 35, 0);
        String vstr = "";
        vstr = this.tile.getOverrideVelocity() ? this.vset : this.vadd;
        this.field_146289_q.func_78276_b(vstr, this.field_147003_i + 104, this.field_147009_r + 61, 0);
    }
}

