/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.StringUtils;

public class NBTHelper {
    public static NBTTagCompound getPersistentTag(EntityPlayer player) {
        return NBTHelper.getOrInitTagCompound(player.getEntityData(), "PlayerPersisted", null);
    }

    public static NBTTagCompound getOrInitTagCompound(NBTTagCompound parent, String key) {
        return NBTHelper.getOrInitTagCompound(parent, key, null);
    }

    public static NBTTagCompound getOrInitTagCompound(NBTTagCompound parent, String key, NBTTagCompound defaultTag) {
        if (parent.func_150297_b(key, 10)) {
            return parent.func_74775_l(key);
        }
        defaultTag = defaultTag == null ? new NBTTagCompound() : defaultTag.func_74737_b();
        parent.func_74782_a(key, (NBTBase)defaultTag);
        return defaultTag;
    }

    public static NBTTagCompound proifleToNBT(GameProfile profile) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", profile.getName());
        UUID id = profile.getId();
        if (id != null) {
            tag.func_74772_a("UUIDL", id.getLeastSignificantBits());
            tag.func_74772_a("UUIDU", id.getMostSignificantBits());
        }
        return tag;
    }

    public static GameProfile profileFromNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("Name");
        UUID uuid = null;
        if (tag.func_74764_b("UUIDL")) {
            uuid = new UUID(tag.func_74763_f("UUIDU"), tag.func_74763_f("UUIDL"));
        } else if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return new GameProfile(uuid, name);
    }

    public static Iterable<NBTTagCompound> iterateNBTTagList(final NBTTagList list) {
        return new Iterable<NBTTagCompound>(){

            @Override
            public Iterator<NBTTagCompound> iterator() {
                return new Iterator<NBTTagCompound>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < list.func_74745_c();
                    }

                    @Override
                    public NBTTagCompound next() {
                        return list.func_150305_b(this.i++);
                    }

                    @Override
                    public void remove() {
                        list.func_74744_a(this.i--);
                    }
                };
            }
        };
    }

    public static NBTTagCompound getOrInitTagCompound(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            return tags;
        }
        tags = new NBTTagCompound();
        stack.func_77982_d(tags);
        return tags;
    }

    public static boolean hasPersistantNBT(Entity entity) {
        return entity.getEntityData().func_150297_b("PlayerPersisted", 10);
    }

    public static NBTTagCompound getPersistantNBT(Entity entity) {
        NBTTagCompound t = entity.getEntityData();
        return NBTHelper.getOrInitTagCompound(t, "PlayerPersisted");
    }

    public static NBTTagCompound blockPosToNBT(BlockPos pos) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", pos.func_177958_n());
        nbt.func_74774_a("y", (byte)pos.func_177956_o());
        nbt.func_74768_a("z", pos.func_177952_p());
        return nbt;
    }

    public static BlockPos nbtToBlockPos(NBTTagCompound nbt) {
        int x = nbt.func_74762_e("x");
        int y = nbt.func_74771_c("y") & 0xFF;
        int z = nbt.func_74762_e("z");
        return new BlockPos(x, y, z);
    }

    public static <T extends NBTBase> void deserializeSubTag(INBTSerializable<T> serializable, NBTTagCompound parent, String key) {
        NBTBase tag = parent.func_74781_a(key);
        if (tag != null) {
            serializable.deserializeNBT(tag);
        }
    }
}

