/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.utils.XURandom;
import com.rwtema.extrautils2.utils.datastructures.FunctionABBool;
import gnu.trove.list.array.TCharArrayList;
import gnu.trove.strategy.HashingStrategy;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class CollectionHelper {
    public static final char[] CHAR_DIGITS;
    public static final String[] STRING_DIGITS;
    public static HashingStrategy<ItemStack> HASHING_STRATEGY_ITEMSTACK_ITEM;
    public static HashingStrategy<ItemStack> HASHING_STRATEGY_ITEMSTACK;

    public static <K, V> HashMap<K, V> newHashMap(Object ... objects) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            map.put(objects[i], objects[i + 1]);
        }
        return map;
    }

    public static <K, V> ImmutableMap<K, V> newConstMap(Object ... objects) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < objects.length; i += 2) {
            builder.put(objects[i], objects[i + 1]);
        }
        return builder.build();
    }

    public static <T> Iterable<T> removeNulls(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<T> iterator;
                    T next;
                    {
                        this.iterator = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.next == null) {
                            if (!this.iterator.hasNext()) {
                                return false;
                            }
                            this.next = this.iterator.next();
                        }
                        return true;
                    }

                    @Override
                    public T next() {
                        return this.next;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static <K, V, T extends Map<K, V>> T populateMap(T map, Object ... objects) {
        for (int i = 0; i < objects.length; i += 2) {
            map.put((Object)objects[i], (Object)objects[i + 1]);
        }
        return map;
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> populateEnumMap(Class<K> clazz, Function<K, V> function) {
        EnumMap<Enum, Object> map = new EnumMap<Enum, Object>(clazz);
        for (Enum k : (Enum[])clazz.getEnumConstants()) {
            map.put(k, function.apply((Object)k));
        }
        return map;
    }

    public static <K extends Enum<K>> EnumMap<K, EnumSet<K>> populateEnumMultiMap(Class<K> clazz, FunctionABBool<K, K> function) {
        EnumMap<Enum, EnumSet<K>> map = new EnumMap<Enum, EnumSet<K>>(clazz);
        for (Enum input : (Enum[])clazz.getEnumConstants()) {
            EnumSet<K> set = EnumSet.noneOf(clazz);
            for (Enum k2 : (Enum[])clazz.getEnumConstants()) {
                if (!function.apply(input, k2)) continue;
                set.add(k2);
            }
            map.put(input, set);
        }
        return map;
    }

    public static <K> K getRandomElement(Iterable<K> iterable) {
        return CollectionHelper.getRandomElement(iterable, XURandom.rand);
    }

    public static <K> K getRandomElement(Iterable<K> iterable, Random rand) {
        K r = null;
        int t = 0;
        for (K k : iterable) {
            if (++t != 1 && rand.nextInt(t) != 0) continue;
            r = k;
        }
        return r;
    }

    static {
        int i;
        HASHING_STRATEGY_ITEMSTACK_ITEM = new HashingStrategy<ItemStack>(){

            public int computeHashCode(ItemStack object) {
                if (object == null || object.func_77973_b() == null) {
                    return 0;
                }
                return object.func_77973_b().hashCode();
            }

            public boolean equals(ItemStack o1, ItemStack o2) {
                return o1 == o2 || o1 != null && o2 != null && o1.func_77973_b() == o2.func_77973_b();
            }
        };
        HASHING_STRATEGY_ITEMSTACK = new HashingStrategy<ItemStack>(){

            public int computeHashCode(ItemStack object) {
                if (object == null || object.func_77973_b() == null) {
                    return 0;
                }
                return object.func_77973_b().hashCode() * 31 + object.func_77952_i();
            }

            public boolean equals(ItemStack o1, ItemStack o2) {
                return o1 == o2 || o1 != null && o2 != null && o1.func_77973_b() == o2.func_77973_b() && o1.func_77952_i() == o2.func_77952_i();
            }
        };
        TCharArrayList chars = new TCharArrayList(62);
        for (i = 0; i < 10; ++i) {
            chars.add((char)(48 + i));
        }
        for (i = 0; i < 26; ++i) {
            chars.add((char)(97 + i));
        }
        for (i = 0; i < 26; ++i) {
            chars.add((char)(65 + i));
        }
        chars.addAll(new char[]{'_', '-', '=', '+', '%', '@', '!', '?', '*', '^', '$', '&', '#', '~', ':', ';'});
        CHAR_DIGITS = chars.toArray();
        STRING_DIGITS = new String[CHAR_DIGITS.length];
        for (i = 0; i < STRING_DIGITS.length; ++i) {
            CollectionHelper.STRING_DIGITS[i] = String.valueOf(CHAR_DIGITS[i]);
        }
    }
}

