/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class NBTSerializable {

    public static abstract class NBTObject<V, V_NBT extends NBTBase>
    implements INBTSerializable<V_NBT> {
        public V value;

        public NBTObject(V value) {
            this.value = value;
        }

        public V_NBT serializeNBT() {
            return this.serialize(this.value);
        }

        protected abstract V_NBT serialize(V var1);

        public void deserializeNBT(V_NBT nbt) {
            this.value = this.deserialize(nbt);
        }

        protected abstract V deserialize(V_NBT var1);
    }

    public static class NBTArrayListSerializable<V, V_NBT extends NBTBase>
    implements INBTSerializable<NBTTagList> {
        public final ArrayList<V> list = new ArrayList();
        private final Function<V, V_NBT> serializer;
        private final Function<V_NBT, V> deserializer;

        public NBTArrayListSerializable(Function<V, V_NBT> serializer, Function<V_NBT, V> deserializer) {
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        public NBTTagList serializeNBT() {
            NBTTagList nbtTagList = new NBTTagList();
            for (V v : this.list) {
                nbtTagList.func_74742_a((NBTBase)this.serializer.apply(v));
            }
            return nbtTagList;
        }

        public void deserializeNBT(NBTTagList nbt) {
            this.list.clear();
            for (int i = 0; i < nbt.func_74745_c(); ++i) {
                this.list.add(this.deserializer.apply(nbt.func_179238_g(i)));
            }
        }
    }

    public static class NBTResourceLocationSerializable
    implements INBTSerializable<NBTTagString> {
        ResourceLocation location;

        public NBTResourceLocationSerializable(ResourceLocation location) {
            this.location = location;
        }

        @Nonnull
        public static NBTTagString serialize(ResourceLocation location) {
            return location != null ? new NBTTagString(location.toString()) : new NBTTagString();
        }

        @Nullable
        public static ResourceLocation deserialize(NBTTagString nbt) {
            String s = nbt.func_150285_a_();
            return !s.isEmpty() ? new ResourceLocation(s) : null;
        }

        public NBTTagString serializeNBT() {
            return NBTResourceLocationSerializable.serialize(this.location);
        }

        public void deserializeNBT(NBTTagString nbt) {
            this.location = NBTResourceLocationSerializable.deserialize(nbt);
        }
    }

    public static class RegisteredValue<V extends IForgeRegistryEntry<V>>
    implements INBTSerializable<NBTTagString> {
        final RegistryNamespaced<ResourceLocation, V> registry;
        public V value;

        public RegisteredValue(RegistryNamespaced<ResourceLocation, V> registry) {
            this.registry = registry;
            if (registry instanceof FMLControlledNamespacedRegistry) {
                this.value = ((FMLControlledNamespacedRegistry)registry).getDefaultValue();
            }
        }

        public NBTTagString serializeNBT() {
            return NBTResourceLocationSerializable.serialize((ResourceLocation)this.registry.func_177774_c(this.value));
        }

        public void deserializeNBT(NBTTagString nbt) {
            ResourceLocation location = NBTResourceLocationSerializable.deserialize(nbt);
            this.value = location == null ? null : (IForgeRegistryEntry)this.registry.func_82594_a((Object)location);
        }
    }

    public static class HashMapSerializable<K, V, V_NBT extends NBTBase>
    implements INBTSerializable<NBTTagCompound> {
        public final HashMap<K, V> map = new HashMap();
        private final Function<V, V_NBT> val_serializer;
        private final Function<V_NBT, V> val_deserializer;
        private final Function<K, String> key_serializer;
        private final Function<String, K> key_deserializer;

        public HashMapSerializable(Function<K, String> key_serializer, Function<String, K> key_deserializer, Function<V, V_NBT> val_serializer, Function<V_NBT, V> val_deserializer) {
            this.val_serializer = val_serializer;
            this.val_deserializer = val_deserializer;
            this.key_serializer = key_serializer;
            this.key_deserializer = key_deserializer;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                nbt.func_74782_a(this.key_serializer.apply(entry.getKey()), (NBTBase)this.val_serializer.apply(entry.getValue()));
            }
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.map.clear();
            for (String s : nbt.func_150296_c()) {
                this.map.put(this.key_deserializer.apply(s), this.val_deserializer.apply(nbt.func_74781_a(s)));
            }
        }
    }

    public static abstract class NBTNullable<T extends INBTSerializable<NBTTagCompound>>
    implements INBTSerializable<NBTBase> {
        T value;

        public NBTBase serializeNBT() {
            if (this.value == null) {
                return new NBTTagByte(0);
            }
            return this.value.serializeNBT();
        }

        public void deserializeNBT(NBTBase nbt) {
            if (nbt.func_74732_a() != 10) {
                this.value = null;
            } else {
                this.value = this.newBlankValue();
                this.value.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
            }
        }

        public abstract T newBlankValue();
    }

    public static class NBTStack
    implements INBTSerializable<NBTBase> {
        ItemStack value;

        public void setStackRaw(ItemStack other) {
            this.value = other;
        }

        public void setStackCopy(ItemStack other) {
            this.value = ItemStack.func_77944_b((ItemStack)other);
        }

        public NBTBase serializeNBT() {
            if (this.value == null) {
                return new NBTTagByte(0);
            }
            return this.value.serializeNBT();
        }

        public void deserializeNBT(NBTBase nbt) {
            this.value = nbt.func_74732_a() == 10 ? ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt)) : null;
        }

        public ItemStack getRaw() {
            return this.value;
        }

        public ItemStack getCopy() {
            return ItemStack.func_77944_b((ItemStack)this.value);
        }

        public boolean isNull() {
            return this.value == null;
        }
    }

    public static class NBTEnum<T extends Enum<T>>
    implements INBTSerializable<NBTTagShort> {
        @Nonnull
        public T value;

        public NBTEnum(@Nonnull T value) {
            this.value = value;
        }

        public NBTTagShort serializeNBT() {
            return new NBTTagShort((short)((Enum)this.value).ordinal());
        }

        public void deserializeNBT(NBTTagShort nbt) {
            Class<?> aClass = this.value.getClass();
            Enum[] enumConstants = (Enum[])aClass.getEnumConstants();
            short i = nbt.func_150289_e();
            this.value = enumConstants[i];
        }
    }

    public static class NBTEnumNullable<T extends Enum<T>>
    implements INBTSerializable<NBTTagShort> {
        private final Class<T> clazz;
        public T value = null;

        public NBTEnumNullable(Class<T> clazz) {
            this.clazz = clazz;
        }

        public NBTTagShort serializeNBT() {
            return new NBTTagShort(this.value == null ? (short)-1 : (short)((Enum)this.value).ordinal());
        }

        public void deserializeNBT(NBTTagShort nbt) {
            Enum[] enumConstants = (Enum[])this.clazz.getEnumConstants();
            short i = nbt.func_150289_e();
            this.value = i == -1 ? null : enumConstants[i];
        }
    }

    public static class NBTBoolean
    implements INBTSerializable<NBTTagByte> {
        public boolean value;

        public NBTBoolean() {
            this(false);
        }

        public NBTBoolean(boolean value) {
            this.value = value;
        }

        public NBTTagByte serializeNBT() {
            return new NBTTagByte(this.value ? (byte)1 : 0);
        }

        public void deserializeNBT(NBTTagByte nbt) {
            this.value = nbt.func_150290_f() != 0;
        }
    }

    public static class NBTDouble
    implements INBTSerializable<NBTTagDouble> {
        public double value;

        public NBTDouble(double value) {
            this.value = value;
        }

        public NBTTagDouble serializeNBT() {
            return new NBTTagDouble(this.value);
        }

        public void deserializeNBT(NBTTagDouble nbt) {
            this.value = nbt.func_150286_g();
        }
    }

    public static class Float
    implements INBTSerializable<NBTTagFloat> {
        public float value;

        public Float() {
        }

        public Float(float value) {
            this.value = value;
        }

        public NBTTagFloat serializeNBT() {
            return new NBTTagFloat(this.value);
        }

        public void deserializeNBT(NBTTagFloat nbt) {
            this.value = nbt.func_150288_h();
        }
    }

    public static class Int
    implements INBTSerializable<NBTTagInt> {
        public int value;

        public Int(int value) {
            this.value = value;
        }

        public Int() {
        }

        @Nonnull
        public static NBTTagInt serialize(int value) {
            return new NBTTagInt(value);
        }

        public static int deserialize(NBTTagInt nbt) {
            return nbt.func_150287_d();
        }

        public NBTTagInt serializeNBT() {
            return Int.serialize(this.value);
        }

        public void deserializeNBT(NBTTagInt nbt) {
            this.value = Int.deserialize(nbt);
        }
    }

    public static class Text
    implements INBTSerializable<NBTTagString> {
        @Nonnull
        String s;

        public Text(@Nonnull String s) {
            this.s = s;
        }

        @Nonnull
        public static NBTTagString serialize(String s) {
            return new NBTTagString(s);
        }

        public NBTTagString serializeNBT() {
            return Text.serialize(this.s);
        }

        public void deserializeNBT(NBTTagString nbt) {
            this.s = this.deserialize(nbt);
        }

        @Nonnull
        public String deserialize(NBTTagString nbt) {
            return nbt.func_150285_a_();
        }
    }
}

