/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.transfernodes.IUpgradeProvider;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import net.minecraft.item.ItemStack;

public enum Upgrade {
    STACK_SIZE(1, 5.0f),
    SPEED(20, 1.0f),
    MINING(1, 10.0f);

    static final float PENALTY = 0.26666668f;
    public final int maxLevel;
    public final float power;

    private Upgrade(int maxLevel, float power) {
        this.maxLevel = maxLevel;
        this.power = power;
    }

    public static void addTooltip(List<String> tooltip, ItemStack stack) {
        Upgrade.addTooltip(tooltip, ((IUpgradeProvider)stack.func_77973_b()).getUpgrades(stack));
    }

    protected static void addTooltip(List<String> tooltip, Upgrade upgrade) {
        tooltip.add(Lang.translateArgs("Max Upgrades: %s", upgrade.maxLevel));
    }

    public int getModifierLevel(int level) {
        return level;
    }

    public float getPowerUse(int level) {
        if (level == 1) {
            return 1.0f;
        }
        float v = (float)Math.round((float)(100 * level) * (1.0f + (float)level * 0.26666668f) / 1.2666667f) / 100.0f;
        return v * this.power;
    }
}

