/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.transfernodes.TileIndexer;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ItemIndexerRemote
extends XUItemFlatMetadata
implements IDynamicHandler {
    public ItemIndexerRemote() {
        super("indexer_remote");
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return worldIn.func_175625_s(pos) instanceof TileIndexer ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        TileEntity entity = worldIn.func_175625_s(pos);
        if (!(entity instanceof TileIndexer)) {
            return EnumActionResult.FAIL;
        }
        TileIndexer indexer = (TileIndexer)entity;
        if (!indexer.isValidPlayer(playerIn)) {
            return EnumActionResult.SUCCESS;
        }
        NBTTagCompound nbt = NBTHelper.getOrInitTagCompound(stack);
        nbt.func_74768_a("Dimension", worldIn.field_73011_w.getDimension());
        nbt.func_74782_a("BlockPos", (NBTBase)NBTHelper.blockPosToNBT(pos));
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (worldIn.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        if (!itemStackIn.func_77942_o()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
        }
        NBTTagCompound nbt = itemStackIn.func_77978_p();
        int dimension = nbt.func_74762_e("Dimension");
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            playerIn.func_146105_b((ITextComponent)Lang.chat("Unable to contact indexer", new Object[0]));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
        }
        BlockPos blockPos = NBTHelper.nbtToBlockPos(nbt.func_74775_l("BlockPos"));
        if (!world.func_175667_e(blockPos)) {
            playerIn.func_146105_b((ITextComponent)Lang.chat("Unable to contact indexer", new Object[0]));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
        }
        TileEntity tile = world.func_175625_s(blockPos);
        if (!(tile instanceof TileIndexer)) {
            playerIn.func_146105_b((ITextComponent)Lang.chat("Unable to contact indexer", new Object[0]));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
        }
        if (((TileIndexer)tile).isValidPlayer(playerIn)) {
            playerIn.openGui((Object)ExtraUtils2.instance, -1, (World)world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        TileIndexer indexer;
        BlockPos pos = new BlockPos(x, y, z);
        if (world.field_72995_K) {
            indexer = new TileIndexer();
            indexer.func_145834_a(world);
            indexer.func_174878_a(pos);
        } else {
            if (!world.func_175667_e(pos)) {
                return null;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileIndexer)) {
                return null;
            }
            indexer = (TileIndexer)tile;
            indexer.positionsHash = 0L;
            indexer.reload();
        }
        return new TileIndexer.ContainerIndexer(indexer, player, 2);
    }
}

