/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerFilter;
import com.rwtema.extrautils2.transfernodes.Grocket;
import com.rwtema.extrautils2.transfernodes.GrocketType;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class GrocketTransferFilter
extends Grocket
implements IDynamicHandler {
    public SingleStackHandlerFilter.EitherFilter filter = this.registerNBT("filter", new SingleStackHandlerFilter.EitherFilter());
    public NBTSerializable.NBTEnum<LIMIT> limit = this.registerNBT("limit", new NBTSerializable.NBTEnum<LIMIT>(LIMIT.Unlimited));

    @Override
    public <T> T getInterface(TileEntity tileEntity, CapGetter<T> capability) {
        IFluidHandler handler;
        if (capability == CapGetter.FluidHandler && (handler = CapGetter.FluidHandler.getInterface((ICapabilityProvider)tileEntity, this.side.func_176734_d())) != null) {
            return (T)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return handler.getTankProperties();
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (resource == null || !GrocketTransferFilter.this.filter.matches(resource)) {
                        return 0;
                    }
                    return handler.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (resource == null || !GrocketTransferFilter.this.filter.matches(resource)) {
                        return null;
                    }
                    return handler.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (maxDrain == 0) {
                        return null;
                    }
                    FluidStack drain = handler.drain(maxDrain, false);
                    if (drain == null || !GrocketTransferFilter.this.filter.matches(drain)) {
                        return null;
                    }
                    if (doDrain) {
                        return handler.drain(maxDrain, true);
                    }
                    return drain;
                }
            };
        }
        if (capability == CapGetter.ItemHandler && (handler = CapGetter.ItemHandler.getInterface((ICapabilityProvider)tileEntity, this.side.func_176734_d())) != null) {
            return (T)new IItemHandler((IItemHandler)handler){
                final /* synthetic */ IItemHandler val$handler;
                {
                    this.val$handler = iItemHandler;
                }

                public int getSlots() {
                    return this.val$handler.getSlots();
                }

                public ItemStack getStackInSlot(int slot) {
                    return this.val$handler.getStackInSlot(slot);
                }

                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    ItemStack test;
                    if (stack == null) {
                        return null;
                    }
                    if (!GrocketTransferFilter.this.filter.matches(stack)) {
                        return stack;
                    }
                    LIMIT limit = (LIMIT)((Object)GrocketTransferFilter.this.limit.value);
                    if (limit == LIMIT.Unlimited) {
                        return this.val$handler.insertItem(slot, stack, simulate);
                    }
                    if (limit == LIMIT.Single ? this.val$handler.getStackInSlot(slot) != null : (test = this.val$handler.insertItem(slot, stack, true)) == stack || test != null && test.field_77994_a == stack.field_77994_a) {
                        return stack;
                    }
                    for (int i = 0; i < this.val$handler.getSlots(); ++i) {
                        ItemStack stackInSlot;
                        if (i == slot || (stackInSlot = this.val$handler.getStackInSlot(i)) == null || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stack)) continue;
                        return stack;
                    }
                    if (limit == LIMIT.Single && stack.field_77994_a > 1) {
                        boolean success;
                        ItemStack singleVariant = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
                        boolean bl = success = this.val$handler.insertItem(slot, singleVariant, simulate) == null;
                        if (success) {
                            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - 1));
                        }
                        return stack;
                    }
                    return this.val$handler.insertItem(slot, stack, simulate);
                }

                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (amount == 0) {
                        return null;
                    }
                    ItemStack itemStack = this.val$handler.extractItem(slot, amount, true);
                    if (itemStack == null) {
                        return null;
                    }
                    if (!GrocketTransferFilter.this.filter.matches(itemStack)) {
                        return null;
                    }
                    if (simulate) {
                        return itemStack;
                    }
                    return this.val$handler.extractItem(slot, amount, false);
                }
            };
        }
        return super.getInterface(tileEntity, capability);
    }

    @Override
    public GrocketType getType() {
        return GrocketType.FILTER_ITEMS;
    }

    @Override
    public float getPower() {
        return Float.NaN;
    }

    @Override
    public boolean onActivated(EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.holder.func_145831_w().field_72995_K) {
            this.holder.openGui(playerIn, this);
        }
        return true;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new TransferNodeContainer(player);
    }

    public class TransferNodeContainer
    extends DynamicContainerTile {
        public TransferNodeContainer(EntityPlayer player) {
            super(GrocketTransferFilter.this.holder);
            this.addTitle("Transfer Filter");
            this.crop();
            this.addWidget(GrocketTransferFilter.this.filter.newSlot(4, this.height + 4));
            this.addWidget((IWidget)((WidgetClickMCButtonChoices)((WidgetClickMCButtonChoices)new WidgetClickMCButtonChoices<LIMIT>(26, this.height + 4){

                @Override
                protected void onSelectedServer(LIMIT marker) {
                    GrocketTransferFilter.this.limit.value = marker;
                    GrocketTransferFilter.this.markDirty();
                }

                @Override
                public LIMIT getSelectedValue() {
                    return (LIMIT)((Object)GrocketTransferFilter.this.limit.value);
                }
            }.addChoice(LIMIT.Unlimited, "Unlimited", null)).addChoice((LIMIT)LIMIT.Single, "Single Item", null)).addChoice((LIMIT)LIMIT.SingleStack, "Single Stack", null));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }

    static enum LIMIT {
        Unlimited,
        Single,
        SingleStack;

    }
}

