/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ClientCallable;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonText;
import com.rwtema.extrautils2.gui.backend.WidgetScrollBar;
import com.rwtema.extrautils2.gui.backend.WidgetText;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileScanner
extends XUTile
implements ITickable,
IDynamicHandler {
    private static final LoadingCache<Block, Set<IBlockState>> associatedStates = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Block, Set<IBlockState>>(){

        public Set<IBlockState> load(@Nonnull Block key) throws Exception {
            int v;
            HashSet<IBlockState> states = new HashSet<IBlockState>();
            states.add(key.func_176223_P());
            BlockStateContainer blockState = key.func_176194_O();
            states.addAll((Collection<IBlockState>)blockState.func_177619_a());
            Collection properties = blockState.func_177623_d();
            do {
                v = states.size();
                for (IProperty property : properties) {
                    Collection values = property.func_177700_c();
                    for (Comparable value : values) {
                        ArrayList list = Lists.newArrayList();
                        for (IBlockState state : states) {
                            list.add(state.func_177226_a(property, value));
                        }
                        states.addAll(list);
                    }
                }
            } while (states.size() != v);
            return states;
        }
    });
    private static final LoadingCache<Block, Set<Block>> associatedBlocks = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Block, Set<Block>>(){

        public Set<Block> load(@Nonnull Block key) throws Exception {
            HashSet<Block> blocks = new HashSet<Block>();
            blocks.add(key);
            for (IBlockState state : (Set)associatedStates.getUnchecked((Object)key)) {
                blocks.add(state.func_177230_c());
            }
            return blocks;
        }
    });
    NBTSerializable.RegisteredValue<Block> storedBlock = this.registerNBT("block", new NBTSerializable.RegisteredValue(Block.field_149771_c));
    NBTSerializable.HashMapSerializable<String, HashSet<String>, NBTTagList> storedPropertyBlacklist = this.registerNBT("props", new NBTSerializable.HashMapSerializable(UnaryOperator.identity(), UnaryOperator.identity(), new Function<HashSet<String>, NBTTagList>(){

        @Override
        public NBTTagList apply(HashSet<String> v) {
            NBTTagList list = new NBTTagList();
            for (String s : v) {
                if (s == null) continue;
                list.func_74742_a((NBTBase)new NBTTagString(s));
            }
            return list;
        }
    }, new Function<NBTTagList, HashSet<String>>(){

        @Override
        public HashSet<String> apply(NBTTagList list) {
            HashSet<String> strings = new HashSet<String>();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                strings.add(list.func_150307_f(i));
            }
            return strings;
        }
    }));
    NBTSerializable.NBTBoolean redstone = this.registerNBT("powered", new NBTSerializable.NBTBoolean());

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerScanner(this);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IBlockState state = this.getScannedBlockState();
        boolean b = this.checkState(state);
        if (b != this.redstone.value) {
            this.redstone.value = b;
            this.field_145850_b.func_175722_b(this.func_174877_v(), (Block)this.getXUBlock());
        }
    }

    @Nonnull
    public IBlockState getScannedBlockState() {
        EnumFacing side = (EnumFacing)this.getBlockState().func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL);
        BlockPos offset = this.func_174877_v().func_177972_a(side);
        IBlockState state = this.field_145850_b.func_180495_p(offset);
        return state.func_185899_b((IBlockAccess)this.field_145850_b, offset);
    }

    public boolean checkState(IBlockState state) {
        return this.matchBlock(state);
    }

    public boolean matchBlock(IBlockState state) {
        Block storedBlock = (Block)this.storedBlock.value;
        if (storedBlock == null) {
            return false;
        }
        Block block = state.func_177230_c();
        if (!((Set)associatedBlocks.getUnchecked((Object)block)).contains(storedBlock)) {
            return false;
        }
        ArrayList properties = Lists.newArrayList((Iterable)storedBlock.func_176194_O().func_177623_d());
        for (IProperty property : properties) {
            String name;
            HashSet set = (HashSet)this.storedPropertyBlacklist.map.get(property.func_177701_a());
            if (set == null || !set.contains(name = property.func_177702_a(state.func_177229_b(property)))) continue;
            return false;
        }
        return true;
    }

    public boolean isPowered() {
        return this.redstone.value;
    }

    class ContainerScanner
    extends DynamicContainerTile {
        public static final int BUTTON_HEIGHT = 20;
        public static final int CACHE = 128;
        public static final int NUM_ROWS = 5;
        public static final int BUTTONS_PER_ROW = 4;
        public static final int BUTTON_WIDTH = 80;
        IWidget[][] values;
        MyWidgetClickMCButtonText[] buttonCache;
        PropertyText[] textCache;
        WidgetScrollBar scrollBar;
        HashMap<String, String> currentValues;
        int scrollValue;

        public ContainerScanner(TileScanner tile) {
            int i;
            super(tile);
            this.buttonCache = new MyWidgetClickMCButtonText[128];
            this.textCache = new PropertyText[128];
            this.currentValues = new HashMap();
            this.scrollValue = 0;
            this.addTitle("Block Detector");
            int w = 210;
            this.addWidget(new WidgetTextData(6, 20, w, 9){

                @Override
                public void addToDescription(PacketBuffer packet) {
                    Block value = (Block)TileScanner.this.storedBlock.value;
                    if (value == null) {
                        packet.writeInt(-1);
                    } else {
                        packet.writeInt(Block.func_149682_b((Block)value));
                    }
                    packet.writeNBT(TileScanner.this.storedPropertyBlacklist.serializeNBT());
                    IBlockState state = TileScanner.this.getScannedBlockState();
                    ImmutableMap properties = state.func_177228_b();
                    packet.writeInt(properties.size());
                    for (Map.Entry entry : properties.entrySet()) {
                        packet.writeString(((IProperty)entry.getKey()).func_177701_a());
                        packet.writeString(((IProperty)entry.getKey()).func_177702_a((Comparable)entry.getValue()));
                    }
                }

                @Override
                protected String constructText(PacketBuffer packet) {
                    int id = packet.readInt();
                    Block block = id != -1 ? Block.func_149729_e((int)id) : null;
                    TileScanner.this.storedBlock.value = block;
                    TileScanner.this.storedPropertyBlacklist.deserializeNBT(packet.readNBT());
                    int n = packet.readInt();
                    ContainerScanner.this.currentValues.clear();
                    for (int i = 0; i < n; ++i) {
                        ContainerScanner.this.currentValues.put(packet.readString(), packet.readString());
                    }
                    ContainerScanner.this.assignValues();
                    if (block == Blocks.field_150350_a) {
                        return I18n.func_135052_a((String)"createWorld.customize.flat.air", (Object[])new Object[0]);
                    }
                    if (block != null) {
                        return block.func_149732_F();
                    }
                    return Lang.translate("Unassigned");
                }
            });
            this.addWidget(new WidgetClickMCButtonText(Lang.translate("Set to Current Block"), w + 12, 5, 120, 20){

                @Override
                public PacketBuffer getPacketToSend(int mouseButton) {
                    return new PacketBuffer();
                }

                @Override
                public void receiveClientPacket(PacketBuffer buffer) {
                    IBlockState scan = TileScanner.this.getScannedBlockState();
                    TileScanner.this.storedBlock.value = scan.func_177230_c();
                    TileScanner.this.storedPropertyBlacklist.map.clear();
                    TileScanner.this.func_70296_d();
                }
            });
            this.scrollBar = new WidgetScrollBar(328, 40, 100, 0, 0){

                @Override
                protected void onChange() {
                    for (MyWidgetClickMCButtonText myWidgetClickMCButtonText : ContainerScanner.this.buttonCache) {
                        myWidgetClickMCButtonText.hide();
                    }
                    for (WidgetBase widgetBase : ContainerScanner.this.textCache) {
                        ((PropertyText)widgetBase).hide();
                    }
                    IWidget[][] values = ContainerScanner.this.values;
                    if (values == null) {
                        return;
                    }
                    for (int i = 0; i < 5; ++i) {
                        int j = i + ContainerScanner.this.scrollBar.scrollValue;
                        if (j < 0 || j >= values.length) continue;
                        IWidget[] iWidgetArray = values[j];
                        for (int k = 0; k < iWidgetArray.length; ++k) {
                            IWidget w = iWidgetArray[k];
                            if (w instanceof MyWidgetClickMCButtonText) {
                                ((MyWidgetClickMCButtonText)w).show(5 + k * 80, 40 + i * 20);
                                continue;
                            }
                            if (!(w instanceof PropertyText)) continue;
                            ((PropertyText)w).show(5, 50 + i * 20);
                        }
                    }
                }
            };
            this.addWidget(this.scrollBar);
            for (i = 0; i < this.buttonCache.length; ++i) {
                this.buttonCache[i] = new MyWidgetClickMCButtonText();
                this.addWidget(this.buttonCache[i]);
            }
            for (i = 0; i < this.textCache.length; ++i) {
                this.textCache[i] = new PropertyText();
                this.addWidget(this.textCache[i]);
            }
            this.crop();
            this.validate();
        }

        private void assignValues() {
            ExtraUtils2.proxy.run(new ClientCallable(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                @SideOnly(value=Side.CLIENT)
                public void runClient() {
                    for (MyWidgetClickMCButtonText myWidgetClickMCButtonText : ContainerScanner.this.buttonCache) {
                        myWidgetClickMCButtonText.clear();
                    }
                    for (WidgetBase widgetBase : ContainerScanner.this.textCache) {
                        ((PropertyText)widgetBase).clear();
                    }
                    ArrayList<IWidget[]> wRows = new ArrayList<IWidget[]>();
                    Block value = (Block)TileScanner.this.storedBlock.value;
                    int i = 0;
                    boolean bl = false;
                    if (value != null) {
                        ArrayList properties = Lists.newArrayList((Iterable)value.func_176194_O().func_177623_d());
                        Collections.sort(properties, new Comparator<IProperty<?>>(){

                            @Override
                            public int compare(IProperty<?> o1, IProperty<?> o2) {
                                return ComparisonChain.start().compare((Comparable)((Object)o1.func_177699_b().getSimpleName()), (Comparable)((Object)o2.func_177699_b().getSimpleName())).compare((Comparable)((Object)o1.func_177701_a()), (Comparable)((Object)o2.func_177701_a())).result();
                            }
                        });
                        for (IProperty property : properties) {
                            void var4_9;
                            PropertyText propertyText = ContainerScanner.this.textCache[var4_9];
                            ++var4_9;
                            propertyText.setText(StringHelper.capitalizeProp(property.func_177701_a()));
                            wRows.add(new IWidget[]{propertyText});
                            ArrayList<MyWidgetClickMCButtonText> w = new ArrayList<MyWidgetClickMCButtonText>();
                            for (Object val : property.func_177700_c()) {
                                MyWidgetClickMCButtonText button = ContainerScanner.this.buttonCache[i];
                                ++i;
                                button.show(property.func_177701_a(), property.func_177702_a((Comparable)val));
                                w.add(button);
                                if (w.size() != 4) continue;
                                wRows.add(w.toArray(new IWidget[w.size()]));
                                w = new ArrayList();
                            }
                            if (w.isEmpty()) continue;
                            wRows.add(w.toArray(new IWidget[w.size()]));
                        }
                    }
                    ContainerScanner.this.values = (IWidget[][])wRows.toArray((T[])new IWidget[wRows.size()][]);
                    ContainerScanner.this.scrollBar.setValues(0, Math.max(0, ContainerScanner.this.values.length - 5));
                }
            });
        }

        private class MyWidgetClickMCButtonText
        extends WidgetClickMCButtonText {
            String property;
            String value;
            boolean visible;

            public MyWidgetClickMCButtonText() {
                super("", 0, 0, 80, 20);
            }

            @Override
            public PacketBuffer getPacketToSend(int mouseButton) {
                if (this.property != null && this.value != null) {
                    PacketBuffer buffer = new PacketBuffer();
                    buffer.writeString(this.property);
                    buffer.writeString(this.value);
                    return buffer;
                }
                return null;
            }

            @Override
            public void receiveClientPacket(PacketBuffer buffer) {
                String prop = buffer.readString();
                String val = buffer.readString();
                IBlockState state = TileScanner.this.getScannedBlockState();
                Block block = state.func_177230_c();
                if (!block.func_176194_O().func_177623_d().stream().anyMatch(iProperty -> iProperty.func_177701_a().equals(prop))) {
                    return;
                }
                HashSet<String> set = (HashSet<String>)TileScanner.this.storedPropertyBlacklist.map.get(prop);
                if (set == null) {
                    set = new HashSet<String>();
                    set.add(this.value);
                    TileScanner.this.storedPropertyBlacklist.map.put(prop, set);
                } else if (set.contains(val)) {
                    set.remove(val);
                    if (set.isEmpty()) {
                        TileScanner.this.storedPropertyBlacklist.map.remove(prop);
                    }
                } else {
                    set.add(val);
                }
            }

            public void hide() {
                this.visible = false;
            }

            public void show(String property, String value) {
                this.property = property;
                this.value = value;
                this.mouseOver = false;
                this.visible = true;
                HashSet set = (HashSet)TileScanner.this.storedPropertyBlacklist.map.get(property);
                String s = StringHelper.capitalizeProp(value);
                if (ContainerScanner.this.currentValues.get(property).equals(value)) {
                    s = "[" + s + "]";
                }
                this.text = set != null && set.contains(value) ? ChatFormatting.STRIKETHROUGH + s + ChatFormatting.RESET : s;
            }

            @Override
            public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                if (this.visible && this.property != null && this.value != null) {
                    super.renderBackground(manager, gui, guiLeft, guiTop);
                }
            }

            @Override
            public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                if (this.visible && this.property != null && this.value != null) {
                    super.renderForeground(manager, gui, guiLeft, guiTop);
                }
            }

            public void show(int x, int y) {
                this.x = x;
                this.y = y;
                this.mouseOver = false;
                this.visible = true;
            }

            public void clear() {
                this.visible = false;
                this.property = null;
                this.value = null;
            }
        }

        private class PropertyText
        extends WidgetText {
            boolean visible;

            public PropertyText() {
                super(0, 0, "", 320);
                this.visible = false;
            }

            @Override
            public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                if (this.visible) {
                    super.renderBackground(manager, gui, guiLeft, guiTop);
                }
            }

            public void hide() {
                this.visible = false;
            }

            public void show(int x, int y) {
                this.x = x;
                this.y = y;
                this.visible = true;
            }

            public void setText(String text) {
                this.msg = text;
            }

            public void clear() {
                this.msg = "";
                this.visible = false;
                this.x = 0;
                this.y = 0;
            }
        }
    }
}

