/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.asm.Lighting;
import com.rwtema.extrautils2.lighting.ILight;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.tile.tesr.ITESRHook;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEvil
extends XUTile
implements ILight,
ITESRHook {
    NBTSerializable.Float range = this.registerNBT("Range", new NBTSerializable.Float(96.0f));

    @Override
    public World getLightWorld() {
        return this.field_145850_b;
    }

    @Override
    public float getLightOffset(BlockPos lightPos, EnumSkyBlock type) {
        float value;
        int dx = lightPos.func_177958_n() - this.field_174879_c.func_177958_n();
        int dz = lightPos.func_177952_p() - this.field_174879_c.func_177952_p();
        int dy = lightPos.func_177956_o() - this.field_174879_c.func_177956_o();
        float ri = dx * dx + dy * dy + dz * dz;
        if (ri >= (value = this.range.value) * value) {
            return 0.0f;
        }
        float r = value - (ri = MathHelper.func_76129_c((float)ri));
        if (r > 16.0f) {
            r = 16.0f;
        }
        float v = (float)Math.atan2(dx, dz);
        float v2 = (1.0f + MathHelper.func_76134_b((float)(ri / 8.0f + v * 10.0f))) / 2.0f;
        return -Math.min(r * v2, r) + Math.min(0.0f, -(value / 3.0f) + ri);
    }

    @Override
    public EnumSkyBlock[] getLightType() {
        return new EnumSkyBlock[]{EnumSkyBlock.BLOCK, EnumSkyBlock.SKY};
    }

    public void func_145843_s() {
        super.func_145843_s();
        Lighting.unregister(this, Lighting.negLights);
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    public void onLoad() {
        Lighting.register(this, Lighting.negLights);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        Lighting.unregister(this, Lighting.negLights);
        if (this.field_145850_b.field_72995_K) {
            this.updateLight();
        }
    }

    @Override
    public void addToDescriptionPacket(PacketBuffer packet) {
        packet.writeFloat(this.range.value);
    }

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        this.range.value = packet.readFloat();
        this.updateLight();
    }

    private void updateLight() {
        int r = (int)Math.ceil(this.range.value);
        this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n() - r, this.field_174879_c.func_177956_o() - r, this.field_174879_c.func_177952_p() - r, this.field_174879_c.func_177958_n() + r, this.field_174879_c.func_177956_o() + r, this.field_174879_c.func_177952_p() + r);
    }

    @Override
    public void render(IBlockAccess world, BlockPos pos, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer renderer, BlockRendererDispatcher blockRenderer) {
    }

    @Override
    public void preRender(int destroyStage) {
    }

    @Override
    public void postRender(int destroyStage) {
    }
}

