/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonChoices;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerUpgrades;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileAdvInteractor
extends TilePower
implements ITickable,
IDynamicHandler {
    public static final EnumSet<Upgrade> SPEED = EnumSet.of(Upgrade.SPEED);
    public NBTSerializable.NBTEnum<REDSTONE_STATE> redstone_state = this.registerNBT("redstone", new NBTSerializable.NBTEnum<REDSTONE_STATE>(REDSTONE_STATE.OPERATE_ALWAYS));
    public NBTSerializable.Int pulses = this.registerNBT("pulses", new NBTSerializable.Int());
    public NBTSerializable.Int cooldown = this.registerNBT("cooldown", new NBTSerializable.Int());
    public SingleStackHandlerUpgrades upgrades = this.registerNBT("upgrades", new SingleStackHandlerUpgrades(SPEED){

        @Override
        protected void onContentsChanged() {
            TileAdvInteractor.this.func_70296_d();
            PowerManager.instance.markDirty(TileAdvInteractor.this);
        }
    });
    public NBTSerializable.NBTBoolean powered = this.registerNBT("powered", new NBTSerializable.NBTBoolean());

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.active) {
            return;
        }
        if (!this.preOperate()) {
            return;
        }
        if (this.cooldown.value > 0) {
            this.cooldown.value -= 1 + this.upgrades.getLevel(Upgrade.SPEED);
            return;
        }
        switch ((REDSTONE_STATE)((Object)this.redstone_state.value)) {
            case OPERATE_REDSTONE_ON: {
                if (this.powered.value) break;
                return;
            }
            case OPERATE_REDSTONE_OFF: {
                if (!this.powered.value) break;
                return;
            }
            case OPERATE_REDSTONE_PULSE: {
                if (this.pulses.value == 0) {
                    return;
                }
                --this.pulses.value;
            }
        }
        this.cooldown.value += 20;
        this.operate();
    }

    public boolean preOperate() {
        return true;
    }

    protected abstract void operate();

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        boolean newPower;
        boolean wasPowered = this.powered.value;
        boolean bl = newPower = worldIn.func_175687_A(pos) > 0;
        if (newPower != wasPowered) {
            this.powered.value = newPower;
            if (newPower && this.redstone_state.value == REDSTONE_STATE.OPERATE_REDSTONE_PULSE) {
                ++this.pulses.value;
            }
        }
    }

    public WidgetClickMCButtonChoices<REDSTONE_STATE> getRSWidget(int x, int y) {
        return ((WidgetClickMCButtonChoices)((WidgetClickMCButtonChoices)((WidgetClickMCButtonChoices)new WidgetClickMCButtonChoices<REDSTONE_STATE>(x, y){

            @Override
            protected void onSelectedServer(REDSTONE_STATE marker) {
                TileAdvInteractor.this.redstone_state.value = marker;
                TileAdvInteractor.this.pulses.value = 0;
            }

            @Override
            public REDSTONE_STATE getSelectedValue() {
                return (REDSTONE_STATE)((Object)TileAdvInteractor.this.redstone_state.value);
            }
        }.addChoice(REDSTONE_STATE.OPERATE_ALWAYS, new ItemStack(Items.field_151016_H), "Always On")).addChoice((REDSTONE_STATE)REDSTONE_STATE.OPERATE_REDSTONE_ON, new ItemStack(Items.field_151137_ax), "Redstone On")).addChoice((REDSTONE_STATE)REDSTONE_STATE.OPERATE_REDSTONE_OFF, new ItemStack(Blocks.field_150429_aA), "Redstone Off")).addChoice((REDSTONE_STATE)REDSTONE_STATE.OPERATE_REDSTONE_PULSE, new ItemStack(Items.field_151107_aW), "Redstone Pulse");
    }

    @Override
    public float getPower() {
        int level = this.upgrades.getLevel(Upgrade.SPEED);
        if (level == 0) {
            return Float.NaN;
        }
        return Upgrade.SPEED.getPowerUse(level);
    }

    @Override
    public void onPowerChanged() {
    }

    public static enum REDSTONE_STATE {
        OPERATE_ALWAYS,
        OPERATE_REDSTONE_ON,
        OPERATE_REDSTONE_OFF,
        OPERATE_REDSTONE_PULSE;

    }
}

