/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power;

import com.mojang.authlib.GameProfile;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketServerToClient;
import com.rwtema.extrautils2.power.ClientPower;
import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import com.rwtema.extrautils2.power.PowerSettings;
import com.rwtema.extrautils2.power.UnloadedChunkPower;
import com.rwtema.extrautils2.power.player.PlayerPowerManager;
import com.rwtema.extrautils2.utils.XURandom;
import com.rwtema.extrautils2.utils.datastructures.WeakLinkedSet;
import com.rwtema.extrautils2.utils.helpers.DescribeHelper;
import com.rwtema.extrautils2.utils.helpers.PlayerHelper;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.iterator.TObjectFloatIterator;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PowerManager {
    public static final PowerManager instance = new PowerManager();
    public static final Object MUTEX = new Object();
    private static final int REFRESH_TIME = 600;
    public final TIntObjectHashMap<GameProfile> frequncies = new TIntObjectHashMap();
    public final WeakHashMap<EntityPlayerMP, PowerFreq> assignedValuesPlayer = new WeakHashMap();
    public final TIntObjectHashMap<TIntHashSet> alliances = new TIntObjectHashMap();
    public final ReferenceQueue<Object> weakPowersToRemove = new ReferenceQueue();
    private final TIntIntHashMap links = new TIntIntHashMap();
    private final TIntObjectHashMap<PowerFreq> frequencyHolders = new TIntObjectHashMap();
    private final WeakLinkedSet<IPower> powersToAdd = new WeakLinkedSet();
    private final WeakLinkedSet<IPower> powersToRemove = new WeakLinkedSet();
    public WeakHashMap<IPower, PowerFreq> assignedValues = new WeakHashMap();
    int p = 0;
    boolean dirty = true;
    UnloadedChunkPower unloadedChunkManager = new UnloadedChunkPower();
    private boolean playersDirty = true;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerPowerManager());
    }

    public static float getCurrentPower(IPower power) {
        return power.getPower() * power.getMultiplier().multiplier(power.world());
    }

    public static boolean areFreqOnSameGrid(int freq, int frequency) {
        return freq == frequency || instance.getPowerFreq(freq) == instance.getPowerFreq(frequency);
    }

    public static boolean canUse(EntityPlayer player, IPower power) {
        if (!(player instanceof EntityPlayerMP)) {
            return false;
        }
        int basePlayerFreq = Freq.getBasePlayerFreq((EntityPlayerMP)player);
        return basePlayerFreq != 0 && PowerManager.areFreqOnSameGrid(power.frequency(), basePlayerFreq);
    }

    public boolean sameTeam(int a, int b) {
        if (a == b) {
            return true;
        }
        if (this.links.containsKey(a)) {
            a = this.links.get(a);
        }
        if (this.links.containsKey(b)) {
            b = this.links.get(b);
        }
        return a == b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = MUTEX;
        synchronized (object) {
            this.frequncies.clear();
            this.p = 0;
            while (this.weakPowersToRemove.poll() != null) {
            }
            this.links.clear();
            this.frequencyHolders.clear();
            this.powersToAdd.clear();
            this.powersToRemove.clear();
            this.assignedValuesPlayer.clear();
            this.playersDirty = true;
            this.assignedValues.clear();
            this.alliances.clear();
            this.unloadedChunkManager.freqs.clear();
        }
    }

    public void getDebug(final List<String> info) {
        TIntObjectProcedure procedure = (a, b) -> {
            info.add(a + "=" + b.toString());
            return true;
        };
        DescribeHelper.addDescription(info, "Frequencies");
        this.frequncies.forEachEntry(procedure);
        DescribeHelper.addDescription(info, "Alliances");
        this.alliances.forEachEntry(procedure);
        DescribeHelper.addDescription(info, "AssignedValues");
        DescribeHelper.addDescription(info, this.assignedValues);
        DescribeHelper.addDescription(info, "Frequencie Holders");
        this.frequencyHolders.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<PowerFreq>(){

            public boolean execute(int a, PowerFreq b) {
                DescribeHelper.addDescription(info, "Init");
                this.describe(a, b);
                DescribeHelper.addDescription(info, "QRefresh");
                b.quickRefresh();
                this.describe(a, b);
                DescribeHelper.addDescription(info, "FRefresh");
                b.refresh();
                this.describe(a, b);
                return true;
            }

            public void describe(int a, PowerFreq b) {
                DescribeHelper.addDescription((List<String>)info, (Object)("Freq = " + a), 2);
                DescribeHelper.addDescription((List<String>)info, (Object)"Power", 2);
                DescribeHelper.addDescription((List<String>)info, (Object)(b.powerDrained + " " + b.powerCreated), 3);
                DescribeHelper.addDescription((List<String>)info, (Object)"Players", 2);
                DescribeHelper.addDescription((List<String>)info, b.players, 3);
                DescribeHelper.addDescription((List<String>)info, (Object)"Creators", 2);
                DescribeHelper.addDescription((List<String>)info, b.worldPowerCreators, 3);
                DescribeHelper.addDescription((List<String>)info, (Object)"Drainers", 2);
                DescribeHelper.addDescription((List<String>)info, b.worldPowerDrainers, 3);
                DescribeHelper.addDescription((List<String>)info, (Object)"IPowers", 2);
                DescribeHelper.addDescription((List<String>)info, b.powerHandlers, 3);
            }
        });
    }

    public void reassignValues() {
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remake() {
        Object object = MUTEX;
        synchronized (object) {
            this.dirty = false;
            PowerSettings.instance.markDirty();
            this.links.clear();
            for (EntityPlayerMP entityPlayerMP : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                this.frequncies.put(Freq.getBasePlayerFreq(entityPlayerMP), (Object)entityPlayerMP.func_146103_bH());
            }
            int[] keys = this.frequncies.keys();
            TIntObjectHashMap mutualAlliances = new TIntObjectHashMap();
            for (int a : keys) {
                TIntHashSet set = new TIntHashSet();
                for (int b : keys) {
                    if (!this.areAAndBMutualAllies(a, b)) continue;
                    set.add(b);
                }
                mutualAlliances.put(a, (Object)set);
            }
            for (int a : keys) {
                if (this.links.containsKey(a)) continue;
                TIntLinkedList toProcess = new TIntLinkedList();
                toProcess.add(a);
                while (!toProcess.isEmpty()) {
                    int b = toProcess.removeAt(0);
                    if (this.links.containsKey(b)) continue;
                    this.links.put(b, a);
                    TIntHashSet allies = (TIntHashSet)mutualAlliances.get(b);
                    if (allies == null) continue;
                    toProcess.addAll((TIntCollection)allies);
                }
            }
            for (int key : keys) {
                if (this.links.get(key) != key) continue;
                this.links.remove(key);
            }
            Object object2 = this.frequencyHolders.valueCollection().iterator();
            while (object2.hasNext()) {
                PowerFreq powerFreq = (PowerFreq)object2.next();
                this.powersToAdd.addAll(powerFreq.powerHandlers);
            }
            this.frequencyHolders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPowerHandler(IPower needer) {
        Object object = MUTEX;
        synchronized (object) {
            this.powersToAdd.add(needer);
        }
    }

    public boolean isPowered(EntityPlayerMP player) {
        PowerFreq powerFreq = this.assignedValuesPlayer.get(player);
        if (powerFreq == null) {
            if (!PlayerHelper.isPlayerReal((EntityPlayer)player)) {
                return false;
            }
            powerFreq = this.getPowerFreq(Freq.getBasePlayerFreq(player));
        }
        return powerFreq != null && powerFreq.isPowered();
    }

    public PowerFreq getPowerFreq(int frequency) {
        int i = this.links.containsKey(frequency) ? this.links.get(frequency) : frequency;
        PowerFreq powerFreq = (PowerFreq)this.frequencyHolders.get(i);
        if (powerFreq == null) {
            powerFreq = new PowerFreq(i);
            powerFreq.dirty = true;
            this.frequencyHolders.put(i, (Object)powerFreq);
        }
        return powerFreq;
    }

    public boolean areAAndBMutualAllies(int a, int b) {
        return this.doesAWishToAllyWithB(a, b) && this.doesAWishToAllyWithB(b, a);
    }

    public boolean doesAWishToAllyWithB(int a, int b) {
        TIntHashSet tIntHashSet = (TIntHashSet)this.alliances.get(a);
        return tIntHashSet != null && tIntHashSet.contains(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePowerHandler(IPower needer) {
        Object object = MUTEX;
        synchronized (object) {
            this.powersToRemove.add(needer);
        }
    }

    public void markDirty(IPower power) {
        PowerFreq powerFreq = this.assignedValues.get(power);
        if (powerFreq == null) {
            powerFreq = this.getPowerFreq(power.frequency());
        }
        powerFreq.dirty = true;
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            this.unloadedChunkManager.dirty = true;
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        this.unloadedChunkManager.dirty = true;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.playersDirty = true;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerRespawnEvent event) {
        this.playersDirty = true;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        this.playersDirty = true;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedOutEvent event) {
        this.playersDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        ++this.p;
        if (this.p > 600) {
            this.p = 0;
        }
        Object object = MUTEX;
        synchronized (object) {
            PowerFreq value;
            TIntObjectIterator iterator;
            PowerFreq powerFreq;
            Iterator<IPower> x;
            if (this.dirty) {
                this.remake();
            }
            while ((x = this.weakPowersToRemove.poll()) != null) {
                this.powersToRemove.add((IPower)((Object)x));
                this.unloadedChunkManager.dirty = true;
            }
            if (!this.powersToRemove.isEmpty()) {
                for (IPower iPower : this.powersToRemove) {
                    powerFreq = this.assignedValues.get(iPower);
                    if (powerFreq == null) {
                        powerFreq = this.getPowerFreq(iPower.frequency());
                    }
                    powerFreq.powerHandlers.remove(iPower);
                    powerFreq.dirty = true;
                }
                this.powersToRemove.clear();
                this.unloadedChunkManager.dirty = true;
            }
            if (!this.powersToAdd.isEmpty()) {
                for (IPower iPower : this.powersToAdd) {
                    if (!iPower.isLoaded()) continue;
                    powerFreq = this.getPowerFreq(iPower.frequency());
                    powerFreq.powerHandlers.add(iPower);
                    if (this.assignedValues.containsKey(iPower)) {
                        PowerFreq oldFreq = this.assignedValues.get(iPower);
                        oldFreq.powerHandlers.remove(iPower);
                        oldFreq.dirty = true;
                    }
                    this.assignedValues.put(iPower, powerFreq);
                    powerFreq.dirty = true;
                }
                this.powersToAdd.clear();
                this.unloadedChunkManager.dirty = true;
            }
            if (this.playersDirty) {
                this.assignedValuesPlayer.clear();
                iterator = this.frequencyHolders.iterator();
                while (iterator.hasNext()) {
                    iterator.advance();
                    value = (PowerFreq)iterator.value();
                    value.playerFreqs.clear();
                    value.players.clear();
                }
                LinkedHashSet<PowerFreq> freqs = new LinkedHashSet<PowerFreq>();
                for (EntityPlayerMP entityPlayerMP : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                    int basePlayerFreq = Freq.getBasePlayerFreq(entityPlayerMP);
                    PowerFreq freq = this.getPowerFreq(basePlayerFreq);
                    this.assignedValuesPlayer.put(entityPlayerMP, freq);
                    freq.players.add(entityPlayerMP);
                    freq.playerFreqs.add(basePlayerFreq);
                    freqs.add(freq);
                }
                for (PowerFreq freq : freqs) {
                    freq.dirty = true;
                }
                this.unloadedChunkManager.dirty = true;
                this.playersDirty = false;
            }
            if (this.unloadedChunkManager.dirty) {
                this.unloadedChunkManager.dirty = false;
                this.unloadedChunkManager.rebuild();
            }
            iterator = this.frequencyHolders.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                value = (PowerFreq)iterator.value();
                if (value.dirty || value.refresh_delta == this.p) {
                    if (value.refresh()) {
                        value.dirty = false;
                        continue;
                    }
                    iterator.remove();
                    continue;
                }
                value.quickRefresh();
            }
        }
    }

    @NetworkHandler.XUPacket
    public static class PacketPower
    extends XUPacketServerToClient {
        float powerCreated;
        float powerUsed;

        public PacketPower() {
        }

        public PacketPower(float powerCreated, float powerUsed) {
            this.powerCreated = powerCreated;
            this.powerUsed = powerUsed;
        }

        @Override
        public void writeData() throws Exception {
            this.writeFloat(this.powerCreated);
            this.writeFloat(this.powerUsed);
        }

        @Override
        public void readData(EntityPlayer player) {
            this.powerCreated = this.readFloat();
            this.powerUsed = this.readFloat();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Runnable doStuffClient() {
            ClientPower.powerCreated = this.powerCreated;
            ClientPower.powerDrained = this.powerUsed;
            return null;
        }
    }

    public static class PowerFreq {
        final int frequency;
        public WeakLinkedSet<IPower> powerHandlers = new WeakLinkedSet();
        float powerDrained;
        float powerCreated;
        TIntHashSet playerFreqs = new TIntHashSet();
        WeakLinkedSet<EntityPlayerMP> players = new WeakLinkedSet();
        int refresh_delta = XURandom.rand.nextInt(600);
        boolean dirty = true;
        WeakHashMap<World, TObjectFloatHashMap<IWorldPowerMultiplier>> worldPowerCreators = new WeakHashMap();
        WeakHashMap<World, TObjectFloatHashMap<IWorldPowerMultiplier>> worldPowerDrainers = new WeakHashMap();

        public PowerFreq(int frequency) {
            this.frequency = frequency;
        }

        public boolean refresh() {
            this.worldPowerDrainers.clear();
            this.worldPowerCreators.clear();
            for (IPower powerHandler : this.powerHandlers) {
                WeakHashMap<World, TObjectFloatHashMap<IWorldPowerMultiplier>> type;
                float i;
                if (!powerHandler.isLoaded() || Float.isNaN(i = powerHandler.getPower())) continue;
                IWorldPowerMultiplier multiplier = powerHandler.getMultiplier();
                if (i > 0.0f) {
                    type = this.worldPowerDrainers;
                } else {
                    type = this.worldPowerCreators;
                    i = -i;
                }
                World world = powerHandler.world();
                TObjectFloatHashMap typeMap = type.get(world);
                if (typeMap == null) {
                    typeMap = new TObjectFloatHashMap();
                    type.put(world, (TObjectFloatHashMap<IWorldPowerMultiplier>)typeMap);
                }
                typeMap.adjustOrPutValue((Object)multiplier, i, i);
            }
            this.quickRefresh();
            return !this.powerHandlers.isEmpty() || !this.players.isEmpty();
        }

        public void quickRefresh() {
            boolean newPower;
            boolean oldPowered = this.powerDrained <= this.powerCreated;
            float prevCreated = this.powerCreated;
            float prevDrained = this.powerDrained;
            this.powerCreated = this.calcPower(this.worldPowerCreators);
            this.powerDrained = this.calcPower(this.worldPowerDrainers);
            TIntIterator iterator = this.playerFreqs.iterator();
            while (iterator.hasNext()) {
                UnloadedChunkPower.FreqData freqData = (UnloadedChunkPower.FreqData)PowerManager.instance.unloadedChunkManager.freqs.get(iterator.next());
                if (freqData == null) continue;
                this.powerCreated += freqData.getPowerCreated();
                this.powerDrained += freqData.getPowerDrained();
            }
            boolean bl = newPower = this.powerDrained <= this.powerCreated;
            if (this.dirty || newPower != oldPowered) {
                this.changeStatus(newPower);
            }
            if (this.dirty || prevCreated != this.powerCreated || prevDrained != this.powerDrained) {
                this.sendNetworkUpdates();
            }
        }

        private float calcPower(WeakHashMap<World, TObjectFloatHashMap<IWorldPowerMultiplier>> multiplierCache) {
            float p = 0.0f;
            for (Map.Entry<World, TObjectFloatHashMap<IWorldPowerMultiplier>> entry : multiplierCache.entrySet()) {
                TObjectFloatIterator iterator = entry.getValue().iterator();
                while (iterator.hasNext()) {
                    iterator.advance();
                    IWorldPowerMultiplier powerMultiplier = (IWorldPowerMultiplier)iterator.key();
                    float multiplier = powerMultiplier.multiplier(entry.getKey());
                    if (Float.isNaN(multiplier)) continue;
                    float value = iterator.value();
                    p += multiplier * value;
                }
            }
            return p;
        }

        public void sendNetworkUpdates() {
            for (EntityPlayerMP player : this.players) {
                NetworkHandler.sendPacketToPlayer(new PacketPower(this.powerCreated, this.powerDrained), (EntityPlayer)player);
            }
        }

        public void changeStatus(boolean powered) {
            for (IPower powerNeeder : this.powerHandlers) {
                powerNeeder.powerChanged(powered);
            }
        }

        public boolean isPowered() {
            return this.powerDrained <= this.powerCreated;
        }
    }
}

