/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.particles;

import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ParticleProxy
extends Particle {
    Vec3d startPos;
    Vec3d endPos;
    Vec3d startVel;
    Vec3d endVel;
    double[] xParam;
    double[] yParam;
    double[] zParam;

    public ParticleProxy(World world, Vec3d startPos, Vec3d endPos, Vec3d startVel, Vec3d endVel) {
        super(world, startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c);
        this.startPos = startPos;
        this.endPos = endPos;
        this.startVel = startVel;
        this.endVel = endVel;
        this.func_70536_a(0);
        this.xParam = ParticleProxy.splineParams(startPos.field_72450_a, endPos.field_72450_a, startVel.field_72450_a, endVel.field_72450_a);
        this.yParam = ParticleProxy.splineParams(startPos.field_72448_b, endPos.field_72448_b, startVel.field_72448_b, endVel.field_72448_b);
        this.zParam = ParticleProxy.splineParams(startPos.field_72449_c, endPos.field_72449_c, startVel.field_72449_c, endVel.field_72449_c);
        this.field_70547_e = 10;
    }

    public static int getRandomColor(ItemStack stack, Random rand, World world, EntityLivingBase entity) {
        IBakedModel duplicateModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        IBakedModel finalModel = duplicateModel.func_188617_f().handleItemState(duplicateModel, stack, world, entity);
        TextureAtlasSprite sprite = finalModel.func_177554_e();
        if (sprite == null) {
            return -1;
        }
        int frameCount = sprite.func_110970_k();
        int i = rand.nextInt(frameCount);
        int[] ints = sprite.func_147965_a(i)[0];
        for (int j = 0; j < 16; ++j) {
            int col = ints[rand.nextInt(ints.length)];
            if (ColorHelper.getA(col) >= 16) continue;
            return col;
        }
        for (int col : ints) {
            if (ColorHelper.getA(col) >= 16) continue;
            return col;
        }
        return -1;
    }

    public static double[] splineParams(double p0, double p1, double d0, double d1) {
        return new double[]{2.0 * p0 - 2.0 * p1 + d0 + d1, -3.0 * p0 + 3.0 * p1 - 2.0 * d0 - d1, d0, p0};
    }

    public static double evalSpline(double t, double[] p) {
        return ((p[0] * t + p[1]) * t + p[2]) * t + p[3];
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public void func_189213_a() {
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        double h = (double)this.field_70546_d / (double)this.field_70547_e;
        this.field_187126_f = ParticleProxy.evalSpline(h, this.xParam);
        this.field_187127_g = ParticleProxy.evalSpline(h, this.yParam);
        this.field_187128_h = ParticleProxy.evalSpline(h, this.zParam);
        this.field_187129_i = ParticleProxy.evalSpline(h, this.xParam) - this.field_187123_c;
        this.field_187130_j = ParticleProxy.evalSpline(h, this.yParam) - this.field_187124_d;
        this.field_187131_k = ParticleProxy.evalSpline(h, this.zParam) - this.field_187125_e;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
    }
}

