/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.network;

import com.google.common.base.Throwables;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.StringUtils;

public class PacketBuffer {
    public ByteBuf data;

    public PacketBuffer() {
        this.data = Unpooled.buffer();
    }

    public PacketBuffer(ByteBuf data) {
        this.data = data;
    }

    public static byte[] compress(NBTTagCompound p_74798_0_) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        try (DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(bytearrayoutputstream));){
            CompressedStreamTools.func_74799_a((NBTTagCompound)p_74798_0_, (OutputStream)dataoutputstream);
        }
        return bytearrayoutputstream.toByteArray();
    }

    public static NBTTagCompound readCompressed(byte[] p_152457_0_) throws IOException {
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(p_152457_0_))));){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
            return nBTTagCompound;
        }
    }

    public ByteBuf writeBoolean(boolean value) {
        return this.data.writeBoolean(value);
    }

    public ByteBuf writeByte(int value) {
        return this.data.writeByte(value);
    }

    public ByteBuf writeShort(int value) {
        return this.data.writeShort(value);
    }

    public ByteBuf writeMedium(int value) {
        return this.data.writeMedium(value);
    }

    public ByteBuf writeInt(int value) {
        return this.data.writeInt(value);
    }

    public ByteBuf writeLong(long value) {
        return this.data.writeLong(value);
    }

    public ByteBuf writeChar(int value) {
        return this.data.writeChar(value);
    }

    public ByteBuf writeFloat(float value) {
        return this.data.writeFloat(value);
    }

    public ByteBuf writeDouble(double value) {
        return this.data.writeDouble(value);
    }

    public ByteBuf writeBytes(ByteBuf src) {
        return this.data.writeBytes(src);
    }

    public ByteBuf writeBytes(ByteBuf src, int length) {
        return this.data.writeBytes(src, length);
    }

    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        return this.data.writeBytes(src, srcIndex, length);
    }

    public ByteBuf writeBytes(byte[] src) {
        return this.data.writeBytes(src);
    }

    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        return this.data.writeBytes(src, srcIndex, length);
    }

    public ByteBuf writeBytes(ByteBuffer src) {
        return this.data.writeBytes(src);
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        return this.data.writeBytes(in, length);
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        return this.data.writeBytes(in, length);
    }

    public ByteBuf writeZero(int length) {
        return this.data.writeZero(length);
    }

    public boolean readBoolean() {
        return this.data.readBoolean();
    }

    public byte readByte() {
        return this.data.readByte();
    }

    public short readUnsignedByte() {
        return this.data.readUnsignedByte();
    }

    public short readShort() {
        return this.data.readShort();
    }

    public int readUnsignedShort() {
        return this.data.readUnsignedShort();
    }

    public int readMedium() {
        return this.data.readMedium();
    }

    public int readUnsignedMedium() {
        return this.data.readUnsignedMedium();
    }

    public int readInt() {
        return this.data.readInt();
    }

    public long readUnsignedInt() {
        return this.data.readUnsignedInt();
    }

    public long readLong() {
        return this.data.readLong();
    }

    public char readChar() {
        return this.data.readChar();
    }

    public float readFloat() {
        return this.data.readFloat();
    }

    public double readDouble() {
        return this.data.readDouble();
    }

    public ByteBuf readBytes(int length) {
        return this.data.readBytes(length);
    }

    public void writeVec(Vec3d vec3) {
        this.data.writeFloat((float)vec3.field_72450_a);
        this.data.writeFloat((float)vec3.field_72448_b);
        this.data.writeFloat((float)vec3.field_72449_c);
    }

    public void writeChatComponent(ITextComponent chatComponent) {
        this.writeString(ITextComponent.Serializer.func_150696_a((ITextComponent)chatComponent));
    }

    public ITextComponent readChatComponent() {
        return ITextComponent.Serializer.func_150699_a((String)this.readString());
    }

    public Vec3d readVec() {
        return new Vec3d((double)this.data.readFloat(), (double)this.data.readFloat(), (double)this.data.readFloat());
    }

    public void writeString(String string) {
        if (string == null) {
            this.data.writeShort(0);
        } else {
            byte[] stringData = string.getBytes(Charset.forName("UTF-8"));
            this.data.writeShort(stringData.length);
            this.data.writeBytes(stringData);
        }
    }

    public String readString() {
        short length = this.data.readShort();
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        this.data.readBytes(bytes);
        return new String(bytes, Charset.forName("UTF-8"));
    }

    public void writeNBT(NBTTagCompound tag) {
        if (tag == null) {
            this.data.writeShort(0);
            return;
        }
        try {
            byte[] compressed = PacketBuffer.compress(tag);
            this.data.writeShort(compressed.length);
            this.data.writeBytes(compressed);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public NBTTagCompound readNBT() {
        int length = this.data.readUnsignedShort();
        if (length <= 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        this.data.readBytes(bytes);
        try {
            return PacketBuffer.readCompressed(bytes);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void writeItemStack(ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            this.data.writeByte(0);
        } else {
            this.data.writeByte(item.field_77994_a);
            this.data.writeShort(Item.func_150891_b((Item)item.func_77973_b()));
            this.data.writeShort(item.func_77952_i());
            NBTTagCompound nbttagcompound = null;
            if (item.func_77973_b().func_77651_p() || item.func_77973_b().func_77645_m()) {
                nbttagcompound = item.func_77978_p();
            }
            this.writeNBT(nbttagcompound);
        }
    }

    public ItemStack readItemStack() {
        short stackSize = this.data.readUnsignedByte();
        if (stackSize == 0) {
            return null;
        }
        short id = this.data.readShort();
        short metadata = this.data.readShort();
        Item itemById = Item.func_150899_d((int)id);
        if (itemById == null) {
            return null;
        }
        ItemStack itemstack = new ItemStack(itemById, (int)stackSize, (int)metadata);
        itemstack.func_77982_d(this.readNBT());
        return itemstack;
    }

    public void writeBlockPos(BlockPos pos) {
        this.data.writeInt(pos.func_177958_n());
        this.data.writeByte(pos.func_177956_o());
        this.data.writeInt(pos.func_177952_p());
    }

    public BlockPos readBlockPos() {
        return new BlockPos(this.data.readInt(), (int)this.data.readUnsignedByte(), this.data.readInt());
    }

    public void writeSide(EnumFacing e) {
        this.data.writeByte(e.ordinal());
    }

    public EnumFacing readSide() {
        return EnumFacing.values()[this.data.readByte()];
    }

    public void writePacketBuffer(PacketBuffer packetBuffer) {
        this.writeInt(packetBuffer.data.readableBytes());
        this.data.writeBytes(packetBuffer.data);
    }

    public PacketBuffer readPacketBuffer() {
        int len = this.readInt();
        ByteBuf buffer = Unpooled.buffer((int)len);
        this.data.readBytes(buffer, len);
        return new PacketBuffer(buffer);
    }

    public GameProfile readProfile() {
        UUID id;
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        String name = (b & 1) != 0 ? this.readString() : null;
        if ((b & 2) != 0) {
            long low = this.readLong();
            long upp = this.readLong();
            id = new UUID(upp, low);
        } else {
            id = null;
        }
        return new GameProfile(id, name);
    }

    public void writeProfile(GameProfile profile) {
        UUID id = profile.getId();
        String name = profile.getName();
        if (id == null) {
            if (StringUtils.isBlank((CharSequence)name)) {
                this.writeByte(0);
            } else {
                this.writeByte(1);
                this.writeString(name);
            }
        } else {
            long low = id.getLeastSignificantBits();
            long upp = id.getMostSignificantBits();
            if (StringUtils.isBlank((CharSequence)name)) {
                this.writeByte(2);
                this.writeLong(low);
                this.writeLong(upp);
            } else {
                this.writeByte(3);
                this.writeString(name);
                this.writeLong(low);
                this.writeLong(upp);
            }
        }
    }

    public void writeFluidStack(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            this.writeString(null);
        } else {
            this.writeString(FluidRegistry.getFluidName((FluidStack)fluid));
            this.writeInt(fluid.amount);
            this.writeNBT(fluid.tag);
        }
    }

    public FluidStack readFluidStack() {
        String s = this.readString();
        if (s == null || "".equals(s)) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)s);
        int amount = this.readInt();
        NBTTagCompound tag = this.readNBT();
        return new FluidStack(fluid, amount, tag);
    }
}

