/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineRegistry;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.gui.backend.WidgetEnergyStorage;
import com.rwtema.extrautils2.gui.backend.WidgetProgressArrow;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.ConcatItemHandler;
import com.rwtema.extrautils2.itemhandler.ItemStackHandlerBase;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerUpgrades;
import com.rwtema.extrautils2.machine.BlockMachine;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.Validate;

public abstract class TileMachine
extends TilePower
implements ITickable,
IEnergyHandler,
IDynamicHandler {
    public SingleStackHandlerUpgrades upgrades = this.registerNBT("upgrades", new SingleStackHandlerUpgrades(EnumSet.of(Upgrade.SPEED)){

        @Override
        protected void onContentsChanged() {
            TileMachine.this.func_70296_d();
            PowerManager.instance.markDirty(TileMachine.this);
        }
    });
    public Map<MachineSlotFluid, FluidStack> fluidInputMap;
    public Map<MachineSlotItem, ItemStack> itemInputMap;
    public IMachineRecipe curRecipe;
    public int totalTime;
    public int energyOutput;
    protected EnergyStorage storage = new EnergyStorage(Integer.MAX_VALUE);
    String type;
    ComponentHandler<ItemStack> savedItems = this.registerNBT("items", new ComponentHandler<ItemStack>(){

        @Override
        protected NBTTagCompound serialize(ItemStack value) {
            return value.serializeNBT();
        }

        @Override
        protected ItemStack deserialize(NBTTagCompound tag) {
            return ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    });
    ComponentHandler<FluidStack> savedFluids = this.registerNBT("fluids", new ComponentHandler<FluidStack>(){

        @Override
        protected NBTTagCompound serialize(FluidStack value) {
            return value.writeToNBT(new NBTTagCompound());
        }

        @Override
        protected FluidStack deserialize(NBTTagCompound tag) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        }
    });
    IFluidHandler fluidHandlerInputs = EmptyFluidHandler.INSTANCE;
    IFluidHandler fluidHandlerOutputs = EmptyFluidHandler.INSTANCE;
    Machine machine;
    int processTime;
    private boolean recalc = true;
    IItemHandlerModifiable itemHandlerOutputs = new ItemStackHandlerBase(){

        @Override
        public ItemStack getStack(int slot) {
            if (slot < 0) {
                return null;
            }
            Machine machine = TileMachine.this.machine;
            if (machine == null || slot >= machine.itemOutputs.size()) {
                return null;
            }
            MachineSlotItem slotItem = machine.itemOutputs.get(slot);
            String name = slotItem.name;
            return (ItemStack)TileMachine.this.savedItems.contents.get(name);
        }

        @Override
        public void setStack(int slot, ItemStack stack) {
            if (slot < 0) {
                return;
            }
            Machine machine = TileMachine.this.machine;
            if (machine == null || slot >= machine.itemOutputs.size()) {
                return;
            }
            MachineSlotItem slotItem = machine.itemOutputs.get(slot);
            String name = slotItem.name;
            if (stack == null) {
                TileMachine.this.savedItems.contents.remove(name);
            } else {
                TileMachine.this.savedItems.contents.put(name, stack);
            }
        }

        @Override
        protected void onContentsChanged(int slot) {
            TileMachine.this.func_70296_d();
            TileMachine.this.recalc = true;
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public int getSlots() {
            Machine machine = TileMachine.this.machine;
            if (machine == null) {
                return 0;
            }
            return machine.itemOutputs.size();
        }
    };
    IItemHandlerModifiable itemHandlerInputs = new ItemStackHandlerBase(){

        @Override
        public ItemStack getStack(int slot) {
            if (slot < 0) {
                return null;
            }
            Machine machine = TileMachine.this.machine;
            if (machine == null || slot >= machine.itemInputs.size()) {
                return null;
            }
            MachineSlotItem slotItem = machine.itemInputs.get(slot);
            String name = slotItem.name;
            return (ItemStack)TileMachine.this.savedItems.contents.get(name);
        }

        @Override
        public void setStack(int slot, ItemStack stack) {
            if (slot < 0) {
                return;
            }
            Machine machine = TileMachine.this.machine;
            if (machine == null || slot >= machine.itemInputs.size()) {
                return;
            }
            MachineSlotItem slotItem = machine.itemInputs.get(slot);
            String name = slotItem.name;
            if (stack == null) {
                TileMachine.this.savedItems.contents.remove(name);
            } else {
                TileMachine.this.savedItems.contents.put(name, stack);
            }
        }

        @Override
        protected void onContentsChanged(int slot) {
            TileMachine.this.func_70296_d();
            TileMachine.this.recalc = true;
        }

        public int getSlots() {
            Machine machine = TileMachine.this.machine;
            if (machine == null) {
                return 0;
            }
            return machine.itemInputs.size();
        }

        @Override
        protected int getStackLimit(int slot, ItemStack stack) {
            if (!TileMachine.this.isValidInput(slot, stack)) {
                return 0;
            }
            return Math.min(TileMachine.this.machine.itemInputs.get((int)slot).stackCapacity, stack.func_77976_d());
        }
    };
    private IItemHandler itemHandlerPublic = ConcatItemHandler.concatNonNull(new IItemHandler[]{new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, ItemStack stack) {
            TileMachine.this.itemHandlerInputs.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return TileMachine.this.itemHandlerInputs.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return TileMachine.this.itemHandlerInputs.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return TileMachine.this.itemHandlerInputs.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return null;
            }
            ItemStack stack = TileMachine.this.itemHandlerInputs.getStackInSlot(slot);
            if (stack == null || TileMachine.this.isValidInput(slot, stack)) {
                return null;
            }
            return TileMachine.this.itemHandlerInputs.extractItem(slot, amount, simulate);
        }
    }, this.itemHandlerOutputs});
    private boolean processing;
    private int processingCooldown = 0;

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.itemHandlerPublic;
    }

    public boolean isValidInput(int slot, ItemStack stack) {
        if (this.machine == null || slot >= this.machine.itemInputs.size()) {
            return false;
        }
        MachineSlotItem slotItem = this.machine.itemInputs.get(slot);
        this.buildInputMaps();
        for (IMachineRecipe recipe : this.machine.recipes_registry) {
            if (!recipe.allowInputItem(slotItem, stack, this.itemInputMap, this.fluidInputMap)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack, xuBlock);
        this.type = "blank";
        if (stack != null && stack.func_77942_o()) {
            this.type = ((NBTTagCompound)Validate.notNull((Object)stack.func_77978_p())).func_74779_i("Type");
        }
        this.machine = MachineRegistry.getMachine(this.type);
        this.storage.setCapacity(this.machine == null ? 0 : this.machine.energyBufferSize);
    }

    @Override
    public void addToDescriptionPacket(PacketBuffer packet) {
        packet.writeString(this.type);
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        String s = packet.readString();
        if (this.type == null || !this.type.equals(s)) {
            this.type = s;
            this.machine = MachineRegistry.getMachine(this.type);
            this.field_145850_b.func_147458_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbt = super.func_189515_b(compound);
        if (this.type != null) {
            nbt.func_74778_a("Type", this.type);
        }
        nbt.func_74768_a("ProcessTime", this.processTime);
        nbt.func_74757_a("Processing", this.processing);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.storage.setCapacity(Integer.MAX_VALUE);
        super.func_145839_a(nbt);
        this.type = nbt.func_74779_i("Type");
        this.machine = MachineRegistry.getMachine(this.type);
        this.storage.setCapacity(this.machine == null ? 0 : this.machine.energyBufferSize);
        this.processTime = nbt.func_74762_e("ProcessTime");
        this.processing = nbt.func_74767_n("Processing");
    }

    public void setActive() {
        this.processingCooldown = 100;
        if (!this.processing) {
            this.field_145850_b.func_180501_a(this.field_174879_c, this.getBlockState().func_177226_a((IProperty)BlockMachine.ACTIVE, Boolean.valueOf(true)), 2);
        }
        this.processing = true;
    }

    public void setInactive() {
        this.processing = false;
    }

    public void func_73660_a() {
        Machine machine = this.machine;
        if (this.field_145850_b.field_72995_K || machine == null) {
            return;
        }
        if (!this.processing && this.processingCooldown > 0) {
            --this.processingCooldown;
            if (this.processingCooldown == 0) {
                this.field_145850_b.func_180501_a(this.field_174879_c, this.getBlockState().func_177226_a((IProperty)BlockMachine.ACTIVE, Boolean.valueOf(false)), 2);
            }
        }
        this.process();
    }

    public abstract void process();

    public void processRecipeInput() {
        if (this.recalc) {
            this.recalc = false;
            this.buildInputMaps();
            IMachineRecipe prevRecipe = this.curRecipe;
            this.curRecipe = null;
            block0: for (IMachineRecipe recipe : this.machine.recipes_registry) {
                if (!recipe.matches(this.itemInputMap, this.fluidInputMap)) continue;
                Map<MachineSlotItem, ItemStack> itemOutputs = recipe.getItemOutputs(this.itemInputMap, this.fluidInputMap);
                Map<MachineSlotFluid, FluidStack> fluidOutputs = recipe.getFluidOutputs(this.itemInputMap, this.fluidInputMap);
                for (MachineSlotItem machineSlotItem : this.machine.itemOutputs) {
                    ItemStack curStack;
                    ItemStack stack = itemOutputs.get(machineSlotItem);
                    if (stack == null || (curStack = (ItemStack)this.savedItems.contents.get(machineSlotItem.name)) == null || ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)curStack) && stack.field_77994_a + curStack.field_77994_a <= Math.min(machineSlotItem.stackCapacity, stack.func_77976_d())) continue;
                    continue block0;
                }
                for (MachineSlotFluid machineSlotFluid : this.machine.fluidOutputs) {
                    FluidStack fluidStack1;
                    FluidStack fluidStack = fluidOutputs.get(machineSlotFluid);
                    if (fluidStack == null || (fluidStack1 = (FluidStack)this.savedFluids.contents.get(machineSlotFluid.name)) == null || fluidStack.isFluidEqual(fluidStack1) && fluidStack.amount + fluidStack1.amount <= machineSlotFluid.stackCapacity) continue;
                    continue block0;
                }
                this.curRecipe = recipe;
                break;
            }
            if (this.curRecipe == null || prevRecipe != this.curRecipe) {
                this.processTime = 0;
            }
        }
    }

    public void buildInputMaps() {
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        for (MachineSlotItem itemInput : this.machine.itemInputs) {
            ItemStack stack = (ItemStack)this.savedItems.contents.get(itemInput.name);
            if (stack == null) continue;
            itemBuilder.put((Object)itemInput, (Object)stack);
        }
        this.itemInputMap = itemBuilder.build();
        ImmutableMap.Builder fluidBuilder = ImmutableMap.builder();
        for (MachineSlotFluid fluidInput : this.machine.fluidInputs) {
            FluidStack stack = (FluidStack)this.savedFluids.contents.get(fluidInput.name);
            if (stack == null) continue;
            fluidBuilder.put((Object)fluidInput, (Object)stack);
        }
        this.fluidInputMap = fluidBuilder.build();
    }

    protected void consumeInputs() {
        ItemStack stack;
        int i;
        TObjectIntMap<MachineSlot> amountToConsume = this.curRecipe.getAmountToConsume(this.itemInputMap, this.fluidInputMap);
        Map<MachineSlotItem, ItemStack> itemOutputs = this.curRecipe.getItemOutputs(this.itemInputMap, this.fluidInputMap);
        Map<MachineSlotFluid, FluidStack> fluidOutputs = this.curRecipe.getFluidOutputs(this.itemInputMap, this.fluidInputMap);
        Map<MachineSlotItem, ItemStack> containerItems = this.curRecipe.getContainerItems(this.itemInputMap, this.fluidInputMap);
        TObjectFloatMap<MachineSlot> probabilityModifier = this.curRecipe.getProbabilityModifier(this.itemInputMap, this.fluidInputMap);
        for (MachineSlotItem machineSlotItem : this.machine.itemInputs) {
            i = amountToConsume.get((Object)machineSlotItem);
            if (i == 0 || (stack = (ItemStack)this.savedItems.contents.get(machineSlotItem.name)) == null) continue;
            stack.field_77994_a -= i;
            if (stack.field_77994_a > 0) continue;
            this.savedItems.contents.put(machineSlotItem.name, containerItems.get(machineSlotItem));
        }
        for (MachineSlotFluid machineSlotFluid : this.machine.fluidInputs) {
            i = amountToConsume.get((Object)machineSlotFluid);
            if (i == 0 || (stack = (FluidStack)this.savedFluids.contents.get(machineSlotFluid.name)) == null) continue;
            stack.amount -= i;
            if (stack.amount > 0) continue;
            this.savedFluids.contents.put(machineSlotFluid.name, null);
        }
        for (MachineSlotItem machineSlotItem : this.machine.itemOutputs) {
            ItemStack stack2 = itemOutputs.get(machineSlotItem);
            if (stack2 == null) continue;
            if (probabilityModifier != null && probabilityModifier.containsKey((Object)machineSlotItem)) {
                float v = probabilityModifier.get((Object)machineSlotItem);
                int n = stack2.field_77994_a;
                for (int i2 = 0; i2 < n; ++i2) {
                    if (!(this.field_145850_b.field_73012_v.nextFloat() > v)) continue;
                    --stack2.field_77994_a;
                }
            }
            if (stack2.field_77994_a == 0) continue;
            ItemStack itemStack = (ItemStack)this.savedItems.contents.get(machineSlotItem.name);
            if (itemStack == null) {
                itemStack = stack2.func_77946_l();
                this.savedItems.contents.put(machineSlotItem.name, itemStack);
            } else {
                itemStack.field_77994_a += stack2.field_77994_a;
            }
            itemStack.field_77994_a = Math.min(itemStack.field_77994_a, Math.min(itemStack.func_77976_d(), machineSlotItem.stackCapacity));
        }
        for (MachineSlotFluid machineSlotFluid : this.machine.fluidOutputs) {
            FluidStack stack3 = fluidOutputs.get(machineSlotFluid);
            if (stack3 == null) continue;
            FluidStack fluidStack = (FluidStack)this.savedFluids.contents.get(machineSlotFluid.name);
            if (fluidStack == null) {
                fluidStack = stack3.copy();
                this.savedFluids.contents.put(machineSlotFluid.name, fluidStack);
            } else {
                fluidStack.amount += stack3.amount;
            }
            fluidStack.amount = Math.min(fluidStack.amount, machineSlotFluid.stackCapacity);
        }
        this.recalc = true;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        if (this.machine == null) {
            return null;
        }
        return new ContainerMachine(player);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public Optional<ItemStack> getPickBlock(EntityPlayer player, RayTraceResult target) {
        return Optional.of(((BlockMachine)XU2Entries.machineEntry.value).createStack(this.machine));
    }

    @Override
    public void onPowerChanged() {
    }

    @Override
    public float getPower() {
        int level = this.upgrades.getLevel(Upgrade.SPEED);
        if (level == 0) {
            return Float.NaN;
        }
        return Upgrade.SPEED.getPowerUse(level);
    }

    public abstract class ComponentHandler<T>
    implements INBTSerializable<NBTTagCompound> {
        public HashMap<String, T> contents = new HashMap();

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry<String, T> entry : this.contents.entrySet()) {
                T value = entry.getValue();
                if (value == null) continue;
                tag.func_74782_a(entry.getKey(), (NBTBase)this.serialize(value));
            }
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.contents.clear();
            for (String s : nbt.func_150296_c()) {
                this.contents.put(s, this.deserialize(nbt.func_74775_l(s)));
            }
        }

        protected abstract NBTTagCompound serialize(T var1);

        protected abstract T deserialize(NBTTagCompound var1);
    }

    public class ContainerMachine
    extends DynamicContainerTile {
        protected final EntityPlayer player;

        public ContainerMachine(EntityPlayer player) {
            int i;
            super(TileMachine.this);
            this.player = player;
            this.addWidget(new WidgetBase(0, 16, 50, 50){

                @Override
                public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                    this.x = (ContainerMachine.this.width - this.w) / 2;
                    manager.func_110577_a(TextureMap.field_110575_b);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    gui.func_175175_a(guiLeft + this.x, guiTop + this.y, Textures.getSprite("extrautils2:machine/machine_base_side"), this.w, this.h);
                    String tex = (Boolean)TileMachine.this.getBlockState().func_177229_b((IProperty)BlockMachine.ACTIVE) != false ? TileMachine.this.machine.frontTextureActive : TileMachine.this.machine.frontTexture;
                    gui.func_175175_a(guiLeft + this.x, guiTop + this.y, Textures.getSprite(tex), this.w, this.h);
                    manager.func_110577_a(DynamicGui.texBackground);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
                    gui.func_73729_b(guiLeft + this.x, guiTop + this.y, 128 - this.w / 2, 128 - this.h / 2, this.w, this.h);
                }
            });
            this.addTitle(BlockMachine.getDisplayName(TileMachine.this.machine), false);
            int w = (TileMachine.this.itemHandlerInputs.getSlots() + TileMachine.this.itemHandlerOutputs.getSlots()) * 22 + 4 + 22;
            int x = Math.max(4, 85 - w / 2);
            int y = 32;
            for (i = 0; i < TileMachine.this.itemHandlerInputs.getSlots(); ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)TileMachine.this.itemHandlerInputs, i, x, y));
                x += 22;
            }
            this.addWidget(new WidgetProgressArrow(x, y){

                @Override
                public float getProgress() {
                    if (TileMachine.this.totalTime == 0) {
                        return 0.0f;
                    }
                    return (float)TileMachine.this.processTime / (float)TileMachine.this.totalTime;
                }
            });
            x += 26;
            for (i = 0; i < TileMachine.this.itemHandlerOutputs.getSlots(); ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)TileMachine.this.itemHandlerOutputs, i, x, y));
                x += 18;
                x += 4;
            }
            this.crop(4);
            if (this.width < 170) {
                this.width = 170;
            }
            this.addWidget(new WidgetEnergyStorage(this.width - 24, y - 16, TileMachine.this.storage));
            this.crop(4);
            this.addWidget(TileMachine.this.upgrades.getSpeedUpgradeSlot(this.width - 18 - 4, this.height));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }
}

