/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.backend.ISidedFunction;
import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.blocks.BlockCursedEarth;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.eventhandlers.DropsHandler;
import com.rwtema.extrautils2.power.ClientPower;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.tile.TileResonator;
import com.rwtema.extrautils2.transfernodes.IUpgradeProvider;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemIngredients
extends XUItemFlatMetadata
implements IUpgradeProvider {
    public static final int RED_COAL_MULTIPLIER = 8;
    public static TIntObjectHashMap<Type> metaMap = new TIntObjectHashMap();

    public ItemIngredients() {
        super(ItemIngredients.getTextureArray());
        this.func_77627_a(true);
    }

    public static String[] getTextureArray() {
        int maxMeta = 0;
        for (Type type : Type.values()) {
            maxMeta = Math.max(maxMeta, type.meta);
        }
        String[] strings = new String[maxMeta + 1];
        for (Type type : Type.values()) {
            if (type.meta < 0) continue;
            strings[type.meta] = type.texture;
        }
        return strings;
    }

    @Nonnull
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.getType(stack).onItemUse(stack, playerIn, worldIn, pos, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        super.registerTextures();
        for (Type type : Type.values()) {
            Textures.register(type.texture);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTexture(@Nullable ItemStack itemStack, int renderPass) {
        return this.getType((ItemStack)itemStack).texture;
    }

    public void func_150895_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (Type type : Type.values()) {
            if (type.meta < 0) continue;
            subItems.add(type.newStack());
        }
    }

    public Type getType(ItemStack stack) {
        Type type = (Type)metaMap.get(stack.func_77952_i());
        return type == null ? Type.SYMBOL_ERROR : type;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + this.getType(stack).name().toLowerCase();
    }

    @Override
    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return Lang.translate(this.func_77657_g(stack) + ".name", this.getType(stack).defaultName());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.getType(stack).addInformation(stack, playerIn, tooltip, advanced);
    }

    @Override
    public Upgrade getUpgrades(ItemStack stack) {
        return this.getType(stack).getUpgrades(stack);
    }

    public static enum Type implements IItemStackMaker,
    IUpgradeProvider
    {
        ENCHANTED_BOOK_SKELETON(-7),
        FILTER_SKELETON(-6),
        SYMBOL_TICK(-5),
        SYMBOL_CROSS(-4),
        UPGRADE_SPEED_SKELETON(-3),
        SYMBOL_NOCRAFT(-2),
        SYMBOL_ERROR(-1),
        REDSTONE_CRYSTAL(0, "gemRedstone"){

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(1), XU2Entries.itemEnderShard.newWildcardStack(), "dustRedstone", "dustRedstone", "dustRedstone", "dustRedstone");
                DropsHandler.registerDrops(Blocks.field_150450_ax.func_176223_P(), this.newStack(1), 0.025);
                DropsHandler.registerDrops(Blocks.field_150439_ay.func_176223_P(), this.newStack(1), 0.1);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(ClientPower.powerStatusString());
                if (ClientPower.hasNoPower()) {
                    tooltip.add(Lang.translate("See the Extra Utilities 2 Manual for more info"));
                }
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Tech-Tree Start", "See achievement list for Extra Utilities 2 power tech tree", this, null);
            }
        }
        ,
        REDSTONE_GEAR(1, "gearRedstone"){

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped(this.newStack(1), " T ", "TsT", " T ", Character.valueOf('T'), Blocks.field_150429_aA, Character.valueOf('s'), "plankWood");
            }
        }
        ,
        EYE_REDSTONE(2, "eyeofredstone"){

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(1), Items.field_151079_bi, "dustRedstone", REDSTONE_CRYSTAL.newStack(1));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(ClientPower.powerStatusString());
            }
        }
        ,
        DYE_POWDER_LUNAR(3, "dustLunar"){

            @Override
            public void addRecipes() {
                OreDictionary.registerOre((String)"dyeMagenta", (ItemStack)this.newStack(1));
                TileResonator.register(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), this.newStack(1), 1600);
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Dye of the Moon", "The moons power beckons!", DYE_POWDER_LUNAR, XU2Entries.stoneburnt);
            }
        }
        ,
        RED_COAL(4, "coalPowered"){

            @Override
            public void addRecipes() {
                TileResonator.register(new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), this.newStack(1), 1600, true);
                GameRegistry.registerFuelHandler((IFuelHandler)new IFuelHandler(){
                    ISidedFunction<Integer, Boolean> isFreqPowered = new ISidedFunction<Integer, Boolean>(){

                        @Override
                        @SideOnly(value=Side.SERVER)
                        public Boolean applyServer(Integer input) {
                            return this.isPowered(input);
                        }

                        @Nonnull
                        public Boolean isPowered(Integer input) {
                            PowerManager.PowerFreq powerFreq = PowerManager.instance.getPowerFreq(input);
                            return powerFreq.isPowered();
                        }

                        @Override
                        @SideOnly(value=Side.CLIENT)
                        public Boolean applyClient(Integer input) {
                            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                            if (server == null) {
                                return ClientPower.isPowered();
                            }
                            return this.isPowered(input);
                        }
                    };

                    public int getBurnTime(ItemStack fuel) {
                        if (fuel == null || fuel.func_77952_i() != Type.RED_COAL.meta || fuel.func_77973_b() != XU2Entries.itemIngredients.value) {
                            return 0;
                        }
                        NBTTagCompound nbt = fuel.func_77978_p();
                        if (nbt != null && nbt.func_150297_b("Freq", 3) && ExtraUtils2.proxy.apply(this.isFreqPowered, nbt.func_74762_e("Freq")).booleanValue()) {
                            return 12800;
                        }
                        return 1600;
                    }
                });
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Powered Coal", "Boosts coals power by 8x", RED_COAL, XU2Entries.resonator);
            }
        }
        ,
        MOON_STONE(5, "gemMoon"),
        UPGRADE_SPEED(6, "xuUpgradeSpeed"){

            @Override
            public Upgrade getUpgrades(ItemStack stack) {
                return Upgrade.SPEED;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(1), UPGRADE_BASE, "ingotGold", "blockRedstone");
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Speed Upgrade", "Boosts speed of transfer nodes.", this, UPGRADE_BASE);
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Increases speed of operations."));
                Upgrade.addTooltip(tooltip, stack);
            }
        }
        ,
        UPGRADE_STACK(7, "xuUpgradeStack"){

            @Override
            public Upgrade getUpgrades(ItemStack stack) {
                return Upgrade.STACK_SIZE;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(1), UPGRADE_BASE, "ingotGold", Items.field_151045_i);
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Stack Upgrade", "Boosts amount pulled from transfer nodes.", this, UPGRADE_BASE);
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Increase the number of items"));
                Upgrade.addTooltip(tooltip, stack);
                tooltip.add(Lang.translate("Level 1: 4x, Level 2: 16x, Level 3: 64x"));
            }
        }
        ,
        UPGRADE_MINING(8, "xuUpgradeMining"){

            @Override
            public Upgrade getUpgrades(ItemStack stack) {
                return Upgrade.MINING;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless(this.newStack(1), UPGRADE_BASE, new ItemStack(Items.field_151005_D));
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Mining Upgrade", "Mines objects and fluids from the world.", this, UPGRADE_BASE);
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Allows mining of cobblestone and pumping of water"));
                Upgrade.addTooltip(tooltip, stack);
            }
        }
        ,
        UPGRADE_BASE(9, "xuUpgradeBlank"){

            @Override
            public void addRecipes() {
                TileResonator.register(new ItemStack(Blocks.field_150445_bS), this.newStack(1), 800);
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Transfer Node Upgrades", "Augment the power of nodes", this, XU2Entries.grocket.getMetaMaker(0));
            }
        }
        ,
        EVIL_DROP(10, "dropofevil"){

            @Override
            public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand) {
                if (!XU2Entries.cursedEarth.isActive()) {
                    return EnumActionResult.PASS;
                }
                IBlockState state = worldIn.func_180495_p(pos);
                if (state != Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT) && state != Blocks.field_150349_c.func_176223_P()) {
                    return EnumActionResult.PASS;
                }
                if (!worldIn.field_72995_K) {
                    BlockCursedEarth.startFastSpread(worldIn, pos);
                    --stack.field_77994_a;
                }
                return EnumActionResult.SUCCESS;
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
            }

            @Override
            public void addRecipes() {
                DropsHandler.lootDrops.put((Object)LootTableList.field_186386_ak, (Object)new LootPool(new LootEntry[]{new LootEntryItem((Item)XU2Entries.itemIngredients.value, 1, 0, new LootFunction[]{new SetMetadata(new LootCondition[0], new RandomValueRange((float)this.meta, (float)this.meta))}, new LootCondition[0], "xuLootDropOfEvil")}, new LootCondition[]{new RandomChanceWithLooting(0.1f, 0.1f)}, new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "xuLootDropOfEvil"));
            }
        }
        ,
        DEMON_INGOT(11, "ingotDemonic"){

            @Override
            public void addRecipes() {
                super.addRecipes();
            }
        }
        ,
        ENCHANTED_INGOT(12, "ingotEnchanted"){

            @Override
            public void addRecipes() {
            }
        };

        public final int meta;
        public final String texture;
        public final String oreName;

        private Type(int meta) {
            this(meta, null);
        }

        private Type(int meta, String oreName) {
            this.meta = meta;
            this.oreName = oreName;
            this.texture = this.name().toLowerCase();
            metaMap.put(meta, (Object)this);
            if (meta < 0) {
                metaMap.put(meta + Short.MAX_VALUE, (Object)this);
            }
        }

        public String defaultName() {
            StringBuilder builder = new StringBuilder();
            String[] split = this.name().split("_");
            for (int i = 0; i < split.length; ++i) {
                if (i > 0) {
                    builder.append(" ");
                }
                builder.append(StringHelper.capFirst(split[i], true));
            }
            return builder.toString();
        }

        public void addRecipes() {
        }

        public ItemStack newStack(int amount) {
            int m = this.meta;
            if (m < 0) {
                m += Short.MAX_VALUE;
            }
            return XU2Entries.itemIngredients.newStack(amount, m);
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        }

        @Override
        public ItemStack newStack() {
            return this.newStack(1);
        }

        @Override
        public Upgrade getUpgrades(ItemStack stack) {
            return null;
        }

        public void addAchievement() {
        }

        public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand) {
            return EnumActionResult.PASS;
        }
    }
}

