/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.eventhandlers.ItemEntityInteractionOverride;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.DynamicWindow;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.gui.backend.WidgetButton;
import com.rwtema.extrautils2.gui.backend.WidgetEntity;
import com.rwtema.extrautils2.gui.backend.WidgetRawData;
import com.rwtema.extrautils2.gui.backend.WidgetTextMultiline;
import com.rwtema.extrautils2.gui.backend.WidgetTextSmallText;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.PlayerHelper;
import java.math.BigInteger;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemContract
extends XUItemFlatMetadata
implements IDynamicHandler {
    public static final String TAG_UNDER_CONTRACT = "Contracted";
    static final String TAG_CONTRACT_LEVEL = "ContractLevel";

    public ItemContract() {
        super("contract");
        ItemEntityInteractionOverride.items.add(this);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (!(target instanceof EntityVillager)) {
            return false;
        }
        EntityVillager villager = (EntityVillager)target;
        if (villager.field_70170_p.field_72995_K) {
            return true;
        }
        if (villager.func_70631_g_()) {
            return true;
        }
        if (villager.func_70931_l_() != null) {
            return true;
        }
        if (!PlayerHelper.isPlayerReal(playerIn)) {
            return true;
        }
        NBTTagCompound data = villager.getEntityData();
        if (data.func_74767_n(TAG_UNDER_CONTRACT)) {
            return false;
        }
        if (!data.func_150297_b(TAG_CONTRACT_LEVEL, 3)) {
            int value;
            switch (playerIn.field_70170_p.field_73012_v.nextInt(3)) {
                case 0: {
                    value = 2;
                    break;
                }
                default: {
                    value = 0;
                }
            }
            data.func_74768_a(TAG_CONTRACT_LEVEL, value);
        }
        int i = data.func_74762_e(TAG_CONTRACT_LEVEL);
        int r = 0;
        UUID uuid = villager.getPersistentID();
        long l = uuid.getLeastSignificantBits();
        r ^= (int)(l >>> 32 ^ l);
        l = uuid.getMostSignificantBits();
        playerIn.openGui((Object)ExtraUtils2.instance, -1, playerIn.field_70170_p, villager.func_145782_y(), r ^= (int)(l >>> 32 ^ l), i);
        return true;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int id, int rng, int responseLevel) {
        Entity entityByID = world.func_73045_a(id);
        if (!(entityByID instanceof EntityVillager)) {
            return null;
        }
        EntityVillager villager = (EntityVillager)entityByID;
        villager.func_70932_a_(player);
        return new ContainerContract(villager, player, id, rng, responseLevel);
    }

    public static class ContainerContract
    extends DynamicContainer {
        public static final ResourceLocation texBackground = new ResourceLocation("extrautils2", "textures/parchment.png");
        private static final BigInteger TWO_64 = BigInteger.ONE.shiftLeft(64);
        static String[] keys = new String[]{"villager.response.no_deal", "villager.response.trade_first", "villager.response.deal"};
        public final DynamicWindow sideWindow;
        EntityVillager villager;
        EntityPlayer player;
        InventoryPlayer inventory;

        public ContainerContract(final EntityVillager villager, final EntityPlayer player, int id, int rng, int responseLevel) {
            this.villager = villager;
            this.player = player;
            this.inventory = player.field_71071_by;
            final WidgetTextSmallText text = new WidgetTextSmallText(9, 9, "", 111);
            this.addWidget(text);
            this.addWidget(new WidgetRawData(){

                @Override
                public void addToDescription(PacketBuffer packet) {
                    EntityVillager villager1 = villager;
                    UUID uniqueID = villager1.func_110124_au();
                    packet.writeLong(uniqueID.getLeastSignificantBits() | uniqueID.getMostSignificantBits());
                    packet.writeChatComponent(villager1.func_145748_c_());
                }

                @Override
                public void handleDescriptionPacket(PacketBuffer packet) {
                    long num = packet.readLong();
                    ITextComponent iChatComponent = packet.readChatComponent();
                    text.msg = Lang.translateArgs(false, "villager.contract", "I, \"Villager No. %s\",\nalso known as \"%s\",\n\nbeing of sound mind and body, do agree to allow my physical, spiritual and/or mental essences to be bound to a physical object, and to use any skills that I may currently possess to provide useful service to \"%s\". I agree that my essence shall remain bound to the physical object until either...\n\n1. The object is destroyed\n2. The universe ends\n3. The very concept of time and/or entropy is destroyed or rendered untenable\n4. I get bored of standing around in limbo making weird noises, and float away to the next life (which is unlikely since I like making weird noises).\n\n\nSigned  ______________", ContainerContract.unsigned(num), iChatComponent.func_150254_d(), player.func_70005_c_()).replaceAll("\\\\n", "\n");
                }
            });
            this.width = 130;
            this.height = 165;
            this.sideWindow = new DynamicWindow();
            WidgetBase w = new WidgetEntity((EntityLivingBase)villager, 20, 4, 4, 100, 60);
            this.addWidget(w, this.sideWindow);
            int i = responseLevel % 3;
            if (i == 2) {
                w = new WidgetButton(w.getX(), w.getY() + w.getH() + 4, w.getW(), 20, Lang.translate("Sign")){

                    @Override
                    public void onClickServer(PacketBuffer buffer) {
                        if (villager.field_70128_L) {
                            return;
                        }
                        NBTTagCompound data = villager.getEntityData();
                        if (data.func_74767_n(ItemContract.TAG_UNDER_CONTRACT)) {
                            return;
                        }
                        int i = data.func_74762_e(ItemContract.TAG_CONTRACT_LEVEL);
                        if (i == 2) {
                            if (player.field_71071_by.func_174925_a((Item)XU2Entries.contract.value, -1, 1, null) != 0) {
                                data.func_74757_a(ItemContract.TAG_UNDER_CONTRACT, true);
                            }
                            player.func_71053_j();
                        }
                    }
                };
                this.addWidget(w, this.sideWindow);
            }
            w = new WidgetTextMultiline(w.getX(), w.getY() + w.getH() + 4, Lang.random(keys[i], rng).replaceAll("\\\\n", "\n"), w.getW());
            this.addWidget(w, this.sideWindow);
            this.validate();
        }

        private static String unsigned(long num) {
            BigInteger a = BigInteger.valueOf(num);
            if (a.signum() < 0) {
                a = a.add(TWO_64);
            }
            return a.toString();
        }

        public void func_75134_a(EntityPlayer playerIn) {
            this.villager.func_70932_a_(null);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean drawBackgroundOverride(DynamicGui gui) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(texBackground);
            gui.func_73729_b(gui.field_147003_i, gui.field_147009_r, 0, 0, this.width, this.height);
            return true;
        }

        public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
            return this.villager.func_70931_l_() == playerIn && !this.villager.field_70128_L;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void loadGuiDimensions(DynamicGui dynamicGui) {
            dynamicGui.field_146999_f = this.width;
            dynamicGui.field_147000_g = this.height;
            dynamicGui.field_147003_i = (dynamicGui.field_146294_l - dynamicGui.field_146999_f - this.sideWindow.w) / 2;
            dynamicGui.field_147009_r = (dynamicGui.field_146295_m - dynamicGui.field_147000_g) / 2;
        }
    }
}

