/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.transfernodes.IUpgradeProvider;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.Lang;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class SingleStackHandlerUpgrades
extends SingleStackHandler {
    EnumSet<Upgrade> allowedTypes;

    public SingleStackHandlerUpgrades(EnumSet<Upgrade> allowedTypes) {
        this.allowedTypes = allowedTypes;
    }

    public WidgetSlotItemHandler getSpeedUpgradeSlot(int x, int y) {
        return new WidgetSlotItemHandler((IItemHandler)this, 0, x, y){

            @Override
            public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                super.renderBackground(manager, gui, guiLeft, guiTop);
                if (!this.func_75216_d()) {
                    ItemStack stack = ItemIngredients.Type.UPGRADE_SPEED_SKELETON.newStack();
                    gui.renderStack(stack, guiLeft + this.getX() + 1, guiTop + this.getY() + 1, "");
                }
            }

            @Override
            public List<String> getToolTip() {
                if (SingleStackHandlerUpgrades.this.isEmpty()) {
                    return ImmutableList.of((Object)Lang.translate("Speed Upgrades"));
                }
                return null;
            }
        };
    }

    public int getLevel(Upgrade upgrade) {
        ItemStack stack = this.getStack();
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof IUpgradeProvider)) {
            return 0;
        }
        Upgrade stackUpgrade = ((IUpgradeProvider)item).getUpgrades(stack);
        if (stackUpgrade != upgrade) {
            return 0;
        }
        return Math.min(stack.field_77994_a, upgrade.maxLevel);
    }

    @Override
    protected int getStackLimit(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IUpgradeProvider)) {
            return 0;
        }
        Upgrade upgrade = ((IUpgradeProvider)stack.func_77973_b()).getUpgrades(stack);
        if (!this.allowedTypes.contains((Object)upgrade)) {
            return 0;
        }
        return upgrade.maxLevel;
    }
}

