/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.itemhandler;

import com.rwtema.extrautils2.itemhandler.ConcatFixedLength;
import com.rwtema.extrautils2.itemhandler.PublicWrapper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ConcatItemHandler
implements IItemHandler {
    final IItemHandler[] handlers;

    public ConcatItemHandler(IItemHandler ... handlers) {
        this.handlers = handlers;
    }

    public ConcatItemHandler(Collection<IItemHandler> handlers) {
        this.handlers = handlers.toArray(new IItemHandler[handlers.size()]);
    }

    public static IItemHandler concatNonNull(IItemHandler ... values) {
        boolean fixedLength = true;
        ArrayList<IItemHandler> nonNullHandlers = new ArrayList<IItemHandler>(values.length);
        for (IItemHandler value : values) {
            if (value == null || value == EmptyHandler.INSTANCE) continue;
            nonNullHandlers.add(value);
            IItemHandler t = value;
            while (t instanceof PublicWrapper) {
                t = ((PublicWrapper)t).handler;
            }
            if (t instanceof SingleStackHandler || t instanceof ItemStackHandler) continue;
            fixedLength = false;
        }
        if (nonNullHandlers.isEmpty()) {
            return EmptyHandler.INSTANCE;
        }
        if (nonNullHandlers.size() == 1) {
            return (IItemHandler)nonNullHandlers.get(0);
        }
        if (fixedLength) {
            return ConcatFixedLength.create(nonNullHandlers.toArray(new IItemHandler[nonNullHandlers.size()]));
        }
        return new ConcatItemHandler(nonNullHandlers);
    }

    public int getSlots() {
        int size = 0;
        for (IItemHandler handler : this.handlers) {
            size += handler.getSlots();
        }
        return size;
    }

    public Pair<IItemHandler, Integer> getDestination(int slot) {
        for (IItemHandler handler : this.handlers) {
            int numSlots = handler.getSlots();
            if (slot < numSlots) {
                return Pair.of((Object)handler, (Object)slot);
            }
            slot -= numSlots;
        }
        return null;
    }

    public ItemStack getStackInSlot(int slot) {
        Pair<IItemHandler, Integer> pair = this.getDestination(slot);
        return pair != null ? ((IItemHandler)pair.getLeft()).getStackInSlot(((Integer)pair.getRight()).intValue()) : null;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        Pair<IItemHandler, Integer> pair = this.getDestination(slot);
        return pair != null ? ((IItemHandler)pair.getLeft()).insertItem(((Integer)pair.getRight()).intValue(), stack, simulate) : stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Pair<IItemHandler, Integer> pair = this.getDestination(slot);
        return pair != null ? ((IItemHandler)pair.getLeft()).extractItem(((Integer)pair.getRight()).intValue(), amount, simulate) : null;
    }
}

