/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IWidgetServerNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.network.PacketBuffer;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureManager;

public abstract class WidgetProgressArrow
extends WidgetBase
implements IWidgetServerNetwork {
    public static final int ARROW_WIDTH = 22;
    public static final int ARROW_HEIGHT = 17;
    byte curWidth = (byte)-1;

    public WidgetProgressArrow(int x, int y) {
        super(x, y, 22, 17);
    }

    public abstract float getProgress();

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        this.curWidth = packet.readByte();
    }

    @Override
    public void addToDescription(PacketBuffer packet) {
        packet.writeByte(this.getAdjustedWidth(this.getProgress()));
    }

    private byte getAdjustedWidth(float t) {
        int a = t <= 0.0f ? 0 : (t >= 1.0f ? 22 : 1 + Math.round(t * 21.0f));
        return (byte)a;
    }

    @Override
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        if (this.curWidth > 0) {
            manager.func_110577_a(gui.getWidgetTexture());
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 98, 16, this.curWidth, 16);
        }
    }

    @Override
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        if (this.curWidth < 22) {
            manager.func_110577_a(gui.getWidgetTexture());
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 98, 0, 22, 16);
        }
    }

    @Override
    public List<String> getToolTip() {
        return null;
    }
}

