/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IWidgetServerNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.network.PacketBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WidgetFluidIndicator
extends WidgetBase
implements IWidgetServerNetwork {
    private final int u;
    private final int v;
    @SideOnly(value=Side.CLIENT)
    private FluidStack renderStack;
    @SideOnly(value=Side.CLIENT)
    private float renderPercent;

    public WidgetFluidIndicator(int x, int y) {
        this(x, y, 18, 18, 0, 0);
    }

    public WidgetFluidIndicator(int x, int y, int w, int h, int u, int v) {
        super(x, y, w, h);
        this.u = u;
        this.v = v;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        int h2 = this.getH() - 2;
        int h = Math.round(MathHelper.func_76131_a((float)this.renderPercent, (float)0.0f, (float)1.0f) * (float)h2);
        if (this.renderStack == null || h == 0) {
            return;
        }
        Fluid fluid = this.renderStack.getFluid();
        if (fluid == null) {
            return;
        }
        ResourceLocation still = fluid.getStill(this.renderStack);
        manager.func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(still.toString());
        gui.drawTexturedModalRect(guiLeft + this.getX() + 1, guiTop + this.getY() + 1 + h2 - h, this.getW() - 2, h, sprite.func_94209_e(), sprite.func_94207_b((double)(16.0f - (float)h * 16.0f / (float)h2)), sprite.func_94212_f(), sprite.func_94210_h());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), this.u, this.v, this.getW(), this.getH());
    }

    public abstract FluidStack getFluid();

    public abstract float getFillPercent();

    @Override
    public void addToDescription(PacketBuffer packet) {
        packet.writeFluidStack(this.getFluid());
        packet.writeFloat(this.getFillPercent());
    }

    @Override
    public void handleDescriptionPacket(PacketBuffer packet) {
        this.renderStack = packet.readFluidStack();
        this.renderPercent = packet.readFloat();
    }
}

