/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.DynamicWindow;
import com.rwtema.extrautils2.gui.backend.IWidgetClientNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.network.PacketBuffer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WidgetButton
extends WidgetBase
implements IWidgetClientNetwork {
    public String text;
    @SideOnly(value=Side.CLIENT)
    GuiButton button;
    private DynamicContainer container;

    public WidgetButton(int x, int y, int w, int h, String text) {
        super(x, y, w, h);
        this.text = text;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addToGui(DynamicGui gui) {
        super.addToGui(gui);
        DynamicWindow window = gui.container.getWindowOwner().get(this);
        int x = this.x + gui.field_147003_i + (window != null ? window.x : 0);
        int y = this.y + gui.field_147009_r + (window != null ? window.y : 0);
        this.button = this.createButton(x, y, gui.nextButtonID());
        gui.addButton(this, this.button);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public GuiButton createButton(int x, int y, int id) {
        return new GuiButton(id, x, y, this.w, this.h, this.text);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientClick() {
        this.sendClickToServer();
    }

    public void onClickServer(PacketBuffer buffer) {
    }

    @Override
    public void receiveClientPacket(PacketBuffer buffer) {
        this.onClickServer(buffer);
    }

    @Override
    public void addToContainer(DynamicContainer container) {
        this.container = container;
    }

    @SideOnly(value=Side.CLIENT)
    public void sendClickToServer() {
        this.sendClickToServer(null);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendClickToServer(PacketBuffer buffer) {
        this.container.sendInputPacket(this, buffer);
    }
}

