/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.eventhandlers;

import com.google.common.collect.HashMultimap;
import com.rwtema.extrautils2.utils.XURandom;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class DropsHandler {
    public static HashMultimap<IBlockState, Pair<ItemStack, Double>> drops2add = HashMultimap.create();
    public static HashMultimap<ResourceLocation, LootPool> lootDrops;

    public static void registerDrops(IBlockState state, ItemStack stack, double propability) {
        drops2add.put((Object)state, (Object)Pair.of((Object)stack, (Object)propability));
    }

    @SubscribeEvent
    public void onDrop(BlockEvent.HarvestDropsEvent event) {
        Set pairs = drops2add.get((Object)event.getState());
        if (pairs != null) {
            for (Pair pair : pairs) {
                while (XURandom.rand.nextDouble() < (Double)pair.getRight()) {
                    event.getDrops().add(((ItemStack)pair.getLeft()).func_77946_l());
                }
            }
        }
    }

    @SubscribeEvent
    public void registerLoot(LootTableLoadEvent event) {
        Set stacks = lootDrops.get((Object)event.getName());
        if (stacks.isEmpty()) {
            return;
        }
        for (LootPool pool : stacks) {
            event.getTable().addPool(pool);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new DropsHandler());
        lootDrops = HashMultimap.create();
    }
}

