/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.utils.blockaccess.CompatBlockAccess;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import com.rwtema.extrautils2.utils.helpers.BlockStates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.Validate;

public class PatternRecipe {
    static ArrayList<PatternRecipe> recipeList = new ArrayList();
    public final List<BlockPos> toRender;
    public final HashMap<BlockPos, IBlockState> posMap;
    public final Set<ItemRef> items;
    public final IBlockAccess blockAccess;
    public BlockPos min;
    public BlockPos max;
    public BlockPos mid;
    IBlockState[][][] states;
    List<ItemStack> stacks = new ArrayList<ItemStack>();

    public PatternRecipe(String[][] stateStrings, Map<Character, Object> mapKey, List<ItemStack> stacks) {
        int len_y = stateStrings.length;
        int len_x = stateStrings[0].length;
        int len_z = stateStrings[0][0].length();
        this.min = null;
        this.max = null;
        this.states = new IBlockState[len_y][len_x][len_z];
        this.items = new HashSet<ItemRef>();
        this.toRender = new ArrayList<BlockPos>();
        this.posMap = new HashMap();
        for (int y = 0; y < stateStrings.length; ++y) {
            Validate.isTrue((stateStrings[y].length == len_x ? 1 : 0) != 0);
            String[] stateY = stateStrings[y];
            for (int x = 0; x < stateY.length; ++x) {
                String s = stateY[x];
                Validate.isTrue((s.length() == len_z ? 1 : 0) != 0);
                char[] chars = s.toCharArray();
                for (int z = 0; z < chars.length; ++z) {
                    IBlockState state;
                    Object o = mapKey.get(Character.valueOf(chars[z]));
                    if (o == null) continue;
                    if (o instanceof IBlockState) {
                        state = (IBlockState)o;
                    } else if (o instanceof Block) {
                        state = ((Block)o).func_176223_P();
                    } else {
                        throw new RuntimeException("Object not recognized" + o);
                    }
                    BlockPos pos = new BlockPos(x, 128 + y, z);
                    this.posMap.put(pos, state);
                    if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_180401_cv) continue;
                    if (this.min == null) {
                        this.min = pos;
                        this.max = pos;
                    } else {
                        this.min = new BlockPos(Math.min(this.min.func_177958_n(), pos.func_177958_n()), Math.min(this.min.func_177956_o(), pos.func_177956_o()), Math.min(this.min.func_177952_p(), pos.func_177952_p()));
                        this.max = new BlockPos(Math.max(this.max.func_177958_n(), pos.func_177958_n()), Math.max(this.max.func_177956_o(), pos.func_177956_o()), Math.max(this.max.func_177952_p(), pos.func_177952_p()));
                    }
                    this.toRender.add(pos);
                    Block block = state.func_177230_c();
                    Item itemDropped = Item.func_150898_a((Block)block);
                    if (itemDropped == null) continue;
                    this.items.add(ItemRef.wrap(new ItemStack(itemDropped, 1, block.func_180651_a(state))));
                }
            }
        }
        this.mid = this.min.func_177971_a((Vec3i)this.max);
        this.mid = new BlockPos(this.mid.func_177958_n() / 2, this.mid.func_177956_o() / 2, this.mid.func_177952_p() / 2);
        this.stacks = stacks;
        this.blockAccess = new CompatBlockAccess(){

            @Nullable
            public TileEntity func_175625_s(@Nonnull BlockPos pos) {
                return null;
            }

            public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
                int j = 15;
                if (j < lightValue) {
                    j = lightValue;
                }
                return 0xF00000 | j << 4;
            }

            @Nonnull
            public IBlockState func_180495_p(@Nonnull BlockPos pos) {
                return PatternRecipe.this.posMap.getOrDefault(pos, BlockStates.air);
            }

            public boolean func_175623_d(@Nonnull BlockPos pos) {
                IBlockState blockState = this.func_180495_p(pos);
                return blockState == BlockStates.air || blockState.func_177230_c().isAir(blockState, (IBlockAccess)this, pos);
            }

            @Nonnull
            public Biome func_180494_b(@Nonnull BlockPos pos) {
                return Biomes.field_76772_c;
            }

            @Override
            public boolean extendedLevelsInChunkCache() {
                return false;
            }

            public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
                return 0;
            }

            @Nonnull
            public WorldType func_175624_G() {
                return WorldType.field_77138_c;
            }

            public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
                return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
            }
        };
    }

    public static void register(String[][] stateStrings, Map<Character, Object> mapKey, ItemStack ... stacks) {
        recipeList.add(new PatternRecipe(stateStrings, mapKey, Lists.newArrayList((Object[])stacks)));
    }
}

