/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.rwtema.extrautils2.api.recipes.IRecipeInfoWrapper;
import com.rwtema.extrautils2.crafting.jei.XUJEIPlugin;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesHandler;
import mezz.jei.plugins.vanilla.crafting.ShapelessOreRecipeHandler;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipesHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class JEIVanillaCraftingRecipeHandler<T extends IRecipeInfoWrapper>
implements IRecipeHandler<T> {
    public static HashMap<Class, IRecipeHandler<?>> handlers;
    final Class<T> clazz;

    public JEIVanillaCraftingRecipeHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static HashMap<Class, IRecipeHandler<?>> getHandlers() {
        if (handlers != null) {
            return handlers;
        }
        handlers = new HashMap();
        handlers.put(ShapedOreRecipe.class, (IRecipeHandler<?>)new ShapedOreRecipeHandler());
        handlers.put(ShapedRecipes.class, (IRecipeHandler<?>)new ShapedRecipesHandler());
        handlers.put(ShapelessOreRecipe.class, (IRecipeHandler<?>)new ShapelessOreRecipeHandler(XUJEIPlugin.guiHelper));
        handlers.put(ShapelessRecipes.class, (IRecipeHandler<?>)new ShapelessRecipesHandler(XUJEIPlugin.guiHelper));
        return handlers;
    }

    @Nullable
    public static IRecipeHandler getHandler(IRecipe recipe) {
        IRecipeHandler<?> recipeHandler = null;
        Class<?> clazz = recipe.getClass();
        while (!clazz.equals(Object.class) && (recipeHandler = JEIVanillaCraftingRecipeHandler.getHandlers().get(clazz)) == null) {
            clazz = clazz.getSuperclass();
        }
        return recipeHandler;
    }

    @Nonnull
    public Class<T> getRecipeClass() {
        return this.clazz;
    }

    @Nonnull
    public String getRecipeCategoryUid() {
        return "minecraft.crafting";
    }

    @Nonnull
    public String getRecipeCategoryUid(@Nonnull T recipe) {
        return "minecraft.crafting";
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull T recipe) {
        Object originalRecipe = recipe.getOriginalRecipe();
        IRecipeHandler recipeHandler = JEIVanillaCraftingRecipeHandler.getHandler(originalRecipe);
        if (recipeHandler == null) {
            throw new RuntimeException("Recipe Handler not found, it should have been.");
        }
        return this.wrapRecipe(recipe, recipeHandler.getRecipeWrapper(originalRecipe));
    }

    public IRecipeWrapper wrapRecipe(T recipe, IRecipeWrapper wrapper) {
        if (recipe.info() == null) {
            return wrapper;
        }
        if (wrapper instanceof IShapedCraftingRecipeWrapper) {
            IShapedCraftingRecipeWrapper w = (IShapedCraftingRecipeWrapper)wrapper;
            return new MyIShapedCraftingRecipeWrapper(this, w, recipe);
        }
        if (wrapper instanceof ICraftingRecipeWrapper) {
            ICraftingRecipeWrapper w = (ICraftingRecipeWrapper)wrapper;
            return new MyICraftingRecipeWrapper(this, w, recipe);
        }
        return wrapper;
    }

    public void drawInfo(T recipe, ICraftingRecipeWrapper iCraftingRecipeWrapper, Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String info = recipe.info();
        if (info != null) {
            minecraft.field_71466_p.func_78276_b(info, 60, 10, Color.black.getRGB());
        }
    }

    public boolean isRecipeValid(@Nonnull T recipe) {
        Object originalRecipe = recipe.getOriginalRecipe();
        if (originalRecipe == null) {
            return false;
        }
        IRecipeHandler handler = JEIVanillaCraftingRecipeHandler.getHandler(originalRecipe);
        return handler != null && handler.isRecipeValid(originalRecipe);
    }

    private static class MyICraftingRecipeWrapper
    implements ICraftingRecipeWrapper {
        protected final ICraftingRecipeWrapper w;
        protected final T recipe;
        final /* synthetic */ JEIVanillaCraftingRecipeHandler this$0;

        public MyICraftingRecipeWrapper(ICraftingRecipeWrapper w, T recipe) {
            this.this$0 = var1_1;
            this.w = w;
            this.recipe = recipe;
        }

        @Nonnull
        public List getInputs() {
            return this.w.getInputs();
        }

        @Nonnull
        public List<ItemStack> getOutputs() {
            return this.w.getOutputs();
        }

        public List<FluidStack> getFluidInputs() {
            return this.w.getFluidInputs();
        }

        public List<FluidStack> getFluidOutputs() {
            return this.w.getFluidOutputs();
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            this.w.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
            this.this$0.drawInfo(this.recipe, this, minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        }

        public void drawAnimations(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight) {
            this.w.drawAnimations(minecraft, recipeWidth, recipeHeight);
        }

        @Nullable
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            return this.w.getTooltipStrings(mouseX, mouseY);
        }

        public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return this.w.handleClick(minecraft, mouseX, mouseY, mouseButton);
        }
    }

    private static class MyIShapedCraftingRecipeWrapper
    extends MyICraftingRecipeWrapper
    implements IShapedCraftingRecipeWrapper {
        private final IShapedCraftingRecipeWrapper w;
        final /* synthetic */ JEIVanillaCraftingRecipeHandler this$0;

        public MyIShapedCraftingRecipeWrapper(IShapedCraftingRecipeWrapper w, T recipe) {
            this.this$0 = var1_1;
            super((JEIVanillaCraftingRecipeHandler)var1_1, (ICraftingRecipeWrapper)w, recipe);
            this.w = w;
        }

        public int getWidth() {
            return this.w.getWidth();
        }

        public int getHeight() {
            return this.w.getHeight();
        }
    }
}

