/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.tile.TileAdvInteractor;
import com.rwtema.extrautils2.tile.TileMine;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.tile.TileScanner;
import com.rwtema.extrautils2.tile.TileUse;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.datastructures.ThreadLocalBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockAdvInteractor
extends XUBlockStatic {
    private final String texture;

    public BlockAdvInteractor(String texture) {
        this.texture = texture;
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        BoxModel model = this.getModel();
        model.rotateToSide(((EnumFacing)state.func_177229_b((IProperty)XUBlockStateCreator.ROTATION_ALL)).func_176734_d());
        return model;
    }

    @Override
    @Nonnull
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        return (BoxModel)this.cachedInvModels.get(this.xuBlockState.getStateFromItemStack(item));
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator.Builder(this).addWorldPropertyWithDefault(XUBlockStateCreator.ROTATION_ALL, EnumFacing.UP).addMetaProperty(TilePower.ENABLED_STATE).build();
    }

    @Override
    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)XUBlockStateCreator.ROTATION_ALL, (Comparable)BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    protected BoxModel getModel() {
        BoxModel model = BoxModel.newStandardBlock("interact_side");
        model.setTextures(EnumFacing.UP, this.texture);
        model.setTextures(EnumFacing.DOWN, "interact_back");
        return model;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public abstract XUTile createTileEntity(@Nonnull World var1, @Nonnull IBlockState var2);

    public static class Scanner
    extends BlockAdvInteractor {
        public Scanner() {
            super("interact_scanner");
        }

        public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
            XUTile tile = this.getTile(blockAccess, pos);
            return tile instanceof TileScanner && ((TileScanner)tile).isPowered() ? 15 : 0;
        }

        public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
            return false;
        }

        public boolean func_149744_f(IBlockState state) {
            return true;
        }

        @Override
        @Nonnull
        public XUTile createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
            return new TileScanner();
        }

        @Override
        @Nonnull
        protected XUBlockStateCreator createBlockState() {
            return new XUBlockStateCreator.Builder(this).addWorldPropertyWithDefault(XUBlockStateCreator.ROTATION_ALL, EnumFacing.UP).build();
        }
    }

    public static class Use
    extends BlockAdvInteractor {
        public static final ThreadLocalBoolean rayTraceFlag = new ThreadLocalBoolean(false);

        public Use() {
            super("interact_use");
        }

        @Override
        @Nonnull
        public TileAdvInteractor createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
            return new TileUse();
        }

        @Override
        @Nullable
        public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
            if (((Boolean)rayTraceFlag.get()).booleanValue()) {
                return null;
            }
            return super.func_180636_a(blockState, worldIn, pos, start, end);
        }
    }

    public static class Mine
    extends BlockAdvInteractor {
        public Mine() {
            super("interact_mine");
        }

        @Override
        @Nonnull
        public TileAdvInteractor createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
            return new TileMine();
        }
    }
}

