/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.entries;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.api.machine.Crusher;
import com.rwtema.extrautils2.api.machine.Furnace;
import com.rwtema.extrautils2.api.machine.Generator;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineRegistry;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.api.machine.RecipeBuilder;
import com.rwtema.extrautils2.backend.entries.BlockClassEntry;
import com.rwtema.extrautils2.backend.entries.BlockCompressedEntry;
import com.rwtema.extrautils2.backend.entries.BlockEntry;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.ItemClassEntry;
import com.rwtema.extrautils2.backend.entries.ItemEnderShardEntry;
import com.rwtema.extrautils2.backend.entries.ItemEntry;
import com.rwtema.extrautils2.backend.entries.ItemEntrySickle;
import com.rwtema.extrautils2.backend.entries.MultiBlockEntry;
import com.rwtema.extrautils2.backend.entries.PotionEntry;
import com.rwtema.extrautils2.backend.entries.VillagerEntrySimple;
import com.rwtema.extrautils2.backend.entries.VoidEntry;
import com.rwtema.extrautils2.blocks.BlockAdvInteractor;
import com.rwtema.extrautils2.blocks.BlockAngelBlock;
import com.rwtema.extrautils2.blocks.BlockCrafter;
import com.rwtema.extrautils2.blocks.BlockCursedEarth;
import com.rwtema.extrautils2.blocks.BlockDecorativeGlass;
import com.rwtema.extrautils2.blocks.BlockDecorativeSolid;
import com.rwtema.extrautils2.blocks.BlockDecorativeSolidWood;
import com.rwtema.extrautils2.blocks.BlockDrum;
import com.rwtema.extrautils2.blocks.BlockEnderLilly;
import com.rwtema.extrautils2.blocks.BlockMoonStone;
import com.rwtema.extrautils2.blocks.BlockPassiveGenerator;
import com.rwtema.extrautils2.blocks.BlockPlayerChest;
import com.rwtema.extrautils2.blocks.BlockPowerOverload;
import com.rwtema.extrautils2.blocks.BlockRedOrchid;
import com.rwtema.extrautils2.blocks.BlockRedstoneClock;
import com.rwtema.extrautils2.blocks.BlockResonator;
import com.rwtema.extrautils2.blocks.BlockScreen;
import com.rwtema.extrautils2.blocks.BlockSoundMuffler;
import com.rwtema.extrautils2.blocks.BlockSpotlight;
import com.rwtema.extrautils2.blocks.BlockTrashCan;
import com.rwtema.extrautils2.blocks.BlockWardChunkLoader;
import com.rwtema.extrautils2.crafting.AdvShapelessRecipeBase;
import com.rwtema.extrautils2.crafting.AlwaysLast;
import com.rwtema.extrautils2.crafting.BurnList;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.crafting.EnchantRecipe;
import com.rwtema.extrautils2.crafting.XUShapedRecipe;
import com.rwtema.extrautils2.entity.EntityBoomerang;
import com.rwtema.extrautils2.eventhandlers.CreativeEPHandler;
import com.rwtema.extrautils2.eventhandlers.ProddingStickHandler;
import com.rwtema.extrautils2.eventhandlers.RareSeedHandler;
import com.rwtema.extrautils2.items.ItemAngelBlock;
import com.rwtema.extrautils2.items.ItemAngelRing;
import com.rwtema.extrautils2.items.ItemBagOfHolding;
import com.rwtema.extrautils2.items.ItemBlockPlantable;
import com.rwtema.extrautils2.items.ItemBook;
import com.rwtema.extrautils2.items.ItemBoomerang;
import com.rwtema.extrautils2.items.ItemBuildersWand;
import com.rwtema.extrautils2.items.ItemContract;
import com.rwtema.extrautils2.items.ItemDestructionWand;
import com.rwtema.extrautils2.items.ItemFakeCopy;
import com.rwtema.extrautils2.items.ItemFilterFluids;
import com.rwtema.extrautils2.items.ItemFilterItems;
import com.rwtema.extrautils2.items.ItemGlassCutter;
import com.rwtema.extrautils2.items.ItemGoldenLasso;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.items.ItemKlein;
import com.rwtema.extrautils2.items.ItemLawSword;
import com.rwtema.extrautils2.items.ItemPowerManager;
import com.rwtema.extrautils2.items.ItemSunCrystal;
import com.rwtema.extrautils2.items.ItemWateringCan;
import com.rwtema.extrautils2.items.ItemWrench;
import com.rwtema.extrautils2.items.itemmatching.IMatcher;
import com.rwtema.extrautils2.machine.BlockMachine;
import com.rwtema.extrautils2.machine.ItemBlockMachine;
import com.rwtema.extrautils2.machine.TileMachineProvider;
import com.rwtema.extrautils2.machine.TileMachineReceiver;
import com.rwtema.extrautils2.potion.PotionFizzyLifting;
import com.rwtema.extrautils2.potion.PotionGravity;
import com.rwtema.extrautils2.potion.PotionLove;
import com.rwtema.extrautils2.potion.PotionNapalm;
import com.rwtema.extrautils2.potion.PotionRelapse;
import com.rwtema.extrautils2.potion.PotionSecondChance;
import com.rwtema.extrautils2.potion.PotionsHelper;
import com.rwtema.extrautils2.recipes.GenericMachineRecipe;
import com.rwtema.extrautils2.recipes.SingleInputStackMatchRecipe;
import com.rwtema.extrautils2.recipes.SingleInputStackToStackRecipe;
import com.rwtema.extrautils2.tile.TileChunkLoader;
import com.rwtema.extrautils2.tile.TileCrafter;
import com.rwtema.extrautils2.tile.TileDrum;
import com.rwtema.extrautils2.tile.TileMine;
import com.rwtema.extrautils2.tile.TilePassiveGenerator;
import com.rwtema.extrautils2.tile.TilePlayerChest;
import com.rwtema.extrautils2.tile.TilePowerHandCrank;
import com.rwtema.extrautils2.tile.TilePowerOverload;
import com.rwtema.extrautils2.tile.TileResonator;
import com.rwtema.extrautils2.tile.TileScanner;
import com.rwtema.extrautils2.tile.TileScreen;
import com.rwtema.extrautils2.tile.TileSoundMuffler;
import com.rwtema.extrautils2.tile.TileSpotlight;
import com.rwtema.extrautils2.tile.TileTrashCan;
import com.rwtema.extrautils2.tile.TileUse;
import com.rwtema.extrautils2.transfernodes.BlockIndexer;
import com.rwtema.extrautils2.transfernodes.BlockTransferHolder;
import com.rwtema.extrautils2.transfernodes.BlockTransferPipe;
import com.rwtema.extrautils2.transfernodes.GrocketType;
import com.rwtema.extrautils2.transfernodes.ItemBlockPipe;
import com.rwtema.extrautils2.transfernodes.ItemGrocket;
import com.rwtema.extrautils2.transfernodes.ItemIndexerRemote;
import com.rwtema.extrautils2.transfernodes.TileIndexer;
import com.rwtema.extrautils2.transfernodes.TileTransferHolder;
import com.rwtema.extrautils2.villagers.EmeraldForPotions;
import com.rwtema.extrautils2.villagers.EntityAINinjaPoof;
import com.rwtema.extrautils2.villagers.GenericTrade;
import com.rwtema.extrautils2.villagers.XUVillagerCareer;
import com.rwtema.extrautils2.worldgen.SingleChunkGen;
import com.rwtema.extrautils2.worldgen.SingleChunkWorldGenManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class XU2Entries {
    public static final IItemStackMaker magical_wood = BlockDecorativeSolidWood.DecorStates.magical_wood;
    public static final IItemStackMaker redstoneCrystal = ItemIngredients.Type.REDSTONE_CRYSTAL;
    public static final IItemStackMaker stoneburnt = BlockDecorativeSolid.DecorStates.stoneburnt;
    public static ItemEntry<ItemWateringCan> wateringCan = new ItemClassEntry<ItemWateringCan>(ItemWateringCan.class){

        @Override
        public void addRecipes() {
            this.addShaped(this.newStackLowestDamage(), "S  ", "SBS", " S ", Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('B'), Items.field_151054_z);
        }
    };
    public static ItemEntry<ItemDestructionWand> creativeDestructionWand = new ItemEntry<ItemDestructionWand>("ItemCreativeDestructionWand"){

        @Override
        public ItemDestructionWand initValue() {
            return new ItemDestructionWand(this.name.toLowerCase().substring(4), this.name, new float[]{0.99215686f, 0.5921569f, 0.15294118f}, 49);
        }
    };
    public static ItemEntry<ItemBuildersWand> buildersWand = new ItemEntry<ItemBuildersWand>("ItemBuildersWand"){

        @Override
        public ItemBuildersWand initValue() {
            return new ItemBuildersWand(this.name, 9, this.name.toLowerCase().substring(4), new float[]{0.95686275f, 0.9019608f, 0.30588236f});
        }

        @Override
        public void addRecipes() {
            CraftingHelper.addShaped(this.newStack(), "  G", " W ", "W  ", Character.valueOf('W'), magical_wood, Character.valueOf('G'), "ingotGold");
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Builders Wand", "Places blocks on blocks", this, magical_wood);
        }
    };
    public static ItemEntry<ItemDestructionWand> destructionWand = new ItemEntry<ItemDestructionWand>("ItemDestructionWand"){

        @Override
        public ItemDestructionWand initValue() {
            return new ItemDestructionWand(this.name.toLowerCase().substring(4), this.name, new float[]{0.95686275f, 0.9019608f, 0.30588236f}, 9);
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Destruction Wand", "Breaks blocks", this, buildersWand);
        }

        @Override
        public void addRecipes() {
            CraftingHelper.addShaped(this.newStack(), " GG", " WG", "W  ", Character.valueOf('W'), magical_wood, Character.valueOf('G'), "ingotGold");
        }
    };
    public static ItemEntry<ItemBuildersWand> creativeBuildersWand = new ItemEntry<ItemBuildersWand>("ItemCreativeBuildersWand"){

        @Override
        public ItemBuildersWand initValue() {
            return new ItemBuildersWand(this.name, 49, "creativebuilderswand", new float[]{0.99215686f, 0.5921569f, 0.15294118f});
        }
    };
    public static BlockClassEntry<BlockSoundMuffler> soundMuffler = new BlockClassEntry<BlockSoundMuffler>(BlockSoundMuffler.class, new Class[]{TileSoundMuffler.class}){

        @Override
        public void addRecipes() {
            this.addShapeless((Block)this.value, Blocks.field_150325_L, Blocks.field_150323_B);
        }
    };
    public static BlockEntry<BlockEnderLilly> blockEnderLilly = new BlockClassEntry<BlockEnderLilly>(BlockEnderLilly.class, new Class[0]){
        final IBlockState target = Blocks.field_150377_bs.func_176223_P();

        @Override
        public void postInit() {
            RareSeedHandler.register(this.newStack(1), 0.0078125);
            SingleChunkWorldGenManager.register(new SingleChunkGen("EnderLillies", 0){

                @Override
                public void genChunk(Chunk chunk, IChunkGenerator provider, Random random) {
                    int dz;
                    if (!(provider instanceof ChunkProviderEnd)) {
                        return;
                    }
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                    int dx = random.nextInt(16);
                    int dy = chunk.func_76611_b(dx, dz = random.nextInt(16)) - 1;
                    if (dy <= 0) {
                        return;
                    }
                    pos.func_181079_c(dx, dy, dz);
                    IBlockState blockState = chunk.func_177435_g((BlockPos)pos);
                    if (blockState == target) {
                        pos.func_181079_c(dx, dy + 1, dz);
                        if (this.isAir(chunk, (BlockPos)pos)) {
                            this.setBlockState(chunk, (BlockPos)pos, ((BlockEnderLilly)((Object)value)).FULLY_GROWN_STATE);
                        }
                    }
                }
            });
        }
    }.setItemClass(ItemBlockPlantable.class);
    public static BlockEntry<BlockDecorativeSolidWood> decorativeSolidWood = new BlockClassEntry<BlockDecorativeSolidWood>(BlockDecorativeSolidWood.class, new Class[0]){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Magical Wood", "*snicker*", magical_wood, null);
        }

        @Override
        public void addRecipes() {
            for (BlockDecorativeSolidWood.DecorStates decorState : BlockDecorativeSolidWood.DecorStates.values()) {
                decorState.addRecipes();
            }
        }
    };
    public static BlockEntry<BlockTrashCan> trashCan = new BlockClassEntry<BlockTrashCan>(BlockTrashCan.class, new Class[]{TileTrashCan.class}){

        @Override
        public void addRecipes() {
            this.addShaped((Block)this.value, "SSS", "CcC", "CCC", Character.valueOf('S'), "stone", Character.valueOf('C'), "cobblestone", Character.valueOf('c'), Blocks.field_150486_ae);
        }
    };
    public static BlockEntry<BlockAngelBlock> angelBlock = new BlockEntry<BlockAngelBlock>("AngelBlock", new Class[0]){

        @Override
        public BlockAngelBlock initValue() {
            return new BlockAngelBlock();
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(1), " G ", "WOW", Character.valueOf('G'), "ingotGold", Character.valueOf('W'), Items.field_151008_G, Character.valueOf('O'), Blocks.field_150343_Z);
        }
    }.setItemClass(ItemAngelBlock.class);
    public static BlockEntry<BlockPassiveGenerator> passiveGenerator = new BlockClassEntry<BlockPassiveGenerator>(BlockPassiveGenerator.class, new Class[]{TilePassiveGenerator.class, TilePowerHandCrank.class}){

        @Override
        public void addRecipes() {
            for (BlockPassiveGenerator.GeneratorTypes generatorTypes : BlockPassiveGenerator.GeneratorTypes.values()) {
                generatorTypes.addRecipe();
            }
        }

        @Override
        public void addAchievements() {
            for (BlockPassiveGenerator.GeneratorTypes generatorTypes : BlockPassiveGenerator.GeneratorTypes.values()) {
                generatorTypes.registerAchievements();
            }
        }
    };
    public static BlockClassEntry<BlockCursedEarth> cursedEarth = new BlockClassEntry<BlockCursedEarth>(BlockCursedEarth.class, new Class[0]);
    public static BlockClassEntry<BlockRedstoneClock> redstoneClock = new BlockClassEntry<BlockRedstoneClock>(BlockRedstoneClock.class, new Class[0]){

        @Override
        public void addRecipes() {
            this.addShaped((Block)this.value, "SRS", "RTR", "SRS", Character.valueOf('S'), "stone", Character.valueOf('T'), Blocks.field_150429_aA, Character.valueOf('R'), Items.field_151137_ax);
        }
    };
    public static BlockCompressedEntry compressedCobblestone = new BlockCompressedEntry(Blocks.field_150347_e, "cobblestone", 8);
    public static BlockCompressedEntry compressedDirt = new BlockCompressedEntry(Blocks.field_150346_d, "dirt", 4);
    public static BlockCompressedEntry compressedSand = new BlockCompressedEntry((Block)Blocks.field_150354_m, "sand", 2);
    public static BlockCompressedEntry compressedGravel = new BlockCompressedEntry(Blocks.field_150351_n, "gravel", 2);
    public static BlockCompressedEntry compressedNetherack = new BlockCompressedEntry(Blocks.field_150424_aL, "netherrack", 6);
    public static ItemClassEntry<ItemFakeCopy> itemFakeCopy = new ItemClassEntry<ItemFakeCopy>(ItemFakeCopy.class);
    public static ItemClassEntry<ItemGlassCutter> itemGlassCutter = new ItemClassEntry<ItemGlassCutter>(ItemGlassCutter.class){

        @Override
        public void addRecipes() {
            this.addShaped((Item)this.value, "  i", " si", "i  ", Character.valueOf('s'), "stickWood", Character.valueOf('i'), "ingotIron");
        }
    };
    public static ItemEnderShardEntry itemEnderShard = new ItemEnderShardEntry();
    public static BlockEntry<BlockRedOrchid> blockRedOrchid = new BlockClassEntry<BlockRedOrchid>(BlockRedOrchid.class, new Class[0]){

        @Override
        public void postInit() {
            SingleChunkWorldGenManager.register(new SingleChunkGen("RedOrchid", 0){

                @Override
                public void genChunk(Chunk chunk, IChunkGenerator provider, Random random) {
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                    block0: for (int i = 0; i < 256; ++i) {
                        int dx = random.nextInt(16);
                        int dz = random.nextInt(16);
                        int dy = 1 + random.nextInt(32);
                        pos.func_181079_c(dx, dy, dz);
                        Block block = chunk.func_177435_g((BlockPos)pos).func_177230_c();
                        if (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay) continue;
                        for (int j = 1; j < 3; ++j) {
                            pos.func_181079_c(dx, dy + j, dz);
                            block = chunk.func_177435_g((BlockPos)pos).func_177230_c();
                            if (block == Blocks.field_150350_a) {
                                this.report(chunk, dx, dy, dz);
                                this.setBlockState(chunk, (BlockPos)pos, ((BlockRedOrchid)((Object)value)).FULLY_GROWN_STATE);
                                continue block0;
                            }
                            if (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay) continue block0;
                        }
                    }
                }
            });
            RareSeedHandler.register(this.newStack(1), 0.015625);
        }
    }.setItemClass(ItemBlockPlantable.class);
    public static VoidEntry additionalVanillaRecipes = new VoidEntry("additionalVanillaRecipes"){

        @Override
        public void addRecipes() {
            CraftingHelper.addRecipe((IRecipe)new AlwaysLast.XUShapedRecipeAlwaysLast(new ItemStack((Block)Blocks.field_150486_ae, 4), "WWW", "W W", "WWW", Character.valueOf('W'), "logWood"));
            CraftingHelper.addRecipe((IRecipe)new AlwaysLast.XUShapedRecipeAlwaysLast(new ItemStack(Items.field_151055_y, 16), "W", "W", Character.valueOf('W'), "logWood"));
        }
    };
    public static ItemClassEntry<ItemLawSword> lawSword = new ItemClassEntry<ItemLawSword>(ItemLawSword.class){};
    public static ItemEntrySickle[] sickles = new ItemEntrySickle[]{new ItemEntrySickle(0), new ItemEntrySickle(1), new ItemEntrySickle(2), new ItemEntrySickle(3), new ItemEntrySickle(4)};
    public static BlockClassEntry<BlockPowerOverload> overload = new BlockClassEntry<BlockPowerOverload>(BlockPowerOverload.class, TilePowerOverload.class);
    public static BlockClassEntry<BlockResonator> resonator = new BlockClassEntry<BlockResonator>(BlockResonator.class, new Class[]{TileResonator.class}){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Power Resonator", "Imbue energy to objects", this, BlockPassiveGenerator.GeneratorTypes.Solar);
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(1), "RCR", "IcI", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), "blockCoal", Character.valueOf('c'), redstoneCrystal);
        }
    };
    public static ItemEntry<ItemSunCrystal> sunCrystal = new ItemClassEntry<ItemSunCrystal>(ItemSunCrystal.class){
        IItemStackMaker EMPTY_GEM = new IItemStackMaker(){

            @Override
            public ItemStack newStack() {
                return this.newStackLowestDamage();
            }
        };

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Luminescent Potential", "Collect the suns rays", this.EMPTY_GEM, resonator);
            AchievementHelper.addAchievement("Sun Crystal", "Light through walls", this, this.EMPTY_GEM);
        }

        @Override
        public void addRecipes() {
            this.addShapeless(this.newStackLowestDamage(), "gemDiamond", "dustGlowstone", "dustGlowstone", "dustGlowstone", "dustGlowstone");
        }
    };
    public static BlockEntry<BlockSpotlight> blockSpotlight = new BlockClassEntry<BlockSpotlight>(BlockSpotlight.class, new Class[]{TileSpotlight.class}){

        @Override
        public void addAchievements() {
        }

        @Override
        public void addRecipes() {
        }
    };
    public static BlockClassEntry<BlockScreen> blockScreen = new BlockClassEntry<BlockScreen>(BlockScreen.class, new Class[]{TileScreen.class}){

        @Override
        public void loadAdditionalConfig(Configuration config) {
            BlockScreen.maxSize = 262144;
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Screen", "For you viewing pleasure", this, stoneburnt);
        }

        @Override
        public void addRecipes() {
            CraftingHelper.addShaped(this.newStack(1), true, "BBB", "ERE", Character.valueOf('G'), sunCrystal.newStack(), Character.valueOf('R'), redstoneCrystal, Character.valueOf('B'), stoneburnt, Character.valueOf('E'), itemEnderShard.newStack());
        }
    };
    public static BlockEntry<BlockDecorativeSolid> decorativeSolid = new BlockClassEntry<BlockDecorativeSolid>(BlockDecorativeSolid.class, new Class[0]){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Powered Stone", "Stone that conducts intense amounts of energy", stoneburnt, resonator);
        }

        @Override
        public void addRecipes() {
            for (BlockDecorativeSolid.DecorStates decorState : BlockDecorativeSolid.DecorStates.values()) {
                decorState.addRecipes();
            }
        }

        @Override
        public void postInit() {
        }
    };
    public static ItemClassEntry<ItemIngredients> itemIngredients = new ItemClassEntry<ItemIngredients>(ItemIngredients.class){

        @Override
        public void registerOres() {
            for (ItemIngredients.Type type : ItemIngredients.Type.values()) {
                if (type.oreName == null) continue;
                OreDictionary.registerOre((String)type.oreName, (ItemStack)type.newStack());
            }
        }

        @Override
        public void addAchievements() {
            for (ItemIngredients.Type type : ItemIngredients.Type.values()) {
                type.addAchievement();
            }
        }

        @Override
        public void addRecipes() {
            for (ItemIngredients.Type type : ItemIngredients.Type.values()) {
                type.addRecipes();
            }
        }
    };
    public static ItemClassEntry<ItemGoldenLasso> goldenLasso = new ItemClassEntry<ItemGoldenLasso>(ItemGoldenLasso.class){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Golden Lasso", "Animal Transport", this.getOreDicMaker(), magical_wood);
            AchievementHelper.addAchievement("Cursed Lasso", "Evil Monster Capture", this.getMetaMaker(1), this.getOreDicMaker());
        }

        @Override
        public void addRecipes() {
            CraftingHelper.addRecipe(new EnchantRecipe((IRecipe)new XUShapedRecipe(this.newStack(1, 0), "gsg", "s s", "gsg", Character.valueOf('s'), Items.field_151007_F, Character.valueOf('g'), "nuggetGold", Character.valueOf('e'), Items.field_151079_bi), 8));
            this.addShapeless(this.newStack(1, 1), this.newStack(1, 0), itemIngredients.isActive() ? ItemIngredients.Type.EVIL_DROP.newStack() : new ItemStack(Items.field_151144_bL, 1, 1));
        }
    };
    public static ItemEntry<ItemAngelRing> angelRing = new ItemClassEntry<ItemAngelRing>(ItemAngelRing.class){

        @Override
        public void addRecipes() {
            Object[] leftWing = new Object[]{"blockGlass", Items.field_151008_G, "dyePurple", Items.field_151116_aA, "nuggetGold", new ItemStack(Items.field_151044_h, 1, 0)};
            Object[] rightWing = new Object[]{"blockGlass", Items.field_151008_G, "dyePink", Items.field_151116_aA, "nuggetGold", new ItemStack(Items.field_151044_h, 1, 1)};
            for (int i = 0; i < leftWing.length; ++i) {
                this.addShaped(this.newStack(1, i), !Objects.equal((Object)leftWing[i], (Object)rightWing[i]), "LGR", "GrG", "BGH", Character.valueOf('L'), leftWing[i], Character.valueOf('R'), rightWing[i], Character.valueOf('B'), ItemGoldenLasso.newCraftingStack(EntityBat.class), Character.valueOf('G'), "ingotGold", Character.valueOf('r'), redstoneCrystal, Character.valueOf('H'), ItemGoldenLasso.newCraftingStack(EntityGhast.class));
                this.addShapeless(this.newStack(1, i), leftWing[i], this.newWildcardStack(), rightWing[i]);
            }
        }
    };
    public static ItemClassEntry<ItemPowerManager> powerManager = new ItemClassEntry<ItemPowerManager>(ItemPowerManager.class){

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(1), " c", "ss", "ss", Character.valueOf('s'), "stone", Character.valueOf('c'), redstoneCrystal);
        }
    };
    public static ItemClassEntry<ItemBagOfHolding> bagOfHolding = new ItemClassEntry<ItemBagOfHolding>(ItemBagOfHolding.class){

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(), "ggg", "cBc", "ggg", Character.valueOf('g'), "ingotGold", Character.valueOf('c'), Blocks.field_150486_ae, Character.valueOf('B'), magical_wood);
        }
    };
    public static BlockClassEntry<BlockDecorativeGlass> decorativeGlass = new BlockClassEntry<BlockDecorativeGlass>(BlockDecorativeGlass.class, new Class[0]){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Powered Glass", "Glass that gives off energy", BlockDecorativeGlass.DecorStates.glass_redstone, resonator);
        }

        @Override
        public void addRecipes() {
            for (BlockDecorativeGlass.DecorStates decorState : BlockDecorativeGlass.DecorStates.values()) {
                decorState.addRecipes();
            }
        }
    };
    public static VoidEntry proddingStick = new VoidEntry("WoodenStickPoke"){

        @Override
        public void postInit() {
            ProddingStickHandler.register();
        }
    };
    public static BlockClassEntry<BlockMoonStone> moonStone = (BlockClassEntry)new BlockClassEntry<BlockMoonStone>(BlockMoonStone.class, new Class[0]){

        @Override
        public void postInit() {
            SingleChunkWorldGenManager.register(new SingleChunkGen("MoonStone", 0){
                public IBlockState defaultState;
                {
                    super(name, version);
                    this.defaultState = ((BlockMoonStone)((Object)value)).func_176223_P();
                }

                @Override
                public void genChunk(Chunk chunk, IChunkGenerator provider, Random random) {
                    for (int i = 0; i < 4; ++i) {
                        int dz;
                        int dy;
                        int dx = 1 + random.nextInt(14);
                        BlockPos pos = new BlockPos(dx, dy = 1 + random.nextInt(64), dz = 1 + random.nextInt(14));
                        if (chunk.func_177435_g(pos) != BlockMoonStone.mimicState) continue;
                        for (EnumFacing facing : EnumFacing.values()) {
                            if (!this.isAir(chunk, pos, facing)) continue;
                            this.setBlockState(chunk, pos, this.defaultState);
                            return;
                        }
                    }
                }
            });
        }
    }.setItemClass(null);
    public static MultiBlockEntry<BlockTransferPipe> pipe = new MultiBlockEntry<BlockTransferPipe>(BlockTransferPipe.stateBuilder, "pipe"){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Pipes!", "Point to Point Transport", this, resonator);
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(64), "SSS", "GRG", "SSS", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('G'), "blockGlass", Character.valueOf('R'), "dustRedstone");
        }
    }.setItemBlockClass(ItemBlockPipe.class);
    public static BlockEntry<BlockTransferHolder> holder = new BlockClassEntry<BlockTransferHolder>(BlockTransferHolder.class, new Class[]{TileTransferHolder.class}){

        @Override
        public String getConfigLabel() {
            return pipe.getConfigLabel();
        }
    }.setItemClass(null);
    public static BlockClassEntry<BlockPlayerChest> playerChest = new BlockClassEntry<BlockPlayerChest>(BlockPlayerChest.class, new Class[]{TilePlayerChest.class}){

        @Override
        public void addRecipes() {
            this.addShaped((Block)this.value, "SSS", "SCS", "ScS", Character.valueOf('S'), stoneburnt, Character.valueOf('C'), Blocks.field_150477_bB, Character.valueOf('c'), redstoneCrystal);
        }
    };
    public static ItemClassEntry<ItemWrench> wrench = new ItemClassEntry<ItemWrench>(ItemWrench.class){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Wrench", "Wrench it!", this, null);
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(1), " RS", " Sr", "S  ", Character.valueOf('S'), "ingotIron", Character.valueOf('R'), "dyeRed", Character.valueOf('r'), "dustRedstone");
        }
    };
    public static ItemClassEntry<ItemBoomerang> boomerang = new ItemClassEntry<ItemBoomerang>(ItemBoomerang.class){

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Boomerang", "It returns", this, magical_wood);
        }

        @Override
        public void init() {
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(1), " W ", "W W", Character.valueOf('W'), magical_wood);
            CraftingHelper.addRecipe(new AdvShapelessRecipeBase(this.newStack()){
                final String boomerang;
                final String potion;
                {
                    super(output);
                    this.boomerang = this.addMatcher("boomerang", this.newStack());
                    this.potion = this.addMatcher("lingering_potion", new IMatcher(){

                        @Override
                        public boolean matchesItemStack(@Nullable ItemStack t) {
                            return t != null && t.func_77973_b() == Items.field_185156_bI && !PotionUtils.func_185189_a((ItemStack)t).isEmpty();
                        }
                    }, new ItemStack((Item)Items.field_185156_bI));
                }

                @Override
                protected ItemStack getResult(HashMap<String, ItemStack> map) {
                    ItemStack boomerang_stack = map.get(this.boomerang);
                    ItemStack newStack = boomerang_stack.func_77946_l();
                    ItemStack potion = map.get(this.potion);
                    PotionUtils.func_185188_a((ItemStack)newStack, (PotionType)PotionUtils.func_185191_c((ItemStack)potion));
                    PotionUtils.func_185184_a((ItemStack)newStack, (Collection)PotionUtils.func_185190_b((ItemStack)potion));
                    return newStack;
                }
            });
        }

        @Override
        public void postInit() {
            BlockDispenser.field_149943_a.func_82595_a(this.value, (Object)new BehaviorDefaultDispenseItem(){

                @Nonnull
                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    EntityBoomerang t;
                    World world = source.func_82618_k();
                    TileEntity tile = source.func_150835_j();
                    if (tile == null) {
                        return stack;
                    }
                    WeakReference<EntityBoomerang> reference = EntityBoomerang.getBoomerangOwners(world).get(tile);
                    if (reference != null && (t = (EntityBoomerang)((Object)reference.get())) != null && !t.field_70128_L) {
                        return stack;
                    }
                    IPosition position = BlockDispenser.func_149939_a((IBlockSource)source);
                    IBlockState iBlockState = source.func_189992_e();
                    EnumFacing direction = (EnumFacing)iBlockState.func_177229_b((IProperty)BlockDispenser.field_176441_a);
                    EntityBoomerang boomerang = new EntityBoomerang(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), stack, tile);
                    boomerang.func_70186_c(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e(), 0.75f, 4.0f);
                    world.func_72838_d((Entity)boomerang);
                    return stack;
                }

                protected void func_82485_a(IBlockSource source) {
                    source.func_82618_k().func_175669_a(1002, source.func_180699_d(), 0);
                }
            });
        }
    };
    public static ItemClassEntry<ItemBook> book = new ItemClassEntry<ItemBook>(ItemBook.class){

        @Override
        public void addRecipes() {
            CraftingHelper.addShapeless(this.newStack(1), ImmutableList.of((Object)Items.field_151122_aG, (Object)Items.field_151099_bA, (Object)Items.field_151164_bB), "ingotGold", Blocks.field_150343_Z);
        }
    };
    public static VoidEntry throwEnderPearlsInCreative = new VoidEntry("throwEnderPearlsInCreative"){

        @Override
        public void postInit() {
            CreativeEPHandler.init();
        }
    };
    public static ItemClassEntry<ItemContract> contract = new ItemClassEntry<ItemContract>(ItemContract.class){

        @Override
        public void addRecipes() {
            CraftingHelper.addShapeless(this.newStack(1), Items.field_151008_G, Items.field_151121_aF, Items.field_151069_bo, "dyeBlack");
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Villager Contract", "Head of Villager Soul Resources", this, goldenLasso.getOreDicMaker());
        }
    };
    public static BlockClassEntry<BlockWardChunkLoader> ward_chunkloader = new BlockClassEntry<BlockWardChunkLoader>("ChunkLoader", BlockWardChunkLoader.class, new Class[]{TileChunkLoader.class}){

        @Override
        public void addRecipes() {
            CraftingHelper.addShaped(this.newStack(1), "SES", "SLS", " S ", Character.valueOf('S'), "stickWood", Character.valueOf('E'), ItemIngredients.Type.EYE_REDSTONE.newStack(1), Character.valueOf('L'), ItemGoldenLasso.newCraftingVillagerStack(true, null));
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Chunk Loader", "Persistence", this, contract);
        }
    };
    public static ItemClassEntry<ItemFilterItems> filterItems = new ItemClassEntry<ItemFilterItems>("Filter", ItemFilterItems.class){

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(), "rsr", "sSs", "rsr", Character.valueOf('r'), "dustRedstone", Character.valueOf('s'), "stickWood", Character.valueOf('S'), "string");
        }
    };
    public static ItemClassEntry<ItemFilterFluids> filterFluids = new ItemClassEntry<ItemFilterFluids>(ItemFilterFluids.class){

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(), "rsr", "sSs", "rsr", Character.valueOf('r'), "gemLapis", Character.valueOf('s'), "stickWood", Character.valueOf('S'), "string");
        }
    };
    public static ItemClassEntry<ItemGrocket> grocket = new ItemClassEntry<ItemGrocket>(ItemGrocket.class){

        @Override
        public void addRecipes() {
            CraftingHelper.addShaped(this.newStack(4, GrocketType.TRANSFER_NODE_ITEMS.ordinal()), "RPR", "SCS", Character.valueOf('P'), pipe, Character.valueOf('R'), "dustRedstone", Character.valueOf('S'), "stone", Character.valueOf('C'), ImmutableList.of((Object)Blocks.field_150486_ae, (Object)Blocks.field_150447_bR));
            CraftingHelper.addShaped(this.newStack(4, GrocketType.FILTER_ITEMS.ordinal()), "RFR", "SPS", Character.valueOf('P'), pipe, Character.valueOf('F'), filterItems, Character.valueOf('R'), "dustRedstone", Character.valueOf('S'), "stone");
            CraftingHelper.addShaped(this.newStack(4, GrocketType.TRANSFER_NODE_FLUIDS.ordinal()), "RPR", "SCS", Character.valueOf('P'), pipe, Character.valueOf('R'), "dustRedstone", Character.valueOf('S'), "stone", Character.valueOf('C'), Items.field_151133_ar);
            CraftingHelper.addShaped(this.newStack(2, GrocketType.TRANSFER_NODE_ITEMS_RETRIEVE.ordinal()), " E ", "NSN", " E ", Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('N'), this.newStack(1, GrocketType.TRANSFER_NODE_ITEMS.ordinal()), Character.valueOf('S'), "gemEmerald");
            CraftingHelper.addShaped(this.newStack(2, GrocketType.TRANSFER_NODE_FLUIDS_RETRIEVE.ordinal()), " E ", "NSN", " E ", Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('N'), this.newStack(1, GrocketType.TRANSFER_NODE_FLUIDS.ordinal()), Character.valueOf('S'), "gemDiamond");
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Transfer Nodes", "Simple Item Management", (IItemStackMaker)this.metaCache.getUnchecked((Object)0), pipe);
        }

        @Override
        public String getConfigLabel() {
            return pipe.getConfigLabel();
        }
    };
    public static BlockClassEntry<BlockIndexer> indexer = new BlockClassEntry<BlockIndexer>(BlockIndexer.class, new Class[]{TileIndexer.class}){

        @Override
        public void addRecipes() {
            this.addShaped((Block)this.value, "SCS", "SsS", "SCS", Character.valueOf('S'), stoneburnt, Character.valueOf('C'), redstoneCrystal, Character.valueOf('s'), blockScreen);
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Indexer", "Item Retrieval", this, grocket.getMetaMaker(0));
        }
    };
    public static ItemClassEntry<ItemIndexerRemote> indexerRemote = new ItemClassEntry<ItemIndexerRemote>(ItemIndexerRemote.class){

        @Override
        public void addRecipes() {
            this.addShaped((Item)this.value, "SCS", "SsS", "SCS", Character.valueOf('S'), "stone", Character.valueOf('C'), ItemIngredients.Type.EYE_REDSTONE, Character.valueOf('s'), blockScreen.newStack());
        }

        @Override
        public void addAchievements() {
            AchievementHelper.addAchievement("Remote Indexing", "Item Retrieval at distance", this, indexer);
        }
    };
    public static PotionEntry<PotionGravity> potionGravity = new PotionEntry<PotionGravity>("potion_gravity", "Pulls fliers down to the ground."){

        @Override
        public PotionGravity initValue() {
            return new PotionGravity();
        }

        @Override
        public void registerTypesAndRecipes() {
            PotionType antiFlying = PotionsHelper.registerPotionType(new PotionEffect((Potion)this.value, 1200));
            BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionsHelper.getAwkwardPotionType()), (String)"obsidian", (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)antiFlying));
        }
    };
    public static PotionEntry<PotionSecondChance> potionAntiDeath = new PotionEntry<PotionSecondChance>("potion_second_chance", "Will save from death but only once."){

        @Override
        public PotionSecondChance initValue() {
            return new PotionSecondChance();
        }

        @Override
        public void registerTypesAndRecipes() {
            PotionType antiDeath = PotionsHelper.registerPotionType(new PotionEffect((Potion)this.value, 2400));
            BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionsHelper.getVanillaType("strong_healing")), (ItemStack)new ItemStack(Items.field_151153_ao, 1, 1), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)antiDeath));
        }
    };
    public static PotionEntry<PotionNapalm> potionGreekFire = new PotionEntry<PotionNapalm>("potion_greek_fire", "Creates a fire that cannot be extenguished"){

        @Override
        public void registerTypesAndRecipes() {
            PotionType greekFire = PotionsHelper.registerPotionType(new PotionEffect((Potion)this.value, 2400));
            PotionType oily = PotionsHelper.newGenericPotion("Oily");
            BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionsHelper.getAwkwardPotionType()), (ItemStack)new ItemStack(Items.field_185164_cV), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)oily));
            BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)oily), (ItemStack)new ItemStack(Items.field_151129_at), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)greekFire));
        }

        @Override
        public PotionNapalm initValue() {
            return new PotionNapalm();
        }
    };
    public static PotionEntry<PotionFizzyLifting> potionFizzy = new PotionEntry<PotionFizzyLifting>("potion_fizzy_lifting", null){

        @Override
        public void registerTypesAndRecipes() {
            PotionType greekFire = PotionsHelper.registerPotionType(new PotionEffect((Potion)this.value, 600));
            BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185238_j), (ItemStack)new ItemStack(Items.field_151102_aT), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)greekFire));
        }

        @Override
        public PotionFizzyLifting initValue() {
            return new PotionFizzyLifting();
        }
    };
    public static PotionEntry<PotionRelapse> potionRelapse = new PotionEntry<PotionRelapse>("potion_relapse", "Negative potion effects resist being cured."){

        @Override
        public void registerTypesAndRecipes() {
            PotionType relapse = PotionsHelper.registerPotionType(new PotionEffect((Potion)this.value, 9600));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingOreRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionsHelper.getAwkwardPotionType()), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a()), new ItemStack((Block)BlockFlower.EnumFlowerType.POPPY.func_176964_a().func_180346_a(), 1, BlockFlower.EnumFlowerType.POPPY.func_176968_b()), new ItemStack((Block)BlockFlower.EnumFlowerType.RED_TULIP.func_176964_a().func_180346_a(), 1, BlockFlower.EnumFlowerType.RED_TULIP.func_176968_b())}), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)relapse)));
        }

        @Override
        public PotionRelapse initValue() {
            return new PotionRelapse();
        }
    };
    public static PotionEntry<PotionLove> potionLove = new PotionEntry<PotionLove>("potion_love", null){

        @Override
        public PotionLove initValue() {
            return new PotionLove();
        }

        @Override
        public void registerTypesAndRecipes() {
            PotionType love = PotionsHelper.registerPotionType(new PotionEffect((Potion)this.value, 200));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingOreRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionsHelper.getAwkwardPotionType()), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a()), new ItemStack((Block)BlockFlower.EnumFlowerType.POPPY.func_176964_a().func_180346_a(), 1, BlockFlower.EnumFlowerType.POPPY.func_176968_b()), new ItemStack((Block)BlockFlower.EnumFlowerType.RED_TULIP.func_176964_a().func_180346_a(), 1, BlockFlower.EnumFlowerType.RED_TULIP.func_176968_b())}), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)love)));
        }
    };
    public static VillagerEntrySimple alchemist = new VillagerEntrySimple("alchemist"){

        @Override
        public List<XUVillagerCareer> getCareers() {
            return Lists.newArrayList((Object[])new XUVillagerCareer[]{this.newCareer("alchemist").addAdditionalTrade(0, new EmeraldForPotions(false)).addAdditionalTrade(0, new EmeraldForPotions(false)).addAdditionalTrade(0, new EmeraldForPotions(true)).addAdditionalTrade(1, new EmeraldForPotions(false)).addAdditionalTrade(1, new EmeraldForPotions(false)).addAdditionalTrade(1, new EmeraldForPotions(true))});
        }
    };
    public static VillagerEntrySimple red_mechanic = new VillagerEntrySimple("red_mechanic"){

        @Override
        public List<XUVillagerCareer> getCareers() {
            return Lists.newArrayList((Object[])new XUVillagerCareer[]{this.newCareer("red_mechanic").addRandomTrade(0, new EntityVillager.ITradeList[]{new EntityVillager.ListItemForEmeralds(redstoneCrystal.newStack(), new EntityVillager.PriceInfo(-4, -8)), new EntityVillager.ListItemForEmeralds(wrench.newStack(), new EntityVillager.PriceInfo(1, 1))})});
        }
    };
    public static VillagerEntrySimple shadyMerchant = new VillagerEntrySimple("shady_merchant"){

        @Override
        public List<XUVillagerCareer> getCareers() {
            MinecraftForge.EVENT_BUS.register((Object)new EntityAINinjaPoof.Handler());
            return Lists.newArrayList((Object[])new XUVillagerCareer[]{this.newCareer("shady_merchant").addRandomTrade(0, new GenericTrade(GenericTrade.EMERALDS, 1, itemFakeCopy.newStackMeta(1)).setMaxTrades(1)).addRandomTrade(0, new GenericTrade(GenericTrade.EMERALDS, 1, 3, itemFakeCopy.newStackMeta(2)).setMaxTrades(1)).addRandomTrade(0, new GenericTrade(GenericTrade.EMERALDS, 5, 8, itemFakeCopy.newStackMeta(3)).setMaxTrades(1)).addRandomTrade(0, new GenericTrade(GenericTrade.EMERALDS, 1, 1, itemFakeCopy.newStackMeta(4)).setMaxTrades(1)).addRandomTrade(0, new GenericTrade(GenericTrade.EMERALDS, 4, 16, itemFakeCopy.newStackMeta(5)).setMaxTrades(1)).addRandomTrade(0, new GenericTrade(GenericTrade.EMERALDS, 8, itemFakeCopy.newStackMeta(6)).setMaxTrades(1)).addRandomTrade(0, new GenericTrade(GenericTrade.EMERALDS, 8, itemFakeCopy.newStackMeta(7)).setMaxTrades(1)).addRandomTrade(0, new GenericTrade(GenericTrade.EMERALDS, 2, 6, itemFakeCopy.newStackMeta(8)).setMaxTrades(1))});
        }
    };
    public static BlockClassEntry<BlockCrafter> blockCrafter = new BlockClassEntry<BlockCrafter>(BlockCrafter.class, new Class[]{TileCrafter.class}){

        @Override
        public void addRecipes() {
            this.addShapeless(this.newStack(), Blocks.field_150367_z, redstoneCrystal, Blocks.field_150462_ai);
        }
    };
    public static BlockClassEntry<BlockAdvInteractor.Scanner> blockScanner = new BlockClassEntry<BlockAdvInteractor.Scanner>(BlockAdvInteractor.Scanner.class, new Class[]{TileScanner.class}){

        @Override
        public void addRecipes() {
            this.addShapeless(this.newStack(), Blocks.field_150409_cd, "dustRedstone", Items.field_151070_bp);
        }
    };
    public static BlockClassEntry<BlockAdvInteractor.Mine> blockMiner = new BlockClassEntry<BlockAdvInteractor.Mine>("Miner", BlockAdvInteractor.Mine.class, new Class[]{TileMine.class}){

        @Override
        public void addRecipes() {
            this.addShapeless(this.newStack(), Blocks.field_150367_z, redstoneCrystal, Items.field_151035_b);
        }
    };
    public static BlockClassEntry<BlockAdvInteractor.Use> blockUser = new BlockClassEntry<BlockAdvInteractor.Use>("User", BlockAdvInteractor.Use.class, new Class[]{TileUse.class}){

        @Override
        public void addRecipes() {
            this.addShapeless(this.newStack(), Blocks.field_150367_z, redstoneCrystal, Blocks.field_150442_at);
        }
    };
    public static ItemClassEntry<ItemKlein> kleinFlask = new ItemClassEntry<ItemKlein>(ItemKlein.class){

        @Override
        public void addRecipes() {
            this.addShapeless(this.newStack(), Items.field_151069_bo, Items.field_151079_bi, Items.field_151079_bi);
        }
    };
    public static BlockClassEntry<BlockDrum> drum = new BlockClassEntry<BlockDrum>(BlockDrum.class, new Class[]{TileDrum.Tank16.class, TileDrum.Tank256.class, TileDrum.Tank4096.class, TileDrum.Tank65536.class, TileDrum.TankInf.class}){

        @Override
        public void addRecipes() {
            this.addShaped(this.newStackMeta(BlockDrum.Capacity.DRUM_16.ordinal()), "SsS", "SbS", "SsS", Character.valueOf('S'), "cobblestone", Character.valueOf('s'), ImmutableList.of((Object)new ItemStack((Block)Blocks.field_150333_U, 1, BlockStoneSlab.EnumType.COBBLESTONE.func_176624_a()), (Object)new ItemStack((Block)Blocks.field_150333_U, 1, BlockStoneSlab.EnumType.STONE.func_176624_a()), (Object)"slabStone"), Character.valueOf('b'), Items.field_151054_z);
            this.addShaped(this.newStackMeta(BlockDrum.Capacity.DRUM_256.ordinal()), "SsS", "SbS", "SsS", Character.valueOf('S'), "ingotIron", Character.valueOf('s'), Blocks.field_150443_bT, Character.valueOf('b'), Items.field_151066_bu);
            this.addShaped(this.newStackMeta(BlockDrum.Capacity.DRUM_4096.ordinal()), "SsS", "SbS", "SsS", Character.valueOf('S'), "gemDiamond", Character.valueOf('s'), Blocks.field_150445_bS, Character.valueOf('b'), this.newStackMeta(BlockDrum.Capacity.DRUM_256.ordinal()));
            this.addShaped(this.newStackMeta(BlockDrum.Capacity.DRUM_65536.ordinal()), "SsS", "SbS", "SsS", Character.valueOf('S'), "ingotDemonic", Character.valueOf('s'), this.newStackMeta(BlockDrum.Capacity.DRUM_4096.ordinal()), Character.valueOf('b'), kleinFlask);
        }
    };
    public static BlockClassEntry<BlockMachine> machineEntry = (BlockClassEntry)new BlockClassEntry<BlockMachine>(BlockMachine.class, new Class[]{TileMachineProvider.class, TileMachineReceiver.class}){
        HashMap<String, IItemStackMaker> cache = new HashMap();
        HashSet<String> registeredDusts = Sets.newHashSet((Object[])new String[]{"dustIron", "dustGold", "dustCopper", "dustTin", "dustLead", "dustSilver", "dustNickel", "dustPlatinum"});
        {
            RecipeBuilder.Builder.builder = GenericMachineRecipe.Builder::new;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        public void onOreRegister(OreDictionary.OreRegisterEvent event) {
            String name = event.getName();
            if (name.startsWith("ingot") || name.startsWith("ore") || name.startsWith("dust")) {
                HashSet oreNames = Sets.newHashSet((Object[])OreDictionary.getOreNames());
                for (String dust : oreNames) {
                    if (!dust.startsWith("dust") || this.registeredDusts.contains(dust)) continue;
                    String ore = dust.replaceFirst("dust", "ore");
                    String ingot = dust.replaceFirst("dust", "ingot");
                    if (!oreNames.contains(ore) || !oreNames.contains(ingot)) continue;
                    this.addCrusherOreRecipe(ore, dust, 2);
                    this.addCrusherOreRecipe(ingot, dust, 2);
                    this.registeredDusts.contains(dust);
                }
            }
        }

        public IItemStackMaker createMaker(String machine) {
            Machine machine1 = MachineRegistry.getMachine(machine);
            return this.createMaker(machine1);
        }

        public IItemStackMaker createMaker(Machine machine1) {
            if (machine1 == null) {
                return this;
            }
            return this.cache.computeIfAbsent(machine1.name, m -> () -> ((BlockMachine)this.value).createStack(machine1));
        }

        @Override
        public void addAchievements() {
        }

        @Override
        public void addRecipes() {
            this.addShaped(this.newStack(4), "IRI", "RCR", "IRI", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), ImmutableList.of((Object)Blocks.field_150486_ae, (Object)Blocks.field_150447_bR), Character.valueOf('c'), redstoneCrystal);
            this.addShaped(((BlockMachine)this.value).createStack(Furnace.INSTANCE), "bbb", "bCb", "bbb", Character.valueOf('b'), "ingotBrick", Character.valueOf('C'), this.newStack());
            this.addShaped(((BlockMachine)this.value).createStack(Crusher.INSTANCE), "ipi", "iCi", "ipi", Character.valueOf('p'), ImmutableList.of((Object)Blocks.field_150331_J, (Object)Blocks.field_150320_F), Character.valueOf('i'), "ingotIron", Character.valueOf('C'), this.newStack());
            this.addShaped(((BlockMachine)this.value).createStack(Generator.INSTANCE), "iii", "iCi", "rpr", Character.valueOf('p'), Blocks.field_150460_al, Character.valueOf('i'), "ingotIron", Character.valueOf('r'), "dustRedstone", Character.valueOf('C'), this.newStack());
            Furnace.INSTANCE.recipes_registry.addRecipe(new SingleInputStackToStackRecipe(Furnace.INPUT, Furnace.OUTPUT){

                @Override
                @Nonnull
                public Collection<ItemStack> getInputValues() {
                    return FurnaceRecipes.func_77602_a().func_77599_b().keySet();
                }

                @Override
                public ItemStack getResult(@Nonnull ItemStack stack) {
                    return FurnaceRecipes.func_77602_a().func_151395_a(stack);
                }

                @Override
                public int getEnergyOutput(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
                    return 200;
                }

                @Override
                public int getProcessingTime(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
                    return 100;
                }
            });
            Generator.INSTANCE.recipes_registry.addRecipe(new SingleInputStackMatchRecipe(Generator.INPUT){

                @Override
                @Nonnull
                public Collection<ItemStack> getInputValues() {
                    return BurnList.getStacks();
                }

                @Override
                public List<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, FluidStack>>> getJEIInputItemExamples() {
                    ArrayList<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, FluidStack>>> list = new ArrayList<Pair<Map<MachineSlotItem, List<ItemStack>>, Map<MachineSlotFluid, FluidStack>>>();
                    Collection<ItemStack> values = this.getInputValues();
                    list.add(Pair.of((Object)ImmutableMap.of((Object)this.inputSlot, BurnList.getStacks()), (Object)ImmutableMap.of()));
                    return list;
                }

                @Override
                public boolean matches(ItemStack stack) {
                    return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
                }

                @Override
                public Map<MachineSlotItem, ItemStack> getItemOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
                    return ImmutableMap.of();
                }

                @Override
                public Map<MachineSlotFluid, FluidStack> getFluidOutputs(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
                    return ImmutableMap.of();
                }

                @Override
                public int getEnergyOutput(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
                    return TileEntityFurnace.func_145952_a((ItemStack)inputItems.get(this.inputSlot));
                }

                @Override
                public int getProcessingTime(Map<MachineSlotItem, ItemStack> inputItems, Map<MachineSlotFluid, FluidStack> inputFluids) {
                    return TileEntityFurnace.func_145952_a((ItemStack)inputItems.get(this.inputSlot)) / 40;
                }

                @Override
                @Nullable
                public ItemStack getContainer(ItemStack stack) {
                    return ForgeHooks.getContainerItem((ItemStack)stack);
                }
            });
            Crusher.addRecipe(new ItemStack(Items.field_151072_bj), new ItemStack(Items.field_151065_br, 2), new ItemStack(Items.field_151065_br, 3), 0.4f);
            Crusher.addRecipe(new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.WHITE.func_176767_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.WHITE.func_176767_b()), 0.5f);
            ImmutableList pairedOres = ImmutableList.of((Object)Pair.of((Object)"Iron", (Object)"Gold"), (Object)Pair.of((Object)"Gold", (Object)"Iron"), (Object)Pair.of((Object)"Copper", (Object)"Tin"), (Object)Pair.of((Object)"Tin", (Object)"Copper"), (Object)Pair.of((Object)"Lead", (Object)"Silver"), (Object)Pair.of((Object)"Silver", (Object)"Lead"), (Object)Pair.of((Object)"Nickel", (Object)"Platinum"), (Object)Pair.of((Object)"Platinum", (Object)"Nickel"));
            for (Pair pair : pairedOres) {
                String s = (String)pair.getLeft();
                this.addCrusherOreRecipe("ore" + s, "dust" + s, 2, "dust" + (String)pair.getRight(), 1, 0.1f);
                this.addCrusherOreRecipe("ingot" + s, "dust" + s, 1);
            }
            this.addCrusherOreRecipe("oreDiamond", "gemDiamond", 1, "gemDiamond", 1, 0.2f);
            this.addCrusherOreRecipe("oreEmerald", "gemEmerald", 1, "gemEmerald", 1, 0.2f);
            this.addCrusherOreRecipe("cobblestone", "gravel", 1, "sand", 1, 0.1f);
            this.addCrusherOreRecipe("gravel", "sand", 1);
            this.addCrusherOreRecipe("oreLapis", "gemLapis", 8);
            this.addCrusherOreRecipe("oreRedstone", "dustRedstone", 8);
            this.addCrusherOreRecipe("glowstone", "dustGlowstone", 4);
        }

        void addCrusherOreRecipe(@Nonnull Object oreInput, @Nonnull Object dustOutput, int amount) {
            this.addCrusherOreRecipe(oreInput, dustOutput, amount, null, 0, 0.0f);
        }

        void addCrusherOreRecipe(@Nonnull Object oreInput, @Nonnull Object dustOutput, int amount, @Nullable Object outputSecondary, int outputSecondaryAmount, float outputSecondaryProbability) {
            RecipeBuilder recipeBuilder = RecipeBuilder.newbuilder(Crusher.INSTANCE);
            recipeBuilder.setItemInput(Crusher.INPUT, XUShapedRecipe.getRecipeStackList(oreInput), 1);
            recipeBuilder.setItemOutput(Crusher.OUTPUT, XUShapedRecipe.getRecipeStackList(dustOutput), amount);
            if (outputSecondary != null && outputSecondaryAmount > 0) {
                recipeBuilder.setItemOutput(Crusher.OUTPUT_SECONDARY, XUShapedRecipe.getRecipeStackList(outputSecondary), outputSecondaryAmount);
                recipeBuilder.setProbability(Crusher.OUTPUT_SECONDARY, outputSecondaryProbability);
            }
            recipeBuilder.setEnergy(400);
            recipeBuilder.setProcessingTime(200);
            Crusher.INSTANCE.recipes_registry.addRecipe(recipeBuilder.build());
        }
    }.setItemClass(ItemBlockMachine.class);

    public static void init() {
    }
}

