/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.entries;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.backend.entries.Entry;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;

public class EntryHandler {
    public static List<Entry> entries = Lists.newArrayList();
    public static List<Entry> activeEntries = Lists.newArrayList();
    public static HashMap<String, Entry> entryHashMap = new HashMap();

    public static void loadConfig(Configuration config) {
        HashMap configEntries = Maps.newHashMap();
        for (Entry entry : entries) {
            entryHashMap.put(entry.name.toLowerCase(), entry);
            configEntries.put(entry.name, config.get("Enabled", entry.getConfigLabel(), true).getBoolean());
            entry.loadAdditionalConfig(config);
        }
        for (Entry entry : entries) {
            entry.enabled = (Boolean)configEntries.get(entry.name);
            if (entry.enabled) {
                Set<Entry<?>> dependencies = entry.getDependencies();
                for (Entry<?> dependency : dependencies) {
                    if (((Boolean)configEntries.get(dependency.name)).booleanValue()) continue;
                    entry.enabled = false;
                    break;
                }
            }
            if (!entry.enabled) continue;
            activeEntries.add(entry);
        }
    }

    public static void preInit() {
        for (Entry activeEntry : activeEntries) {
            activeEntry.preInitLoad();
        }
        for (Entry activeEntry : activeEntries) {
            activeEntry.preInitRegister();
        }
        for (Entry entry : entries) {
            entry.addAchievements();
        }
        for (Entry activeEntry : activeEntries) {
            activeEntry.registerOres();
        }
        for (Entry entry : activeEntries) {
            CraftingHelper.recipeCallback.set(entry.recipes);
            entry.addRecipes();
            CraftingHelper.recipeCallback.set(null);
        }
        AchievementHelper.bake();
    }

    public static void init() {
        for (Entry entry : activeEntries) {
            entry.init();
        }
    }

    public static void postInit() {
        for (Entry entry : activeEntries) {
            entry.postInit();
        }
    }
}

