/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.entries;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUItemBlock;
import com.rwtema.extrautils2.backend.entries.Entry;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.tile.tesr.ITESRHook;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;

public abstract class BlockEntry<T extends XUBlock>
extends Entry<T>
implements IItemStackMaker {
    public Class<? extends TileEntity>[] teClazzes;
    public Class<? extends ItemBlock> itemClass = XUItemBlock.class;

    public BlockEntry(String name, Class<? extends TileEntity> ... teClazzes) {
        super(name);
        this.teClazzes = teClazzes;
    }

    public static void registerTile(Class<? extends TileEntity> teClazz) {
        if (ITESRHook.class.isAssignableFrom(teClazz)) {
            ExtraUtils2.proxy.registerTESR(teClazz);
        }
        GameRegistry.registerTileEntity(teClazz, (String)("XU2:" + teClazz.getSimpleName()));
    }

    public <K extends BlockEntry<T>> K setItemClass(Class<? extends ItemBlock> clazz) {
        this.itemClass = clazz;
        return (K)this;
    }

    @Override
    public void preInitRegister() {
        ((XUBlock)((Object)this.value)).setBlockName("ExtraUtils2:" + this.name);
        GameRegistry.registerBlock((Block)((Block)this.value), this.itemClass, (String)this.name);
        for (Class<? extends TileEntity> teClazz : this.teClazzes) {
            BlockEntry.registerTile(teClazz);
        }
    }

    @Override
    public ItemStack newStack(int amount, int meta) {
        if (this.value == null || this.itemClass == null) {
            return null;
        }
        return new ItemStack((Block)this.value, amount, meta);
    }

    public ItemStack newStack(int amount, IBlockState state) {
        if (this.value == null || this.itemClass == null) {
            return null;
        }
        return this.newStack(amount, ((XUBlock)((Object)this.value)).xuBlockState.getDropMetaFromState(state));
    }

    public ItemStack newStack(int amount, Object ... properties) {
        if (this.value == null || this.itemClass == null) {
            return null;
        }
        IBlockState state = ((XUBlock)((Object)this.value)).func_176223_P();
        for (int i = 0; i < properties.length; i += 2) {
            state = state.func_177226_a((IProperty)properties[i], (Comparable)properties[i + 1]);
        }
        return this.newStack(amount, state);
    }
}

