/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class XUBlockConnectedTextureBase
extends XUBlock {
    public final ThreadLocal<BoxModel> worldModel = new ThreadLocal<BoxModel>(){

        @Override
        protected BoxModel initialValue() {
            Material material = XUBlockConnectedTextureBase.this.field_149764_J;
            BoxModel boxes = BoxModel.newStandardBlock();
            if (!material.func_76228_b()) {
                boxes.renderAsNormalBlock = false;
            }
            return boxes;
        }
    };
    public HashMap<IBlockState, BoxModel> invModels = new HashMap();

    public XUBlockConnectedTextureBase(Material materialIn) {
        super(materialIn);
    }

    @Override
    public void clearCaches() {
        this.invModels.clear();
    }

    @Override
    public abstract boolean func_149662_c(IBlockState var1);

    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        IBlockState state = blockAccess.func_180495_p(pos.func_177972_a(side));
        return state != blockState && !state.doesSideBlockRendering(blockAccess, pos.func_177972_a(side), side.func_176734_d());
    }

    @SideOnly(value=Side.CLIENT)
    public abstract ISolidWorldTexture getConnectedTexture(IBlockState var1, EnumFacing var2);

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        return this.worldModel.get();
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        IBlockState state = this.xuBlockState.getStateFromItemStack(item);
        BoxModel model = this.invModels.get(state);
        if (model == null) {
            model = BoxModel.newStandardBlock();
            for (EnumFacing facing : EnumFacing.values()) {
                ((Box)model.get(0)).setTextureSides(facing, this.getConnectedTexture(state, facing).getItemTexture(facing));
            }
            this.invModels.put(state, model);
        }
        return model;
    }

    public BlockRenderLayer renderLayer(IBlockState state) {
        return this.func_180664_k();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        IBlockState state1 = state == null ? world.func_180495_p(pos) : state;
        BoxModel boxes = BoxModel.newStandardBlock();
        Box worldBox = (Box)boxes.get(0);
        worldBox.layer = this.renderLayer(state);
        worldBox.clientClear();
        for (EnumFacing side : EnumFacing.values()) {
            boolean renderSide = this.func_176225_a(state, world, pos, side);
            boolean bl = worldBox.invisible[side.ordinal()] = !renderSide;
            if (!renderSide) continue;
            TextureAtlasSprite worldIcon = this.getConnectedTexture(state1, side).getWorldIcon(world, pos, side);
            BakedQuad bakedQuad = worldBox.getQuads(side).get(0);
            Box.loadTextureUV(worldBox, worldIcon, side.func_176745_a(), bakedQuad.func_178209_a(), 0, worldBox.textureBounds, null, null);
        }
        return boxes;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return super.shouldCheckWeakPower(state, world, pos, side);
    }
}

