/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IMetaProperty<T extends Comparable<T>>
extends IProperty<T> {
    public T calculateValue(IBlockAccess var1, BlockPos var2, IBlockState var3);

    public static abstract class WrapTile<T extends Comparable<T>, K extends TileEntity>
    extends Wrap<T> {
        private final T defaultVal;
        private final Class<K> clazz;

        public WrapTile(Class<K> clazz, IProperty<T> base) {
            this(clazz, base, (Comparable)Collections.min(base.func_177700_c()));
        }

        public WrapTile(Class<K> clazz, IProperty<T> base, T defaultVal) {
            super(base);
            this.clazz = clazz;
            this.defaultVal = defaultVal;
        }

        @Override
        public T calculateValue(IBlockAccess worldIn, BlockPos pos, IBlockState originalState) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile != null && this.clazz.isAssignableFrom(tile.getClass())) {
                return this.getValue(tile);
            }
            return this.defaultVal;
        }

        public abstract T getValue(K var1);
    }

    public static abstract class Wrap<T extends Comparable<T>>
    implements IMetaProperty<T> {
        final IProperty<T> base;

        public Wrap(IProperty<T> base) {
            this.base = base;
        }

        @Nonnull
        public String func_177701_a() {
            return this.base.func_177701_a();
        }

        @Nonnull
        public Collection<T> func_177700_c() {
            return this.base.func_177700_c();
        }

        @Nonnull
        public Class<T> func_177699_b() {
            return this.base.func_177699_b();
        }

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public Optional<T> func_185929_b(@Nonnull String value) {
            return this.base.func_185929_b(value);
        }

        @Nonnull
        public String func_177702_a(@Nonnull T value) {
            return this.base.func_177702_a(value);
        }
    }
}

