/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.api.machine;

import com.google.common.collect.ImmutableSet;
import com.rwtema.extrautils2.api.machine.Crusher;
import com.rwtema.extrautils2.api.machine.Furnace;
import com.rwtema.extrautils2.api.machine.Generator;
import com.rwtema.extrautils2.api.machine.Machine;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MachineRegistry {
    private static final LinkedHashMap<String, Machine> machines;
    private static Logger logger;

    public static Machine register(@Nonnull Machine machine) {
        machine.container = Loader.instance().activeModContainer();
        logger.trace("Registering " + machine.name + " from " + machine.container);
        machines.put(machine.name, machine);
        return machine;
    }

    public static boolean deregister(Machine machine) {
        logger.trace(machine.name + " was deregistered by " + machine.container);
        return machines.remove(machine.name) == machine;
    }

    private static Machine registerInternal(@Nonnull Machine machine) {
        logger.trace("Registering internal machine " + machine.name);
        machines.put(machine.name, machine);
        return machine;
    }

    @Nullable
    public static Machine getMachine(String machine) {
        return machines.get(machine);
    }

    public static Set<Machine> getMachineValues() {
        return ImmutableSet.copyOf(machines.values());
    }

    static {
        logger = LogManager.getLogger((String)"ExtraMachinaAPI");
        machines = new LinkedHashMap();
        MachineRegistry.registerInternal(Furnace.INSTANCE);
        MachineRegistry.registerInternal(Crusher.INSTANCE);
        MachineRegistry.registerInternal(Generator.INSTANCE);
    }
}

