/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import techreborn.init.ModBlocks;
import techreborn.world.veins.VeinGenerator;

public enum VeinWorldGenerator implements IWorldGenerator
{
    INSTANCE;


    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (random.nextInt(2) == 0) {
            VeinGenerator.generateRandomVein(random, chunkX, chunkZ, world);
        }
    }

    private static Pair<Float, IBlockState> additional(float chance, String name) {
        return ImmutablePair.of((Object)Float.valueOf(chance), (Object)ModBlocks.ore.getBlockStateFromName(name));
    }

    private static Pair<Float, IBlockState> primary(String name) {
        return ImmutablePair.of((Object)Float.valueOf(1.0f), (Object)ModBlocks.ore.getBlockStateFromName(name));
    }

    private static Pair<Float, IBlockState> primary(Block block) {
        return ImmutablePair.of((Object)Float.valueOf(1.0f), (Object)block.func_176223_P());
    }

    private static void registerOverworldVein(float chance, float avrSize, int minHeight, int maxHeight, Pair<Float, IBlockState> ... varargs) {
        VeinGenerator.registerVein(0, chance, avrSize, minHeight, maxHeight, varargs);
    }

    private static void registerNetherVein(float chance, float avrSize, Pair<Float, IBlockState> ... varargs) {
        VeinGenerator.registerVein(-1, chance, avrSize, 1, 128, varargs);
    }

    private static void registerEndVein(float chance, float avrSize, Pair<Float, IBlockState> ... varargs) {
        VeinGenerator.registerVein(1, chance, avrSize, 1, 64, varargs);
    }

    public static void registerTRVeins() {
        VeinWorldGenerator.registerOverworldVein(0.05f, 0.4f, 1, 60, VeinWorldGenerator.primary("iridium"));
        VeinWorldGenerator.registerOverworldVein(0.34f, 0.7f, 1, 80, VeinWorldGenerator.primary("bauxite"));
        VeinWorldGenerator.registerOverworldVein(0.67f, 1.4f, 30, 120, VeinWorldGenerator.primary("copper"));
        VeinWorldGenerator.registerOverworldVein(0.64f, 1.3f, 30, 120, VeinWorldGenerator.primary("tin"));
        VeinWorldGenerator.registerOverworldVein(0.32f, 0.7f, 1, 40, VeinWorldGenerator.primary("galena"), VeinWorldGenerator.additional(0.3f, "lead"), VeinWorldGenerator.additional(0.2f, "silver"));
        VeinWorldGenerator.registerOverworldVein(0.37f, 1.2f, 1, 30, VeinWorldGenerator.primary(Blocks.field_150450_ax), VeinWorldGenerator.additional(0.3f, "ruby"));
        VeinWorldGenerator.registerOverworldVein(0.2f, 0.74f, 1, 40, VeinWorldGenerator.primary(Blocks.field_150369_x), VeinWorldGenerator.additional(0.37f, "sapphire"));
        VeinWorldGenerator.registerNetherVein(0.73f, 0.92f, VeinWorldGenerator.primary("pyrite"));
        VeinWorldGenerator.registerNetherVein(0.47f, 0.84f, VeinWorldGenerator.primary("sphalerite"), VeinWorldGenerator.additional(0.2f, "cinnabar"));
        VeinWorldGenerator.registerEndVein(0.26f, 0.6f, VeinWorldGenerator.primary("sheldonite"), VeinWorldGenerator.additional(0.3f, "tungsten"));
        VeinWorldGenerator.registerEndVein(0.67f, 0.84f, VeinWorldGenerator.primary("sodalite"), VeinWorldGenerator.additional(0.4f, "peridot"));
    }
}

