/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.teir1;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IContainerProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.container.RebornContainer;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.client.container.ContainerGrinder;
import techreborn.init.ModBlocks;
import techreborn.utils.upgrade.UpgradeHandler;

public class TileGrinder
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IListInfoProvider,
IRecipeCrafterProvider,
IContainerProvider,
ISidedInventory {
    public Inventory inventory = new Inventory(6, "TileGrinder", 64, (TileEntity)this);
    public UpgradeHandler upgradeHandler;
    public RecipeCrafter crafter;
    public int capacity = 1000;

    public TileGrinder() {
        super(1);
        int[] inputs = new int[]{0};
        int[] outputs = new int[]{1};
        this.crafter = new RecipeCrafter(Reference.grinderRecipe, (TileMachineBase)this, 2, 1, this.inventory, inputs, outputs);
        this.upgradeHandler = new UpgradeHandler(this.crafter, this.inventory, 2, 3, 4, 5);
    }

    public void updateEntity() {
        super.updateEntity();
        this.crafter.updateEntity();
        this.upgradeHandler.tick();
        this.charge(3);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.Grinder, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.crafter.writeToNBT(tagCompound);
        return tagCompound;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getMaxPower() {
        return this.capacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        info.add("Macerator");
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    public RebornContainer getContainer() {
        return RebornContainer.getContainerFromClass(ContainerGrinder.class, (TileEntity)this);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }
}

