/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.init.ModBlocks;
import techreborn.init.ModFluids;
import techreborn.items.ItemDusts;
import techreborn.tiles.multiblock.MultiblockChecker;

public class TileIndustrialSawmill
extends TilePowerAcceptor
implements IWrenchable,
IFluidHandler,
IInventoryProvider,
ISidedInventory,
IListInfoProvider {
    public Inventory inventory = new Inventory(5, "Sawmill", 64, (TileEntity)this);
    public Tank tank = new Tank("Sawmill", 16000, (TileEntity)this);
    public int tickTime;
    public MultiblockChecker multiblockChecker;

    public TileIndustrialSawmill() {
        super(2);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.getMutliBlock()) {
            ItemStack wood = this.inventory.func_70301_a(0);
            if (this.tickTime == 0) {
                if (wood != null) {
                    for (int id : OreDictionary.getOreIDs((ItemStack)wood)) {
                        String name = OreDictionary.getOreName((int)id);
                        if (!name.equals("logWood") || !this.canAddOutput(2, 10) || !this.canAddOutput(3, 5) || !this.canAddOutput(4, 3) || !this.canUseEnergy(128.0) || this.tank.isEmpty() || this.tank.getFluid().amount < 1000) continue;
                        if (--wood.field_77994_a == 0) {
                            this.func_70299_a(0, null);
                        }
                        this.tank.drain(1000, true);
                        this.useEnergy(128.0);
                        this.tickTime = 1;
                    }
                }
            } else if (++this.tickTime > 100) {
                Random rnd = this.field_145850_b.field_73012_v;
                this.addOutput(2, new ItemStack(Blocks.field_150344_f, 6 + rnd.nextInt(4)));
                if (rnd.nextInt(4) != 0) {
                    ItemStack pulp = ItemDusts.getDustByName("sawDust", 2 + rnd.nextInt(3));
                    this.addOutput(3, pulp);
                }
                if (rnd.nextInt(3) == 0) {
                    ItemStack paper = new ItemStack(Items.field_151121_aF, 1 + rnd.nextInt(2));
                    this.addOutput(4, paper);
                }
                this.tickTime = 0;
            }
        }
        FluidUtils.drainContainers((IFluidHandler)this, (IInventory)this.inventory, (int)1, (int)4);
    }

    public void addOutput(int slot, ItemStack stack) {
        if (this.func_70301_a(slot) == null) {
            this.func_70299_a(slot, stack);
        }
        this.func_70301_a((int)slot).field_77994_a += stack.field_77994_a;
    }

    public boolean canAddOutput(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        return stack == null || this.func_70297_j_() - stack.field_77994_a >= amount;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.multiblockChecker = new MultiblockChecker(this.field_145850_b, this.func_174877_v().func_177979_c(3));
    }

    public boolean getMutliBlock() {
        boolean down = this.multiblockChecker.checkRectY(1, 1, 0, MultiblockChecker.ZERO_OFFSET);
        boolean up = this.multiblockChecker.checkRectY(1, 1, 0, new BlockPos(0, 2, 0));
        boolean blade = this.multiblockChecker.checkRingY(1, 1, 1, new BlockPos(0, 1, 0));
        IBlockState centerBlock = this.multiblockChecker.getBlock(0, 1, 0);
        boolean center = centerBlock.func_177230_c() == Blocks.field_150355_j;
        return down && center && blade && up;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.industrialSawmill, 1);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
        this.tickTime = tagCompound.func_74762_e("tickTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        tagCompound.func_74768_a("tickTime", this.tickTime);
        return tagCompound;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() == FluidRegistry.WATER || resource.getFluid() == ModFluids.fluidMercury || resource.getFluid() == ModFluids.fluidSodiumpersulfate) {
            int filled = this.tank.fill(resource, doFill);
            this.tank.compareAndUpdate();
            return filled;
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        FluidStack fluidStack = this.tank.drain(resource.amount, doDrain);
        this.tank.compareAndUpdate();
        return fluidStack;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        FluidStack drained = this.tank.drain(maxDrain, doDrain);
        this.tank.compareAndUpdate();
        return drained;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 2, 3, 4, 5};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= 2;
    }

    public int getProgressScaled(int scale) {
        if (this.tickTime != 0) {
            return this.tickTime * scale / 100;
        }
        return 0;
    }

    public double getMaxPower() {
        return 64000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 64.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.MEDIUM;
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

