/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.RollingMachineRecipe;
import techreborn.init.ModBlocks;

public class TileRollingMachine
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider {
    public final InventoryCrafting craftMatrix = new InventoryCrafting((Container)new RollingTileContainer(), 3, 3);
    public Inventory inventory = new Inventory(3, "TileRollingMachine", 64, (TileEntity)this);
    public boolean isRunning;
    public int tickTime;
    public int runTime = 250;
    public ItemStack currentRecipe;
    public int euTick = 5;

    public TileRollingMachine() {
        super(1);
    }

    public double getMaxPower() {
        return 100000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 64.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public void updateEntity() {
        super.updateEntity();
        this.charge(2);
        if (!this.field_145850_b.field_72995_K) {
            this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
            if (this.currentRecipe != null && this.canMake() && this.tickTime >= this.runTime) {
                this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
                if (this.currentRecipe != null) {
                    boolean hasCrafted = false;
                    if (this.inventory.func_70301_a(0) == null) {
                        this.inventory.func_70299_a(0, this.currentRecipe);
                        this.tickTime = -1;
                        hasCrafted = true;
                    } else if (this.inventory.func_70301_a((int)0).field_77994_a + this.currentRecipe.field_77994_a <= this.currentRecipe.func_77976_d()) {
                        ItemStack stack = this.inventory.func_70301_a(0);
                        stack.field_77994_a += this.currentRecipe.field_77994_a;
                        this.inventory.func_70299_a(0, stack);
                        this.tickTime = -1;
                        hasCrafted = true;
                    }
                    if (hasCrafted) {
                        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                            this.craftMatrix.func_70298_a(i, 1);
                        }
                        this.currentRecipe = null;
                    }
                }
            }
            if (this.currentRecipe != null && this.canUseEnergy(this.euTick) && this.tickTime < this.runTime) {
                this.useEnergy(this.euTick);
                ++this.tickTime;
            }
            if (this.currentRecipe == null) {
                this.tickTime = -1;
            }
        } else {
            this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b);
            if (this.currentRecipe != null) {
                this.inventory.func_70299_a(1, this.currentRecipe);
            } else {
                this.inventory.func_70299_a(1, null);
            }
        }
    }

    public boolean canMake() {
        return RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.field_145850_b) != null;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.RollingMachine, 1);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        ItemUtils.readInvFromNBT((IInventory)this.craftMatrix, (String)"Crafting", (NBTTagCompound)tagCompound);
        this.isRunning = tagCompound.func_74767_n("isRunning");
        this.tickTime = tagCompound.func_74762_e("tickTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        ItemUtils.writeInvToNBT((IInventory)this.craftMatrix, (String)"Crafting", (NBTTagCompound)tagCompound);
        this.writeUpdateToNBT(tagCompound);
        return tagCompound;
    }

    public void writeUpdateToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74757_a("isRunning", this.isRunning);
        tagCompound.func_74768_a("tickTime", this.tickTime);
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private static class RollingTileContainer
    extends Container {
        private RollingTileContainer() {
        }

        public boolean func_75145_c(EntityPlayer entityplayer) {
            return true;
        }
    }
}

