/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.Inventory;

public class TileIronFurnace
extends TileMachineBase
implements IInventoryProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(3, "TileIronFurnace", 64, (TileEntity)this);
    public int fuel;
    public int fuelGague;
    public int progress;
    public int fuelScale = 200;
    int input1 = 0;
    int output = 1;
    int fuelslot = 2;
    boolean active = false;

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.fuelScale;
    }

    public int gaugeFuelScaled(int scale) {
        if (this.fuelGague == 0) {
            this.fuelGague = this.fuel;
            if (this.fuelGague == 0) {
                this.fuelGague = this.fuelScale;
            }
        }
        return this.fuel * scale / this.fuelGague;
    }

    public void updateEntity() {
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.fuel > 0) {
            --this.fuel;
            this.updateState();
        }
        if (this.fuel <= 0 && this.canSmelt()) {
            this.fuel = this.fuelGague = (int)((double)TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(this.fuelslot)) * 1.25);
            if (this.fuel > 0) {
                if (this.func_70301_a(this.fuelslot).func_77973_b().func_77634_r()) {
                    this.func_70299_a(this.fuelslot, new ItemStack(this.func_70301_a(this.fuelslot).func_77973_b().func_77668_q()));
                } else if (this.func_70301_a((int)this.fuelslot).field_77994_a > 1) {
                    this.func_70298_a(this.fuelslot, 1);
                } else if (this.func_70301_a((int)this.fuelslot).field_77994_a == 1) {
                    this.func_70299_a(this.fuelslot, null);
                }
                updateInventory = true;
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.progress;
            if (this.progress >= this.fuelScale) {
                this.progress = 0;
                this.cookItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.func_70296_d();
        }
    }

    public void cookItems() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
            if (this.func_70301_a(this.output) == null) {
                this.func_70299_a(this.output, itemstack.func_77946_l());
            } else if (this.func_70301_a(this.output).func_77969_a(itemstack)) {
                this.func_70301_a((int)this.output).field_77994_a += itemstack.field_77994_a;
            }
            if (this.func_70301_a((int)this.input1).field_77994_a > 1) {
                this.func_70298_a(this.input1, 1);
            } else {
                this.func_70299_a(this.input1, null);
            }
        }
    }

    public boolean canSmelt() {
        if (this.func_70301_a(this.input1) == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
        if (itemstack == null) {
            return false;
        }
        if (this.func_70301_a(this.output) == null) {
            return true;
        }
        if (!this.func_70301_a(this.output).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.func_70301_a((int)this.output).field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        if (result != null) {
            return result.func_77946_l();
        }
        return null;
    }

    public void updateState() {
        IBlockState BlockStateContainer2 = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (BlockStateContainer2.func_177230_c() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.func_177230_c();
            if ((Boolean)BlockStateContainer2.func_177229_b((IProperty)BlockMachineBase.ACTIVE) != this.fuel > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.fuel > 0), this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

