/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.power.IEnergyInterfaceItem;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;

public class TileChargeBench
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
ISidedInventory {
    public Inventory inventory = new Inventory(6, "TileChargeBench", 64, (TileEntity)this);
    public int capacity = 100000;

    public TileChargeBench() {
        super(4);
    }

    public void updateEntity() {
        super.updateEntity();
        for (int i = 0; i < 6; ++i) {
            ItemStack stack;
            if (this.inventory.func_70301_a(i) == null || !(this.getEnergy() > 0.0) || !((stack = this.inventory.func_70301_a(i)).func_77973_b() instanceof IEnergyInterfaceItem)) continue;
            IEnergyInterfaceItem interfaceItem = (IEnergyInterfaceItem)stack.func_77973_b();
            double trans = Math.min(interfaceItem.getMaxPower(stack) - interfaceItem.getEnergy(stack), Math.min(interfaceItem.getMaxTransfer(stack), this.getEnergy()));
            interfaceItem.setEnergy(trans + interfaceItem.getEnergy(stack), stack);
            this.useEnergy(trans);
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.chargeBench, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray = nArray2;
            nArray2[5] = 5;
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 3;
            nArray3[4] = 4;
            nArray = nArray3;
            nArray3[5] = 5;
        }
        return nArray;
    }

    public boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return false;
    }

    public double getMaxPower() {
        return this.capacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 512.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.MEDIUM;
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

