/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import com.google.common.collect.ImmutableList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import techreborn.Core;
import techreborn.blocks.BlockMachineFrame;
import techreborn.init.IC2Dict;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ItemDusts;
import techreborn.items.ItemGems;
import techreborn.items.ItemIngots;
import techreborn.items.ItemNuggets;
import techreborn.items.ItemParts;
import techreborn.items.ItemPlates;
import techreborn.parts.powerCables.ItemStandaloneCables;
import techreborn.utils.OreDictUtils;

public class OreDict {
    private static final ImmutableList<String> plateGenIgnores = ImmutableList.of((Object)"hot", (Object)"mixedMetal", (Object)"iridiumAlloy", (Object)"PLACEHOLDER_ITEM");

    public static void init() {
        String oreDictName;
        boolean ignoreIt;
        if (Loader.isModLoaded((String)"IC2")) {
            Core.logHelper.info((Object)"IC2 installed, enabling integration");
            IC2Dict.init();
        }
        OreDictionary.registerOre((String)"reBattery", (Item)ModItems.reBattery);
        OreDictionary.registerOre((String)"circuitBasic", (ItemStack)ItemParts.getPartByName("electronicCircuit"));
        OreDictionary.registerOre((String)"circuitAdvanced", (ItemStack)ItemParts.getPartByName("advancedCircuit"));
        OreDictionary.registerOre((String)"circuitStorage", (ItemStack)ItemParts.getPartByName("dataStorageCircuit"));
        OreDictionary.registerOre((String)"circuitElite", (ItemStack)ItemParts.getPartByName("dataControlCircuit"));
        OreDictionary.registerOre((String)"circuitMaster", (ItemStack)ItemParts.getPartByName("energyFlowCircuit"));
        OreDictionary.registerOre((String)"machineBlockBasic", (ItemStack)BlockMachineFrame.getFrameByName("machine", 1));
        OreDictionary.registerOre((String)"machineBlockAdvanced", (ItemStack)BlockMachineFrame.getFrameByName("advancedMachine", 1));
        OreDictionary.registerOre((String)"machineBlockElite", (ItemStack)BlockMachineFrame.getFrameByName("highlyAdvancedMachine", 1));
        OreDictionary.registerOre((String)"lapotronCrystal", (Item)ModItems.lapotronCrystal);
        OreDictionary.registerOre((String)"energyCrystal", (Item)ModItems.energyCrystal);
        OreDictionary.registerOre((String)"drillBasic", (Item)ModItems.diamondDrill);
        OreDictionary.registerOre((String)"drillDiamond", (Item)ModItems.diamondDrill);
        OreDictionary.registerOre((String)"industrialTnt", (Block)Blocks.field_150335_W);
        OreDictionary.registerOre((String)"craftingIndustrialDiamond", (Item)Items.field_151045_i);
        OreDictionary.registerOre((String)"insulatedGoldCableItem", (ItemStack)ItemStandaloneCables.getCableByName("insulatedgold"));
        OreDictionary.registerOre((String)"fertilizer", (ItemStack)new ItemStack(Items.field_151100_aR, 1, 15));
        OreDictionary.registerOre((String)"ic2Generator", (Block)ModBlocks.Generator);
        OreDictionary.registerOre((String)"ic2SolarPanel", (Block)ModBlocks.solarPanel);
        OreDictionary.registerOre((String)"ic2Macerator", (Block)ModBlocks.Grinder);
        OreDictionary.registerOre((String)"ic2Extractor", (Block)ModBlocks.Extractor);
        OreDictionary.registerOre((String)"ic2Windmill", (Block)ModBlocks.windMill);
        OreDictionary.registerOre((String)"ic2Watermill", (Block)ModBlocks.waterMill);
        OreDictionary.registerOre((String)"fenceIron", (Block)ModBlocks.ironFence);
        OreDictionary.registerOre((String)"woodRubber", (Block)ModBlocks.rubberLog);
        OreDictionary.registerOre((String)"glassReinforced", (Block)ModBlocks.reinforcedglass);
        OreDictionary.registerOre((String)"diamondTR", (ItemStack)ItemDusts.getDustByName("Diamond"));
        OreDictionary.registerOre((String)"diamondTR", (Item)Items.field_151045_i);
        OreDictionary.registerOre((String)"craftingGrinder", (ItemStack)ItemParts.getPartByName("diamondGrindingHead"));
        OreDictionary.registerOre((String)"craftingGrinder", (ItemStack)ItemParts.getPartByName("tungstenGrindingHead"));
        OreDictionary.registerOre((String)"craftingSuperconductor", (ItemStack)ItemParts.getPartByName("superconductor"));
        OreDictionary.registerOre((String)"batteryUltimate", (ItemStack)ItemParts.getPartByName("diamondGrindingHead"));
        OreDictionary.registerOre((String)"materialResin", (ItemStack)ItemParts.getPartByName("rubberSap"));
        OreDictionary.registerOre((String)"materialRubber", (ItemStack)ItemParts.getPartByName("rubber"));
        OreDictionary.registerOre((String)"pulpWood", (ItemStack)ItemDusts.getDustByName("sawDust"));
        for (String type : ItemGems.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            String upper = OreDictUtils.toFirstUpper(type);
            OreDictionary.registerOre((String)("gem" + upper), (ItemStack)ItemGems.getGemByName(type));
            ignoreIt = false;
            for (String ignore : plateGenIgnores) {
                if (!type.startsWith(ignore)) continue;
                ignoreIt = true;
            }
            if (ignoreIt) continue;
            ItemPlates.registerType(upper);
        }
        for (String type : ItemIngots.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            String upperName = OreDictUtils.toFirstUpper(type);
            OreDictionary.registerOre((String)("ingot" + upperName), (ItemStack)ItemIngots.getIngotByName(type));
            ignoreIt = false;
            for (String ignore : plateGenIgnores) {
                if (!type.startsWith(ignore)) continue;
                ignoreIt = true;
            }
            if (ignoreIt) continue;
            ItemPlates.registerType(type);
        }
        for (String type : ItemPlates.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            oreDictName = "plate" + OreDictUtils.toFirstUpper(type);
            OreDictionary.registerOre((String)oreDictName, (ItemStack)ItemPlates.getPlateByName(type));
        }
        for (String type : ItemDusts.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            oreDictName = "dust" + OreDictUtils.toFirstUpper(type);
            OreDictionary.registerOre((String)oreDictName, (ItemStack)ItemDusts.getDustByName(type));
        }
        for (String type : ItemNuggets.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            oreDictName = "nugget" + OreDictUtils.toFirstUpper(type);
            OreDictionary.registerOre((String)oreDictName, (ItemStack)ItemNuggets.getNuggetByName(type));
        }
    }
}

