/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.iron_machines;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.blocks.IRotationTexture;
import techreborn.Core;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.TileIronFurnace;

public class BlockIronFurnace
extends BlockMachineBase
implements IRotationTexture {
    private final String prefix = "techreborn:blocks/machine/iron_machines/";

    public BlockIronFurnace() {
        this.func_149663_c("techreborn.ironfurnace");
        this.func_149647_a(TechRebornCreativeTab.instance);
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileIronFurnace();
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            player.openGui((Object)Core.INSTANCE, 36, world, x, y, z);
        }
        return true;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack((Block)this));
        return items;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.isActive(state)) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            switch (enumfacing) {
                case WEST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public String getFrontOff() {
        return "techreborn:blocks/machine/iron_machines/iron_furnace_front_off";
    }

    public String getFrontOn() {
        return "techreborn:blocks/machine/iron_machines/iron_furnace_front_on";
    }

    public String getSide() {
        return "techreborn:blocks/machine/iron_machines/iron_machine_side";
    }

    public String getTop() {
        return "techreborn:blocks/machine/iron_machines/iron_machine_top";
    }

    public String getBottom() {
        return "techreborn:blocks/machine/iron_machines/iron_machine_bottom";
    }
}

