/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api.recipe.recipeConfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import reborncore.api.recipe.IBaseRecipeType;
import techreborn.api.recipe.recipeConfig.ConfigItem;
import techreborn.api.recipe.recipeConfig.RecipeConfig;

public class RecipeConfigManager {
    public static ArrayList<RecipeConfig> configs = new ArrayList();
    static File configFile = null;

    public static void load(File configDir) {
        if (configFile == null) {
            configFile = new File(configDir, "techRebornRecipes.json");
        }
    }

    public static void save() {
        if (configFile.exists()) {
            configFile.delete();
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(configs);
        try {
            FileWriter writer = new FileWriter(configFile);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean canLoadRecipe(IBaseRecipeType recipeType) {
        RecipeConfig config = new RecipeConfig();
        for (ItemStack stack : recipeType.getInputs()) {
            config.addInputs(RecipeConfigManager.itemToConfig(stack));
        }
        for (ItemStack stack : recipeType.getOutputs()) {
            config.addOutputs(RecipeConfigManager.itemToConfig(stack));
        }
        config.enabled = true;
        config.setMachine(recipeType.getRecipeName());
        configs.add(config);
        return config.enabled;
    }

    public static ConfigItem itemToConfig(ItemStack stack) {
        ConfigItem newItem = new ConfigItem();
        newItem.setItemName(stack.func_77973_b().func_77658_a());
        newItem.setMeta(stack.func_77952_i());
        newItem.setStackSize(stack.field_77994_a);
        newItem.setLocalName(stack.func_82833_r());
        return newItem;
    }
}

