/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.common.FuelHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.Tier;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.ShapedMekanismRecipe;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.GeneratorsCommonProxy;
import mekanism.generators.common.GeneratorsGuiHandler;
import mekanism.generators.common.GeneratorsItems;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="MekanismGenerators", name="MekanismGenerators", version="9.1.1", dependencies="required-after:Mekanism", guiFactory="mekanism.generators.client.gui.GeneratorsGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class MekanismGenerators
implements IModule {
    @SidedProxy(clientSide="mekanism.generators.client.GeneratorsClientProxy", serverSide="mekanism.generators.common.GeneratorsCommonProxy")
    public static GeneratorsCommonProxy proxy;
    @Mod.Instance(value="MekanismGenerators")
    public static MekanismGenerators instance;
    public static Version versionNumber;
    public static MultiblockManager<SynchronizedTurbineData> turbineManager;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        GeneratorsBlocks.register();
        GeneratorsItems.register();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Mekanism.modulesLoaded.add(this);
        PacketSimpleGui.handlers.add(1, proxy);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GeneratorsGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.loadConfiguration();
        proxy.registerRegularTileEntities();
        proxy.registerSpecialTileEntities();
        this.addRecipes();
        Mekanism.logger.info("Loaded MekanismGenerators module.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (FuelHandler.BCPresent() && BuildcraftFuelRegistry.fuel != null) {
            for (IFuel s : BuildcraftFuelRegistry.fuel.getFuels()) {
                if (s.getFluid() == null || GasRegistry.containsGas((String)s.getFluid().getName())) continue;
                GasRegistry.register((Gas)new Gas(s.getFluid()));
            }
            BuildcraftFuelRegistry.fuel.addFuel(FluidRegistry.getFluid((String)"ethene"), (int)(240.0 * MekanismConfig.general.TO_RF), 40000);
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustGold")) {
            RecipeHandler.addMetallurgicInfuserRecipe((InfuseType)InfuseRegistry.get((String)"CARBON"), (int)10, (ItemStack)MekanismUtils.size((ItemStack)ore, (int)4), (ItemStack)GeneratorsItems.Hohlraum.getEmptyItem());
        }
    }

    public void addRecipes() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 0), new Object[]{"III", "WOW", "CFC", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "ingotCopper", Character.valueOf('O'), "ingotOsmium", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('W'), "plankWood"}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 1), new Object[]{"SSS", "AIA", "PEP", Character.valueOf('S'), GeneratorsItems.SolarPanel, Character.valueOf('A'), MekanismItems.EnrichedAlloy, Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "dustOsmium", Character.valueOf('E'), MekanismItems.EnergyTablet.getUnchargedItem()}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 5), new Object[]{"SES", "SES", "III", Character.valueOf('S'), new ItemStack(GeneratorsBlocks.Generator, 1, 1), Character.valueOf('E'), MekanismItems.EnrichedAlloy, Character.valueOf('I'), "ingotIron"}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 4), new Object[]{"RER", "BCB", "NEN", Character.valueOf('R'), "dustRedstone", Character.valueOf('E'), MekanismItems.EnrichedAlloy, Character.valueOf('B'), MekanismItems.BioFuel, Character.valueOf('C'), MekanismUtils.getControlCircuit((Tier.BaseTier)Tier.BaseTier.BASIC), Character.valueOf('N'), "ingotIron"}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 3), new Object[]{"PEP", "ICI", "PEP", Character.valueOf('P'), "ingotOsmium", Character.valueOf('E'), MekanismItems.EnrichedAlloy, Character.valueOf('I'), new ItemStack(MekanismBlocks.BasicBlock, 1, 8), Character.valueOf('C'), MekanismItems.ElectrolyticCore}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsItems.SolarPanel), new Object[]{"GGG", "RAR", "PPP", Character.valueOf('G'), "paneGlass", Character.valueOf('R'), "dustRedstone", Character.valueOf('A'), MekanismItems.EnrichedAlloy, Character.valueOf('P'), "ingotOsmium"}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 6), new Object[]{" O ", "OAO", "ECE", Character.valueOf('O'), "ingotOsmium", Character.valueOf('A'), MekanismItems.EnrichedAlloy, Character.valueOf('E'), MekanismItems.EnergyTablet.getUnchargedItem(), Character.valueOf('C'), MekanismUtils.getControlCircuit((Tier.BaseTier)Tier.BaseTier.BASIC)}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsItems.TurbineBlade), new Object[]{" S ", "SAS", " S ", Character.valueOf('S'), "ingotSteel", Character.valueOf('A'), MekanismItems.EnrichedAlloy}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 7), new Object[]{"SAS", "SAS", "SAS", Character.valueOf('S'), "ingotSteel", Character.valueOf('A'), MekanismItems.EnrichedAlloy}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 8), new Object[]{"SAS", "CAC", "SAS", Character.valueOf('S'), "ingotSteel", Character.valueOf('A'), MekanismItems.EnrichedAlloy, Character.valueOf('C'), MekanismUtils.getControlCircuit((Tier.BaseTier)Tier.BaseTier.ADVANCED)}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 9), new Object[]{"SGS", "GEG", "SGS", Character.valueOf('S'), "ingotSteel", Character.valueOf('G'), "ingotGold", Character.valueOf('E'), MekanismItems.EnergyTablet.getUnchargedItem()}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 4, 10), new Object[]{" S ", "SOS", " S ", Character.valueOf('S'), "ingotSteel", Character.valueOf('O'), "ingotOsmium"}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 2, 11), new Object[]{" I ", "ICI", " I ", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.Generator, 1, 10), Character.valueOf('C'), MekanismUtils.getControlCircuit((Tier.BaseTier)Tier.BaseTier.ADVANCED)}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 2, 12), new Object[]{" I ", "IFI", " I ", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.Generator, 1, 10), Character.valueOf('F'), Blocks.field_150411_aY}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 13), new Object[]{"STS", "TBT", "STS", Character.valueOf('S'), "ingotSteel", Character.valueOf('T'), "ingotTin", Character.valueOf('B'), Items.field_151133_ar}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Reactor, 4, 1), new Object[]{" C ", "CAC", " C ", Character.valueOf('C'), new ItemStack(MekanismBlocks.BasicBlock, 1, 8), Character.valueOf('A'), "alloyUltimate"}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Reactor, 2, 3), new Object[]{" I ", "ICI", " I ", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.Reactor, 1, 1), Character.valueOf('C'), MekanismUtils.getControlCircuit((Tier.BaseTier)Tier.BaseTier.ULTIMATE)}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.ReactorGlass, 4, 0), new Object[]{" I ", "IGI", " I ", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.Reactor, 1, 1), Character.valueOf('G'), "blockGlass"}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Reactor, 1, 0), new Object[]{"CGC", "ITI", "III", Character.valueOf('C'), MekanismUtils.getControlCircuit((Tier.BaseTier)Tier.BaseTier.ULTIMATE), Character.valueOf('G'), "paneGlass", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.Reactor, 1, 1), Character.valueOf('T'), MekanismUtils.getEmptyGasTank((Tier.GasTankTier)Tier.GasTankTier.BASIC)}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.ReactorGlass, 2, 1), new Object[]{" I ", "ILI", " I ", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.ReactorGlass, 1, 0), Character.valueOf('L'), "blockRedstone"}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Reactor, 1, 4), new Object[]{" R ", "RFR", " R ", Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), new ItemStack(GeneratorsBlocks.Reactor, 1, 1)}));
        FuelHandler.addGas((Gas)GasRegistry.getGas((String)"ethene"), (int)MekanismConfig.general.ETHENE_BURN_TIME, (double)(MekanismConfig.general.FROM_H2 + MekanismConfig.generators.bioGeneration * 2.0 * (double)MekanismConfig.general.ETHENE_BURN_TIME));
    }

    public Version getVersion() {
        return versionNumber;
    }

    public String getName() {
        return "Generators";
    }

    public void writeConfig(ByteBuf dataStream) throws IOException {
        dataStream.writeDouble(MekanismConfig.generators.advancedSolarGeneration);
        dataStream.writeDouble(MekanismConfig.generators.bioGeneration);
        dataStream.writeDouble(MekanismConfig.generators.heatGeneration);
        dataStream.writeDouble(MekanismConfig.generators.heatGenerationLava);
        dataStream.writeDouble(MekanismConfig.generators.heatGenerationNether);
        dataStream.writeDouble(MekanismConfig.generators.solarGeneration);
        dataStream.writeDouble(MekanismConfig.generators.windGenerationMin);
        dataStream.writeDouble(MekanismConfig.generators.windGenerationMax);
        dataStream.writeInt(MekanismConfig.generators.windGenerationMinY);
        dataStream.writeInt(MekanismConfig.generators.windGenerationMaxY);
        dataStream.writeInt(MekanismConfig.generators.turbineBladesPerCoil);
        dataStream.writeDouble(MekanismConfig.generators.turbineVentGasFlow);
        dataStream.writeDouble(MekanismConfig.generators.turbineDisperserGasFlow);
        dataStream.writeInt(MekanismConfig.generators.condenserRate);
    }

    public void readConfig(ByteBuf dataStream) throws IOException {
        MekanismConfig.generators.advancedSolarGeneration = dataStream.readDouble();
        MekanismConfig.generators.bioGeneration = dataStream.readDouble();
        MekanismConfig.generators.heatGeneration = dataStream.readDouble();
        MekanismConfig.generators.heatGenerationLava = dataStream.readDouble();
        MekanismConfig.generators.heatGenerationNether = dataStream.readDouble();
        MekanismConfig.generators.solarGeneration = dataStream.readDouble();
        MekanismConfig.generators.windGenerationMin = dataStream.readDouble();
        MekanismConfig.generators.windGenerationMax = dataStream.readDouble();
        MekanismConfig.generators.windGenerationMinY = dataStream.readInt();
        MekanismConfig.generators.windGenerationMaxY = dataStream.readInt();
        MekanismConfig.generators.turbineBladesPerCoil = dataStream.readInt();
        MekanismConfig.generators.turbineVentGasFlow = dataStream.readDouble();
        MekanismConfig.generators.turbineDisperserGasFlow = dataStream.readDouble();
        MekanismConfig.generators.condenserRate = dataStream.readInt();
    }

    public void resetClient() {
        SynchronizedTurbineData.clientRotationMap.clear();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("MekanismGenerators")) {
            proxy.loadConfiguration();
        }
    }

    static {
        versionNumber = new Version(9, 1, 1);
        turbineManager = new MultiblockManager("industrialTurbine");
    }
}

