/*
 * Decompiled with CFR 0.152.
 */
package ic2.jeiIntegration.recipe.machine;

import ic2.api.item.IBlockCuttingBlade;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.item.type.BlockCuttingBladeType;
import ic2.core.item.type.CraftingItemType;
import ic2.core.ref.ItemName;
import ic2.jeiIntegration.recipe.machine.AdvancedIORecipeWrapper;
import ic2.jeiIntegration.recipe.machine.IORecipeCategory;
import ic2.jeiIntegration.recipe.machine.IORecipeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public interface IRecipeWrapperGenerator<T> {
    public static final IRecipeWrapperGenerator<IMachineRecipeManager> basicMachine = new IRecipeWrapperGenerator<IMachineRecipeManager>(){

        @Override
        public List<IRecipeWrapper> getRecipeList(IORecipeCategory<IMachineRecipeManager> category) {
            ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
            for (IMachineRecipeManager.RecipeIoContainer container : ((IMachineRecipeManager)category.recipeManager).getRecipes()) {
                recipes.add((IRecipeWrapper)new IORecipeWrapper(container, category));
            }
            return recipes;
        }
    };
    public static final IRecipeWrapperGenerator<IMachineRecipeManager> recycler = new IRecipeWrapperGenerator<IMachineRecipeManager>(){

        @Override
        public List<IRecipeWrapper> getRecipeList(IORecipeCategory<IMachineRecipeManager> category) {
            IRecipeInput input;
            if (Recipes.recyclerWhitelist.isEmpty()) {
                final ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (Item i : Item.field_150901_e) {
                    ItemStack stack = new ItemStack(i, 1, Short.MAX_VALUE);
                    if (Recipes.recyclerBlacklist.contains(stack)) continue;
                    items.add(stack);
                }
                input = new IRecipeInput(){

                    @Override
                    public boolean matches(ItemStack subject) {
                        return !Recipes.recyclerBlacklist.contains(subject);
                    }

                    @Override
                    public List<ItemStack> getInputs() {
                        return items;
                    }

                    @Override
                    public int getAmount() {
                        return 1;
                    }
                };
            } else {
                final ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (IRecipeInput stack : Recipes.recyclerWhitelist) {
                    stacks.addAll(stack.getInputs());
                }
                input = new IRecipeInput(){

                    @Override
                    public boolean matches(ItemStack subject) {
                        return Recipes.recyclerWhitelist.contains(subject);
                    }

                    @Override
                    public List<ItemStack> getInputs() {
                        return stacks;
                    }

                    @Override
                    public int getAmount() {
                        return 1;
                    }
                };
            }
            return Collections.singletonList(new IORecipeWrapper(new IMachineRecipeManager.RecipeIoContainer(input, new RecipeOutput(null, ItemName.crafting.getItemStack(CraftingItemType.scrap))), category));
        }
    };
    public static final IRecipeWrapperGenerator<IMachineRecipeManager> blockCutter = new IRecipeWrapperGenerator<IMachineRecipeManager>(){
        private List<ItemStack> candidates = Arrays.asList(ItemName.block_cutting_blade.getItemStack(BlockCuttingBladeType.iron), ItemName.block_cutting_blade.getItemStack(BlockCuttingBladeType.steel), ItemName.block_cutting_blade.getItemStack(BlockCuttingBladeType.diamond));

        @Override
        public List<IRecipeWrapper> getRecipeList(IORecipeCategory<IMachineRecipeManager> category) {
            ArrayList<IRecipeWrapper> list = new ArrayList<IRecipeWrapper>();
            for (IMachineRecipeManager.RecipeIoContainer container : ((IMachineRecipeManager)category.recipeManager).getRecipes()) {
                list.add((IRecipeWrapper)new AdvancedIORecipeWrapper(container, this.getInput(this.getHadness(container.output)), category));
            }
            return list;
        }

        private int getHadness(RecipeOutput output) {
            if (output.metadata == null) {
                return Integer.MAX_VALUE;
            }
            return output.metadata.func_74762_e("hardness");
        }

        private IRecipeInput getInput(final int hardness) {
            return new IRecipeInput(){

                @Override
                public boolean matches(ItemStack subject) {
                    return subject != null && subject.func_77973_b() instanceof IBlockCuttingBlade && ((IBlockCuttingBlade)subject.func_77973_b()).getHardness(subject) > hardness;
                }

                @Override
                public List<ItemStack> getInputs() {
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>(candidates.size());
                    for (ItemStack stack : candidates) {
                        if (((IBlockCuttingBlade)stack.func_77973_b()).getHardness(stack) < hardness) continue;
                        list.add(stack);
                    }
                    return list;
                }

                @Override
                public int getAmount() {
                    return 1;
                }
            };
        }
    };

    public List<IRecipeWrapper> getRecipeList(IORecipeCategory<T> var1);
}

