/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.init.Localization;
import ic2.core.item.ItemIC2;
import ic2.core.ref.IItemModelProvider;
import ic2.core.ref.ItemName;
import ic2.core.util.Util;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorIC2
extends ItemArmor
implements IItemModelProvider,
IMetalArmor {
    private final String armorName;
    private final Object repairMaterial;

    public ItemArmorIC2(ItemName name, ItemArmor.ArmorMaterial armorMaterial, InternalName armorName, EntityEquipmentSlot armorType, Object repairMaterial) {
        super(armorMaterial, -1, armorType);
        this.repairMaterial = repairMaterial;
        this.armorName = armorName.name();
        this.func_77656_e(armorMaterial.func_78046_a(armorType));
        this.func_77655_b(name.name());
        this.func_77637_a(IC2.tabIC2);
        GameRegistry.registerItem((Item)this, (String)name.name());
        name.setInstance(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ItemName name) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)ItemIC2.getModelLocation(name, null));
    }

    public int getMetadata(ItemStack stack) {
        return 0;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String suffix1 = this.field_77881_a == EntityEquipmentSlot.LEGS ? "2" : "1";
        String suffix2 = type != null && this.hasOverlayTexture() ? "_overlay" : "";
        return "ic2:textures/armor/" + this.armorName + "_" + suffix1 + suffix2 + ".png";
    }

    protected boolean hasOverlayTexture() {
        return false;
    }

    public String func_77658_a() {
        return "ic2." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack stack) {
        return Localization.translate(this.func_77667_c(stack));
    }

    @Override
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair != null && Util.matchesOD(repair, this.repairMaterial);
    }
}

