/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.audio;

import ic2.core.IC2;
import ic2.core.IHitSoundOverride;
import ic2.core.audio.AudioManager;
import ic2.core.audio.AudioPosition;
import ic2.core.audio.AudioSource;
import ic2.core.audio.AudioSourceClient;
import ic2.core.audio.PositionSpec;
import ic2.core.init.MainConfig;
import ic2.core.util.ConfigUtil;
import ic2.core.util.LogCategory;
import ic2.core.util.ReflectionUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
public final class AudioManagerClient
extends AudioManager {
    public float fadingDistance = 16.0f;
    private boolean enabled = true;
    private int maxSourceCount = 32;
    private final int streamingSourceCount = 4;
    private SoundManager soundManager;
    private Field soundManagerLoaded;
    private volatile Thread initThread;
    private SoundSystem soundSystem = null;
    private float masterVolume = 0.5f;
    private int nextId = 0;
    private final Map<WeakObject, List<AudioSource>> objectToAudioSourceMap = new HashMap<WeakObject, List<AudioSource>>();

    @Override
    public void initialize() {
        this.enabled = ConfigUtil.getBool(MainConfig.get(), "misc/enableIc2Audio");
        this.maxSourceCount = ConfigUtil.getInt(MainConfig.get(), "misc/maxAudioSourceCount");
        if (this.maxSourceCount <= 6) {
            IC2.log.info(LogCategory.Audio, "The audio source limit is too low to enable IC2 sounds.");
            this.enabled = false;
        }
        if (!this.enabled) {
            IC2.log.debug(LogCategory.Audio, "Sounds disabled.");
            return;
        }
        if (this.maxSourceCount < 6) {
            this.enabled = false;
            return;
        }
        IC2.log.debug(LogCategory.Audio, "Using %d audio sources.", this.maxSourceCount);
        SoundSystemConfig.setNumberStreamingChannels((int)4);
        SoundSystemConfig.setNumberNormalChannels((int)(this.maxSourceCount - 4));
        this.soundManagerLoaded = ReflectionUtil.getField(SoundManager.class, Boolean.TYPE);
        if (this.soundManagerLoaded == null) {
            IC2.log.warn(LogCategory.Audio, "Can't find SoundManager.loaded, IC2 audio disabled.");
            this.enabled = false;
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onSoundSetup(SoundLoadEvent event) {
        if (!this.enabled) {
            return;
        }
        this.objectToAudioSourceMap.clear();
        Thread thread = this.initThread;
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        IC2.log.debug(LogCategory.Audio, "IC2 audio starting.");
        this.soundSystem = null;
        this.soundManager = AudioManagerClient.getSoundManager();
        this.initThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        boolean loaded;
                        try {
                            loaded = AudioManagerClient.this.soundManagerLoaded.getBoolean(AudioManagerClient.this.soundManager);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        if (loaded) {
                            AudioManagerClient.this.soundSystem = AudioManagerClient.getSoundSystem(AudioManagerClient.this.soundManager);
                            if (AudioManagerClient.this.soundSystem == null) {
                                IC2.log.warn(LogCategory.Audio, "IC2 audio unavailable.");
                                AudioManagerClient.this.enabled = false;
                            } else {
                                IC2.log.debug(LogCategory.Audio, "IC2 audio ready.");
                            }
                            break;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AudioManagerClient.this.initThread = null;
            }
        }, "IC2 audio init thread");
        this.initThread.setDaemon(true);
        this.initThread.start();
    }

    private static SoundManager getSoundManager() {
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        return (SoundManager)ReflectionUtil.getValue(handler, SoundManager.class);
    }

    private static SoundSystem getSoundSystem(SoundManager soundManager) {
        return (SoundSystem)ReflectionUtil.getValue(soundManager, SoundSystem.class);
    }

    @Override
    public void onTick() {
        if (!this.enabled || !this.valid()) {
            return;
        }
        IC2.platform.profilerStartSection("UpdateMasterVolume");
        float configSoundVolume = Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER);
        if (configSoundVolume != this.masterVolume) {
            this.masterVolume = configSoundVolume;
        }
        IC2.platform.profilerEndStartSection("UpdateSourceVolume");
        EntityPlayer player = IC2.platform.getPlayerInstance();
        Vector<WeakObject> audioSourceObjectsToRemove = new Vector<WeakObject>();
        if (player == null) {
            audioSourceObjectsToRemove.addAll(this.objectToAudioSourceMap.keySet());
        } else {
            PriorityQueue<AudioSource> validAudioSources = new PriorityQueue<AudioSource>();
            for (Map.Entry<WeakObject, List<AudioSource>> entry : this.objectToAudioSourceMap.entrySet()) {
                if (entry.getKey().isEnqueued()) {
                    audioSourceObjectsToRemove.add(entry.getKey());
                    continue;
                }
                for (AudioSource audioSource : entry.getValue()) {
                    audioSource.updateVolume(player);
                    if (!(audioSource.getRealVolume() > 0.0f)) continue;
                    validAudioSources.add(audioSource);
                }
            }
            IC2.platform.profilerEndStartSection("Culling");
            int i = 0;
            while (!validAudioSources.isEmpty()) {
                if (i < this.maxSourceCount) {
                    ((AudioSource)validAudioSources.poll()).activate();
                } else {
                    ((AudioSource)validAudioSources.poll()).cull();
                }
                ++i;
            }
        }
        for (WeakObject obj : audioSourceObjectsToRemove) {
            this.removeSources(obj);
        }
        IC2.platform.profilerEndSection();
    }

    @Override
    public AudioSource createSource(Object obj, String initialSoundFile) {
        return this.createSource(obj, PositionSpec.Center, initialSoundFile, false, false, this.getDefaultVolume());
    }

    @Override
    public AudioSource createSource(Object obj, PositionSpec positionSpec, String initialSoundFile, boolean loop, boolean priorized, float volume) {
        if (!this.enabled) {
            return null;
        }
        if (!this.valid()) {
            return null;
        }
        String sourceName = AudioManagerClient.getSourceName(this.nextId);
        ++this.nextId;
        AudioSourceClient audioSource = new AudioSourceClient(this.soundSystem, sourceName, obj, positionSpec, initialSoundFile, loop, priorized, volume);
        WeakObject key = new WeakObject(obj);
        if (!this.objectToAudioSourceMap.containsKey(key)) {
            this.objectToAudioSourceMap.put(key, new LinkedList());
        }
        this.objectToAudioSourceMap.get(key).add(audioSource);
        return audioSource;
    }

    @Override
    public void removeSources(Object obj) {
        if (!this.valid()) {
            return;
        }
        WeakObject key = obj instanceof WeakObject ? (WeakObject)obj : new WeakObject(obj);
        if (!this.objectToAudioSourceMap.containsKey(key)) {
            return;
        }
        for (AudioSource audioSource : this.objectToAudioSourceMap.get(key)) {
            audioSource.remove();
        }
        this.objectToAudioSourceMap.remove(key);
    }

    @Override
    public void playOnce(Object obj, String soundFile) {
        this.playOnce(obj, PositionSpec.Center, soundFile, false, this.getDefaultVolume());
    }

    @Override
    public void playOnce(Object obj, PositionSpec positionSpec, String soundFile, boolean priorized, float volume) {
        if (!this.enabled) {
            return;
        }
        if (!this.valid()) {
            return;
        }
        AudioPosition position = AudioPosition.getFrom(obj, positionSpec);
        if (position == null) {
            return;
        }
        URL url = AudioSource.class.getClassLoader().getResource("ic2/sounds/" + soundFile);
        if (url == null) {
            IC2.log.warn(LogCategory.Audio, "Invalid sound file: %s.", soundFile);
            return;
        }
        String sourceName = this.soundSystem.quickPlay(priorized, url, soundFile, false, position.x, position.y, position.z, 2, this.fadingDistance * Math.max(volume, 1.0f));
        this.soundSystem.setVolume(sourceName, this.masterVolume * Math.min(volume, 1.0f));
    }

    @Override
    public float getDefaultVolume() {
        return 1.2f;
    }

    @Override
    public float getMasterVolume() {
        return this.masterVolume;
    }

    @Override
    protected boolean valid() {
        try {
            return this.soundSystem != null && this.soundManager != null && this.soundManagerLoaded.getBoolean(this.soundManager);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public void onSoundPlayed(PlaySoundEvent event) {
        if (event.getSound().func_184365_d() == SoundCategory.NEUTRAL && event.getName().endsWith(".hit") || event.getSound().func_184365_d() == SoundCategory.BLOCKS && event.getName().endsWith(".break")) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (stack != null && stack.func_77973_b() instanceof IHitSoundOverride) {
                String replace;
                RayTraceResult mop = AudioManagerClient.getMovingObjectPositionFromPlayer(player.field_70170_p, (EntityPlayer)player, false);
                BlockPos pos = new BlockPos((double)event.getSound().func_147649_g(), (double)event.getSound().func_147654_h(), (double)event.getSound().func_147651_i());
                if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && pos.equals((Object)mop.func_178782_a()) && (replace = event.getSound().func_184365_d() == SoundCategory.NEUTRAL ? ((IHitSoundOverride)stack.func_77973_b()).getHitSoundForBlock(player, (World)Minecraft.func_71410_x().field_71441_e, pos, stack) : ((IHitSoundOverride)stack.func_77973_b()).getBreakSoundForBlock(player, (World)Minecraft.func_71410_x().field_71441_e, pos, stack)) != null) {
                    event.setResultSound(null);
                    if (!replace.isEmpty()) {
                        IC2.platform.playSoundSp(replace, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private static RayTraceResult getMovingObjectPositionFromPlayer(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = 5.0;
        Vec3d vec31 = vec3.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_147447_a(vec3, vec31, useLiquids, !useLiquids, false);
    }

    private static String getSourceName(int id) {
        return "asm_snd" + id;
    }

    public static class WeakObject
    extends WeakReference<Object> {
        public WeakObject(Object referent) {
            super(referent);
        }

        public boolean equals(Object object) {
            if (object instanceof WeakObject) {
                return ((WeakObject)object).get() == this.get();
            }
            return this.get() == object;
        }

        public int hashCode() {
            Object object = this.get();
            if (object == null) {
                return 0;
            }
            return object.hashCode();
        }
    }
}

