/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.item.ElectricItem;
import ic2.api.item.IItemHudInfo;
import ic2.core.item.armor.ItemArmorCFPack;
import ic2.core.item.armor.ItemArmorJetpack;
import ic2.core.ref.ItemName;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class GuiOverlayer
extends Gui {
    private final Minecraft mc;
    private int chargeproz;
    private static final ResourceLocation background = new ResourceLocation("ic2", "textures/gui/GUIOverlay.png");

    public GuiOverlayer(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderHotBar(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        ItemStack boots = this.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.FEET);
        ItemStack legs = this.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack chestplate = this.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack helm = this.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD);
        if (helm == null) {
            return;
        }
        if (helm.func_77973_b() != ItemName.quantum_helmet.getInstance() && helm.func_77973_b() != ItemName.nano_helmet.getInstance()) {
            return;
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(helm);
        Short HudMode = nbtData.func_74765_d("HudMode");
        boolean Nightvision = nbtData.func_74767_n("Nightvision");
        if (HudMode > 0) {
            ItemStack item;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            RenderHelper.func_74520_c();
            this.mc.func_110434_K().func_110577_a(background);
            this.func_73729_b(0, 0, 0, 0, 71, 69);
            if (helm.func_77973_b() == ItemName.quantum_helmet.getInstance()) {
                this.chargeproz = GuiOverlayer.mapCharge(helm);
                renderItem.func_175042_a(ItemName.quantum_helmet.getItemStack(), 5, 4);
            }
            if (helm.func_77973_b() == ItemName.nano_helmet.getInstance()) {
                this.chargeproz = GuiOverlayer.mapCharge(helm);
                renderItem.func_175042_a(ItemName.nano_helmet.getItemStack(), 5, 4);
            }
            this.mc.field_71466_p.func_78276_b(this.chargeproz + "%", 25, 9, 0xFFFFFF);
            if (Nightvision) {
                renderItem.func_175042_a(ItemName.nightvision_goggles.getItemStack(), 50, 4);
            }
            if (chestplate != null) {
                NBTTagCompound nbtDatachestplate = StackUtil.getOrCreateNbtData(chestplate);
                boolean jetpack = nbtDatachestplate.func_74767_n("jetpack");
                boolean hoverMode = nbtDatachestplate.func_74767_n("hoverMode");
                if (chestplate.func_77973_b() == ItemName.quantum_chestplate.getInstance()) {
                    this.chargeproz = GuiOverlayer.mapCharge(chestplate);
                    renderItem.func_175042_a(ItemName.quantum_chestplate.getItemStack(), 5, 20);
                }
                if (chestplate.func_77973_b() == ItemName.nano_chestplate.getInstance()) {
                    this.chargeproz = GuiOverlayer.mapCharge(chestplate);
                    renderItem.func_175042_a(ItemName.nano_chestplate.getItemStack(), 5, 20);
                }
                if (chestplate.func_77973_b() == ItemName.jetpack_electric.getInstance()) {
                    this.chargeproz = GuiOverlayer.mapCharge(chestplate);
                    renderItem.func_175042_a(ItemName.jetpack_electric.getItemStack(), 5, 20);
                }
                if (chestplate.func_77973_b() == ItemName.jetpack.getInstance()) {
                    this.chargeproz = (int)Util.map(((ItemArmorJetpack)chestplate.func_77973_b()).getCharge(chestplate), ((ItemArmorJetpack)chestplate.func_77973_b()).getMaxCharge(chestplate), 100.0);
                    renderItem.func_175042_a(ItemName.jetpack.getItemStack(), 5, 20);
                }
                if (chestplate.func_77973_b() == ItemName.batpack.getInstance()) {
                    this.chargeproz = GuiOverlayer.mapCharge(chestplate);
                    renderItem.func_175042_a(ItemName.batpack.getItemStack(), 5, 20);
                }
                if (chestplate.func_77973_b() == ItemName.energy_pack.getInstance()) {
                    this.chargeproz = GuiOverlayer.mapCharge(chestplate);
                    renderItem.func_175042_a(ItemName.energy_pack.getItemStack(), 5, 20);
                }
                if (chestplate.func_77973_b() == ItemName.cf_pack.getInstance()) {
                    this.chargeproz = (((ItemArmorCFPack)chestplate.func_77973_b()).getMaxDamage(chestplate) - ((ItemArmorCFPack)chestplate.func_77973_b()).getDamage(chestplate)) * 100 / ((ItemArmorCFPack)chestplate.func_77973_b()).getMaxDamage(chestplate);
                    renderItem.func_175042_a(ItemName.cf_pack.getItemStack(), 5, 20);
                }
                this.mc.field_71466_p.func_78276_b(this.chargeproz + "%", 25, 25, 0xFFFFFF);
                if (jetpack && !hoverMode) {
                    renderItem.func_175042_a(ItemName.jetpack.getItemStack(), 50, 20);
                }
                if (jetpack && hoverMode) {
                    renderItem.func_175042_a(ItemName.jetpack_electric.getItemStack(), 50, 20);
                }
            }
            if (legs != null) {
                if (legs.func_77973_b() == ItemName.quantum_leggings.getInstance()) {
                    this.chargeproz = GuiOverlayer.mapCharge(legs);
                    renderItem.func_175042_a(ItemName.quantum_leggings.getItemStack(), 5, 36);
                }
                if (legs.func_77973_b() == ItemName.nano_leggings.getInstance()) {
                    this.chargeproz = GuiOverlayer.mapCharge(legs);
                    renderItem.func_175042_a(ItemName.nano_leggings.getItemStack(), 5, 36);
                }
                this.mc.field_71466_p.func_78276_b(this.chargeproz + "%", 25, 41, 0xFFFFFF);
            }
            if (boots != null) {
                if (boots.func_77973_b() == ItemName.quantum_boots.getInstance()) {
                    this.chargeproz = GuiOverlayer.mapCharge(boots);
                    renderItem.func_175042_a(ItemName.quantum_boots.getItemStack(), 5, 52);
                }
                if (boots.func_77973_b() == ItemName.nano_boots.getInstance()) {
                    this.chargeproz = GuiOverlayer.mapCharge(boots);
                    renderItem.func_175042_a(ItemName.nano_boots.getItemStack(), 5, 52);
                }
                this.mc.field_71466_p.func_78276_b(this.chargeproz + "%", 25, 56, 0xFFFFFF);
            }
            if (HudMode == 2 && (item = this.mc.field_71439_g.func_184607_cu()) != null) {
                int l;
                renderItem.func_175042_a(item, 5, 74);
                this.mc.field_71466_p.func_78276_b(item.func_82833_r(), 30, 78, 0xFFFFFF);
                LinkedList<String> info = new LinkedList<String>();
                if (item.func_77973_b() instanceof IItemHudInfo) {
                    info.addAll(((IItemHudInfo)item.func_77973_b()).getHudInfo(item));
                    if (info.size() > 0) {
                        for (l = 0; l <= info.size() - 1; ++l) {
                            this.mc.field_71466_p.func_78276_b(((String)info.get(l)).toString(), 8, 83 + (l + 1) * 14, 0xFFFFFF);
                        }
                    }
                } else {
                    info.addAll(item.func_82840_a((EntityPlayer)this.mc.field_71439_g, true));
                    if (info.size() > 1) {
                        for (l = 1; l <= info.size() - 1; ++l) {
                            this.mc.field_71466_p.func_78276_b(((String)info.get(l)).toString(), 8, 83 + l * 14, 0xFFFFFF);
                        }
                    }
                }
            }
        }
        RenderHelper.func_74518_a();
    }

    private static final int mapCharge(ItemStack stack) {
        double charge = ElectricItem.manager.getCharge(stack);
        double maxCharge = charge + ElectricItem.manager.charge(stack, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true);
        return (int)Util.map(charge, maxCharge, 100.0);
    }
}

