/*
 * Decompiled with CFR 0.152.
 */
package at.chaosfield.openradio.entity;

import at.chaosfield.openradio.OpenRadio;
import at.chaosfield.openradio.block.LaserBlock;
import at.chaosfield.openradio.interfaces.ILaserModifier;
import at.chaosfield.openradio.render.LaserParticle;
import at.chaosfield.openradio.tileentity.LaserTileEntity;
import at.chaosfield.openradio.util.DamageSourceLaser;
import at.chaosfield.openradio.util.Location;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LaserEntity
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    private List<Location> appliedModifier = new ArrayList<Location>();
    private Location senderLaser;
    private Location locNow;
    private double distance = 1.0;
    private double maxDistance = 0.0;
    private double multiplier = 1.0;
    private float colorR = 1.0f;
    private float colorG = 0.0f;
    private float colorB = 0.0f;
    private float colorA = 1.0f;
    private int laserTier = 1;
    Vec3d lastParticle = new Vec3d(0.0, 0.0, 0.0);
    private int lastParticleDim;

    public LaserEntity(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.func_82142_c(true);
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double renderDistance) {
        return false;
    }

    public LaserEntity(World world, double x, double y, double z, double accX, double accY, double accZ, int laserDim, int laserX, int laserY, int laserZ, double maxDistance, int laserTier) {
        this(world);
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(x, y, z);
        this.field_70159_w = accX;
        this.field_70181_x = accY;
        this.field_70179_y = accZ;
        this.senderLaser = new Location(laserDim, laserX, laserY, laserZ);
        this.maxDistance = maxDistance;
        if (!this.field_70170_p.field_72995_K) {
            this.locNow = new Location(world.field_73011_w.getDimension(), (int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
        }
        this.lastParticle = new Vec3d(x, y, z);
        this.lastParticleDim = laserDim;
        this.laserTier = laserTier;
    }

    public void func_70186_c(double accX, double accY, double accZ, float accMult, float accRand) {
        float f2 = MathHelper.func_76133_a((double)(accX * accX + accY * accY + accZ * accZ));
        accX /= (double)f2;
        accY /= (double)f2;
        accZ /= (double)f2;
        accX += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)accRand;
        accY += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)accRand;
        accZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)accRand;
        this.field_70159_w = accX *= (double)accMult;
        this.field_70181_x = accY *= (double)accMult;
        this.field_70179_y = accZ *= (double)accMult;
        float f3 = MathHelper.func_76133_a((double)(accX * accX + accZ * accZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(accX, accZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(accY, f3) * 180.0 / Math.PI);
    }

    public void func_70016_h(double accX, double accY, double accZ) {
        this.field_70159_w = accX;
        this.field_70181_x = accY;
        this.field_70179_y = accZ;
    }

    public void func_70030_z() {
        Vec3d nextPosVec;
        Vec3d posVec;
        RayTraceResult movingobjectposition;
        block31: {
            block32: {
                block30: {
                    this.field_70142_S = this.field_70165_t;
                    this.field_70137_T = this.field_70163_u;
                    this.field_70136_U = this.field_70161_v;
                    this.field_70170_p.field_72984_F.func_76320_a("entityBaseTick");
                    this.field_70141_P = this.field_70140_Q;
                    this.field_70169_q = this.field_70165_t;
                    this.field_70167_r = this.field_70163_u;
                    this.field_70166_s = this.field_70161_v;
                    this.field_70127_C = this.field_70125_A;
                    this.field_70126_B = this.field_70177_z;
                    if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
                        this.field_70170_p.field_72984_F.func_76320_a("portal");
                        MinecraftServer minecraftserver = this.field_70170_p.func_73046_m();
                        int i = this.func_82145_z();
                        if (this.field_71087_bX) {
                            if (minecraftserver != null && minecraftserver.func_71255_r()) {
                                if (this.func_184187_bx() == null && this.field_82153_h++ >= i) {
                                    this.field_82153_h = i;
                                    this.field_71088_bW = this.func_82147_ab();
                                    int j = this.field_70170_p.field_73011_w.getDimension() == -1 ? 0 : -1;
                                    this.func_184204_a(j);
                                }
                                this.field_71087_bX = false;
                            }
                        } else {
                            if (this.field_82153_h > 0) {
                                this.field_82153_h -= 4;
                            }
                            if (this.field_82153_h < 0) {
                                this.field_82153_h = 0;
                            }
                        }
                        if (this.field_71088_bW > 0) {
                            --this.field_71088_bW;
                        }
                        this.field_70170_p.field_72984_F.func_76319_b();
                    }
                    if (this.field_70163_u < -64.0) {
                        this.func_70076_C();
                    }
                    this.field_70148_d = false;
                    this.field_70170_p.field_72984_F.func_76319_b();
                    if (this.field_70170_p.field_72995_K) break block30;
                    if (this.locNow != null) {
                        if ((int)Math.floor(this.field_70165_t) != this.locNow.getX() || (int)Math.floor(this.field_70163_u) != this.locNow.getY() || (int)Math.floor(this.field_70161_v) != this.locNow.getZ() || this.field_70170_p.field_73011_w.getDimension() != this.locNow.getDim()) {
                            this.locNow.setX((int)Math.floor(this.field_70165_t));
                            this.locNow.setY((int)Math.floor(this.field_70163_u));
                            this.locNow.setZ((int)Math.floor(this.field_70161_v));
                            this.locNow.setDim(this.field_70170_p.field_73011_w.getDimension());
                            Block block = DimensionManager.getWorld((int)this.locNow.getDim()).func_180495_p(this.locNow.getPos()).func_177230_c();
                            if (block.isAir(DimensionManager.getWorld((int)this.locNow.getDim()).func_180495_p(this.locNow.getPos()), (IBlockAccess)DimensionManager.getWorld((int)this.locNow.getDim()), this.locNow.getPos())) {
                                this.distance += OpenRadio.instance.settings.DistancePerAir;
                            } else if (!block.func_176194_O().func_177621_b().func_185904_a().func_76220_a()) {
                                this.distance += OpenRadio.instance.settings.DistancePerTransparent;
                            }
                        }
                    } else {
                        this.locNow = new Location(this.field_70170_p.field_73011_w.getDimension(), (int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v));
                    }
                    if (this.distance > this.maxDistance * this.multiplier) {
                        this.func_70106_y();
                    }
                    break block31;
                }
                if (this.lastParticleDim != this.field_70170_p.field_73011_w.getDimension()) break block32;
                Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (!(vec3d.func_72438_d(this.lastParticle) >= 1.0)) break block31;
            }
            this.lastParticleDim = this.field_70170_p.field_73011_w.getDimension();
            this.lastParticle = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.renderParticle();
        }
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y));
            for (Entity entity : list) {
                if (!(entity instanceof EntityLivingBase) || !entity.func_70067_L() || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) continue;
                switch (this.laserTier) {
                    case 2: {
                        entity.func_70097_a(DamageSourceLaser.DAMAGE_SOURCE_LASER, 3.0f);
                        entity.func_70015_d(1);
                        break;
                    }
                    case 3: {
                        entity.func_70097_a(DamageSourceLaser.DAMAGE_SOURCE_LASER, 6.0f);
                        entity.func_70015_d(10);
                        break;
                    }
                }
            }
        }
        if ((movingobjectposition = this.field_70170_p.func_72933_a(posVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), nextPosVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y))) != null && movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (this.field_70170_p.func_180495_p(movingobjectposition.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(this.func_180425_c());
            } else {
                if (movingobjectposition.func_178782_a().func_177958_n() == MathHelper.func_76128_c((double)this.field_70165_t) && movingobjectposition.func_178782_a().func_177956_o() == MathHelper.func_76128_c((double)this.field_70163_u) && movingobjectposition.func_178782_a().func_177952_p() == MathHelper.func_76128_c((double)this.field_70161_v)) {
                    movingobjectposition.field_178784_b = movingobjectposition.field_178784_b.func_176734_d();
                }
                this.onImpact(movingobjectposition);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void setTier(int laserTier) {
        this.colorR = OpenRadio.instance.settings.LaserColor[laserTier - 1][0];
        this.colorG = OpenRadio.instance.settings.LaserColor[laserTier - 1][1];
        this.colorB = OpenRadio.instance.settings.LaserColor[laserTier - 1][2];
        this.colorA = OpenRadio.instance.settings.LaserColor[laserTier - 1][3];
    }

    public void addDistance(int blocks) {
        this.distance += (double)blocks;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderParticle() {
        LaserParticle particle = new LaserParticle(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.75f, this.colorR, this.colorG, this.colorB, this.colorA);
        particle.func_70538_b(this.colorR, this.colorG, this.colorB);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
        tagCompound.func_74783_a("senderLaser", new int[]{this.senderLaser.getDim(), this.senderLaser.getX(), this.senderLaser.getY(), this.senderLaser.getZ()});
        tagCompound.func_74782_a("color", (NBTBase)this.func_70049_a(new float[]{this.colorR, this.colorG, this.colorB, this.colorA}));
        tagCompound.func_74768_a("lastParticleDim", this.lastParticleDim);
        tagCompound.func_74780_a("distance", this.distance);
        tagCompound.func_74780_a("maxDistance", this.maxDistance);
        tagCompound.func_74780_a("multiplier", this.multiplier);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        if (tagCompound.func_150297_b("direction", 9)) {
            NBTTagList nbttaglist = tagCompound.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist.func_150309_d(0);
            this.field_70181_x = nbttaglist.func_150309_d(1);
            this.field_70179_y = nbttaglist.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
        int[] sender = tagCompound.func_74759_k("senderLaser");
        this.senderLaser = new Location(sender[0], sender[1], sender[2], sender[3]);
        NBTTagList nbttaglist = tagCompound.func_150295_c("color", 5);
        this.colorR = nbttaglist.func_150308_e(0);
        this.colorG = nbttaglist.func_150308_e(1);
        this.colorB = nbttaglist.func_150308_e(2);
        this.colorA = nbttaglist.func_150308_e(3);
        this.lastParticleDim = tagCompound.func_74762_e("lastParticleDim");
        this.distance = tagCompound.func_74769_h("distance");
        this.maxDistance = tagCompound.func_74769_h("maxDistance");
        this.multiplier = tagCompound.func_74769_h("multiplier");
    }

    public boolean func_70039_c(NBTTagCompound nbtTagCompound) {
        return false;
    }

    protected void onImpact(RayTraceResult mop) {
        TileEntity senderLaserTe = null;
        if (!this.field_70170_p.field_72995_K) {
            senderLaserTe = DimensionManager.getWorld((int)this.senderLaser.getDim()).func_175625_s(this.senderLaser.getPos());
        }
        if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            Block hitBlock = this.field_70170_p.func_180495_p(mop.func_178782_a()).func_177230_c();
            if (hitBlock instanceof LaserBlock && senderLaserTe instanceof LaserTileEntity) {
                TileEntity te = this.field_70170_p.func_175625_s(mop.func_178782_a());
                if (te instanceof LaserTileEntity) {
                    if (mop.field_178784_b.func_176745_a() == te.func_145832_p()) {
                        ((LaserTileEntity)senderLaserTe).setDestination(this.field_70170_p.field_73011_w.getDimension(), mop.func_178782_a(), this.distance);
                    } else {
                        ((LaserTileEntity)senderLaserTe).disconnect();
                    }
                } else {
                    ((LaserTileEntity)senderLaserTe).disconnect();
                }
                this.func_70106_y();
            } else if (hitBlock instanceof ILaserModifier) {
                if (!this.appliedModifier.contains(new Location(this.field_71093_bK, mop.func_178782_a()))) {
                    this.appliedModifier.add(new Location(this.field_71093_bK, mop.func_178782_a()));
                    ((ILaserModifier)hitBlock).hitByLaser(this, mop.func_178782_a(), this.field_70170_p, mop.field_178784_b);
                }
            } else if (this.field_70170_p.func_180495_p(mop.func_178782_a()).func_185914_p()) {
                this.func_70106_y();
                if (senderLaserTe instanceof LaserTileEntity) {
                    ((LaserTileEntity)senderLaserTe).disconnect();
                }
            }
        } else {
            this.func_70106_y();
            if (senderLaserTe instanceof LaserTileEntity) {
                ((LaserTileEntity)senderLaserTe).disconnect();
            }
        }
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.laserTier);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.laserTier = additionalData.readInt();
        this.setTier(this.laserTier);
    }
}

