/*
 * Decompiled with CFR 0.152.
 */
package at.chaosfield.openradio.block;

import at.chaosfield.openradio.OpenRadio;
import at.chaosfield.openradio.entity.LaserEntity;
import at.chaosfield.openradio.gui.CreativeTab;
import at.chaosfield.openradio.interfaces.ILaserModifier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LensBlock
extends Block
implements ILaserModifier {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private static final AxisAlignedBB AABB_X = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    private static final AxisAlignedBB AABB_Y = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    private static final AxisAlignedBB AABB_Z = new AxisAlignedBB(0.0, 0.375, 0.0, 1.0, 0.625, 1.0);

    public LensBlock(int tier) {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149663_c("openradio.lenst" + tier);
        this.func_149711_c(3.0f);
        this.func_149647_a(CreativeTab.instance);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing.Axis axis = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k();
        if (axis == EnumFacing.Axis.X) {
            return AABB_X;
        }
        if (axis == EnumFacing.Axis.Z) {
            return AABB_Y;
        }
        if (axis == EnumFacing.Axis.Y) {
            return AABB_Z;
        }
        return AABB_X;
    }

    @Override
    public void hitByLaser(LaserEntity laserEntity, BlockPos pos, World world, EnumFacing direction) {
        if (!world.field_72995_K) {
            if (((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING)).func_176740_k() == direction.func_176740_k()) {
                if (laserEntity.getMaxDistance() * (laserEntity.getMultiplier() + OpenRadio.instance.settings.LensMultiplierTier[this.getTier() - 1]) <= (OpenRadio.instance.settings.LensMultiplierTier[2] + 1.0) * 2.0 * OpenRadio.instance.settings.LaserMaxDistanceTier[2]) {
                    laserEntity.setMultiplier(laserEntity.getMultiplier() + OpenRadio.instance.settings.LensMultiplierTier[this.getTier() - 1]);
                }
            } else {
                laserEntity.func_70106_y();
            }
        }
    }

    private int getTier() {
        if (this.func_149739_a().equals("tile.openradio.lenst1")) {
            return 1;
        }
        if (this.func_149739_a().equals("tile.openradio.lenst2")) {
            return 2;
        }
        if (this.func_149739_a().equals("tile.openradio.lenst3")) {
            return 3;
        }
        return 1;
    }
}

