/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock.tesr;

import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseledTESR;
import mod.chiselsandbits.render.chiseledblock.tesr.TileList;
import mod.chiselsandbits.render.chiseledblock.tesr.TileRenderCache;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileRenderChunk
extends TileRenderCache {
    private final TileList tiles = new TileList();
    public boolean singleInstanceMode = false;
    AxisAlignedBB renderBox = null;

    public void register(TileEntityBlockChiseledTESR which) {
        if (which == null) {
            throw new NullPointerException();
        }
        this.rebuild(true);
        this.tiles.getWriteLock().lock();
        try {
            this.tiles.add(which);
        }
        finally {
            this.tiles.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuild(boolean conversion) {
        if (this.singleInstanceMode) {
            this.tiles.getReadLock().lock();
            try {
                for (TileEntityBlockChiseledTESR te : this.tiles) {
                    te.getCache().rebuild(conversion);
                }
            }
            finally {
                this.tiles.getReadLock().unlock();
            }
            return;
        }
        super.rebuild(conversion);
    }

    public void unregister(TileEntityBlockChiseledTESR which) {
        this.tiles.getWriteLock().lock();
        try {
            this.tiles.remove(which);
        }
        finally {
            this.tiles.getWriteLock().unlock();
        }
        super.rebuild(true);
    }

    public BlockPos chunkOffset() {
        this.tiles.getReadLock().lock();
        try {
            if (this.getTiles().isEmpty()) {
                BlockPos blockPos = BlockPos.field_177992_a;
                return blockPos;
            }
        }
        finally {
            this.tiles.getReadLock().unlock();
        }
        int bitMask = -16;
        BlockPos tilepos = ((TileEntityBlockChiseledTESR)this.getTiles().get(0)).func_174877_v();
        return new BlockPos(tilepos.func_177958_n() & 0xFFFFFFF0, tilepos.func_177956_o() & 0xFFFFFFF0, tilepos.func_177952_p() & 0xFFFFFFF0);
    }

    public AxisAlignedBB getBounds() {
        if (this.renderBox == null) {
            BlockPos p = this.chunkOffset();
            this.renderBox = new AxisAlignedBB((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)(p.func_177958_n() + 16), (double)(p.func_177956_o() + 16), (double)(p.func_177952_p() + 16));
        }
        return this.renderBox;
    }

    public TileList getTiles() {
        return this.tiles;
    }
}

