/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateInstance;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.chiseledblock.data.VoxelNeighborRenderTracker;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.render.BaseBakedBlockModel;
import mod.chiselsandbits.render.BaseSmartModel;
import mod.chiselsandbits.render.ModelCombined;
import mod.chiselsandbits.render.NullBakedModel;
import mod.chiselsandbits.render.cache.CacheMap;
import mod.chiselsandbits.render.chiseledblock.ChiselLayer;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockBaked;
import mod.chiselsandbits.render.chiseledblock.ChiselsAndBitsBakedQuad;
import mod.chiselsandbits.render.chiseledblock.ModelRenderState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.client.FMLClientHandler;

public class ChiseledBlockSmartModel
extends BaseSmartModel
implements ICacheClearable {
    static final CacheMap<VoxelBlobStateReference, ChiseledBlockBaked> solidCache = new CacheMap();
    static final CacheMap<ItemStack, IBakedModel> itemToModel = new CacheMap();
    static final CacheMap<VoxelBlobStateInstance, Integer> sideCache = new CacheMap();
    private static final Map<ModelRenderState, ChiseledBlockBaked>[] modelCache = new Map[5];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSides(TileEntityBlockChiseled te) {
        VoxelBlobStateReference ref = te.getBlobStateReference();
        Integer out = null;
        if (ref == null) {
            return 0;
        }
        CacheMap<VoxelBlobStateInstance, Integer> cacheMap = sideCache;
        synchronized (cacheMap) {
            out = sideCache.get(ref.getInstance());
            if (out == null) {
                VoxelBlob blob = ref.getVoxelBlob();
                blob.filter(BlockRenderLayer.SOLID);
                blob.filterFluids(false);
                out = blob.getSideFlags(0, 15, 256);
                sideCache.put(ref.getInstance(), out);
            }
        }
        return out;
    }

    public static ChiseledBlockBaked getCachedModel(TileEntityBlockChiseled te, ChiselLayer layer) {
        IExtendedBlockState myState = te.getBasicState();
        VoxelBlobStateReference data = (VoxelBlobStateReference)myState.getValue(BlockChiseled.UProperty_VoxelBlob);
        VoxelNeighborRenderTracker rTracker = (VoxelNeighborRenderTracker)myState.getValue(BlockChiseled.UProperty_VoxelNeighborState);
        Integer blockP = (Integer)myState.getValue(BlockChiseled.UProperty_Primary_BlockState);
        blockP = blockP == null ? 0 : blockP;
        return ChiseledBlockSmartModel.getCachedModel(blockP, data, ChiseledBlockSmartModel.getRenderState(rTracker, data), layer, ChiseledBlockSmartModel.getModelFormat());
    }

    private static VertexFormat getModelFormat() {
        return ChiseledBlockSmartModel.hasOptifine() ? DefaultVertexFormats.field_176599_b : ChiselsAndBitsBakedQuad.VERTEX_FORMAT;
    }

    private static boolean hasOptifine() {
        return FMLClientHandler.instance().hasOptifine();
    }

    private static ChiseledBlockBaked getCachedModel(Integer blockP, VoxelBlobStateReference data, ModelRenderState mrs, ChiselLayer layer, VertexFormat format) {
        if (data == null) {
            return new ChiseledBlockBaked(blockP, layer, data, new ModelRenderState(null), format);
        }
        ChiseledBlockBaked out = null;
        if (format == ChiseledBlockSmartModel.getModelFormat()) {
            if (layer == ChiselLayer.SOLID) {
                out = solidCache.get(data);
            } else {
                ChiseledBlockBaked chiseledBlockBaked = out = mrs == null ? null : modelCache[layer.ordinal()].get(mrs);
            }
        }
        if (out == null) {
            out = new ChiseledBlockBaked(blockP, layer, data, mrs, format);
            if (out.isEmpty()) {
                out = ChiseledBlockBaked.breakingParticleModel(layer, blockP);
            }
            if (format == ChiseledBlockSmartModel.getModelFormat()) {
                if (layer == ChiselLayer.SOLID) {
                    solidCache.put(data, out);
                } else if (mrs != null) {
                    modelCache[layer.ordinal()].put(mrs, out);
                }
            }
        }
        return out;
    }

    @Override
    public IBakedModel handleBlockState(IBlockState state, long rand) {
        if (state == null) {
            return NullBakedModel.instance;
        }
        IExtendedBlockState myState = (IExtendedBlockState)state;
        VoxelBlobStateReference data = (VoxelBlobStateReference)myState.getValue(BlockChiseled.UProperty_VoxelBlob);
        VoxelNeighborRenderTracker rTracker = (VoxelNeighborRenderTracker)myState.getValue(BlockChiseled.UProperty_VoxelNeighborState);
        Integer blockP = (Integer)myState.getValue(BlockChiseled.UProperty_Primary_BlockState);
        blockP = blockP == null ? 0 : blockP;
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (layer == null) {
            IBakedModel[] models = new ChiseledBlockBaked[ChiselLayer.values().length];
            int o = 0;
            for (ChiselLayer l : ChiselLayer.values()) {
                models[o++] = ChiseledBlockSmartModel.getCachedModel(blockP, data, ChiseledBlockSmartModel.getRenderState(rTracker, data), l, ChiseledBlockSmartModel.getModelFormat());
            }
            return new ModelCombined(models);
        }
        if (rTracker != null && rTracker.isDynamic()) {
            return ChiseledBlockBaked.breakingParticleModel(ChiselLayer.fromLayer(layer, false), blockP);
        }
        BaseBakedBlockModel baked = null;
        int faces = 0;
        if (layer == BlockRenderLayer.SOLID) {
            ChiseledBlockBaked a = ChiseledBlockSmartModel.getCachedModel(blockP, data, ChiseledBlockSmartModel.getRenderState(rTracker, data), ChiselLayer.fromLayer(layer, false), ChiseledBlockSmartModel.getModelFormat());
            ChiseledBlockBaked b = ChiseledBlockSmartModel.getCachedModel(blockP, data, ChiseledBlockSmartModel.getRenderState(rTracker, data), ChiselLayer.fromLayer(layer, true), ChiseledBlockSmartModel.getModelFormat());
            faces = a.faceCount() + b.faceCount();
            baked = a.isEmpty() ? b : (b.isEmpty() ? a : new ModelCombined(a, b));
        } else {
            ChiseledBlockBaked t = ChiseledBlockSmartModel.getCachedModel(blockP, data, ChiseledBlockSmartModel.getRenderState(rTracker, data), ChiselLayer.fromLayer(layer, false), ChiseledBlockSmartModel.getModelFormat());
            faces = t.faceCount();
            baked = t;
        }
        if (rTracker != null) {
            rTracker.setAbovelimit(layer, faces);
        }
        return baked;
    }

    private static ModelRenderState getRenderState(VoxelNeighborRenderTracker renderTracker, VoxelBlobStateReference data) {
        if (renderTracker != null) {
            return renderTracker.getRenderState(data);
        }
        return null;
    }

    @Override
    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
        IBakedModel mdl = itemToModel.get(stack);
        if (mdl != null) {
            return mdl;
        }
        NBTTagCompound c = stack.func_77978_p();
        if (c == null) {
            return this;
        }
        if ((c = c.func_74775_l("BlockEntityTag")) == null) {
            return this;
        }
        byte[] data = c.func_74770_j("v");
        byte[] vdata = c.func_74770_j("X");
        Integer blockP = c.func_74762_e("b");
        if ((vdata == null || vdata.length == 0) && data != null && data.length > 0) {
            VoxelBlob xx = new VoxelBlob();
            try {
                xx.fromLegacyByteArray(data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            vdata = xx.blobToBytes(VoxelBlob.VERSION_COMPACT);
        }
        IBakedModel[] models = new IBakedModel[ChiselLayer.values().length];
        for (ChiselLayer l : ChiselLayer.values()) {
            models[l.ordinal()] = ChiseledBlockSmartModel.getCachedModel(blockP, new VoxelBlobStateReference(vdata, 0L), null, l, DefaultVertexFormats.field_176599_b);
        }
        mdl = new ModelCombined(models);
        itemToModel.put(stack, mdl);
        return mdl;
    }

    @Override
    public void clearCache() {
        for (ChiselLayer l : ChiselLayer.values()) {
            modelCache[l.ordinal()].clear();
        }
        solidCache.clear();
        itemToModel.clear();
    }

    static {
        int count = ChiselLayer.values().length;
        if (modelCache.length != count) {
            throw new RuntimeException("Invalid Number of BlockRenderLayer");
        }
        for (ChiselLayer l : ChiselLayer.values()) {
            ChiseledBlockSmartModel.modelCache[l.ordinal()] = Collections.synchronizedMap(new WeakHashMap());
        }
    }
}

